/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.example.soundattract.SoundAttractMod;
import com.example.soundattract.config.SoundAttractConfig;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;

public class ConfigHelper {
    private static final int CURRENT_SCHEMA_VERSION = 6;

    public static void register() {
        Path configPath = FMLPaths.CONFIGDIR.get().resolve("soundattract-common.toml");
        ConfigHelper.updateAndMigrateConfig(configPath);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)SoundAttractConfig.COMMON_SPEC, "soundattract-common.toml");
    }

    private static void repairTruncatedListsAndEnsurePointBlank(CommentedFileConfig config) {
        ArrayList<String> defs;
        String defPath;
        ArrayList<String> wl;
        String wlPath;
        boolean truncated = false;
        try {
            wlPath = "Sounds White List.soundIdWhitelist";
            wl = (ArrayList<String>)config.get("Sounds White List.soundIdWhitelist");
            if (wl != null && wl.size() == 1 && "pointblank:gun_action".equals(String.valueOf(wl.get(0)))) {
                config.remove("Sounds White List.soundIdWhitelist");
                truncated = true;
                SoundAttractMod.LOGGER.info("Repair: detected truncated soundIdWhitelist; restoring defaults.");
            }
        }
        catch (Exception e) {
            SoundAttractMod.LOGGER.warn("Repair: failed checking soundIdWhitelist for truncation", (Throwable)e);
        }
        try {
            defPath = "sound_defaults.soundDefaults";
            defs = (ArrayList<String>)config.get("sound_defaults.soundDefaults");
            if (defs != null && defs.size() == 1 && "pointblank:gun_action;15;5".equals(String.valueOf(defs.get(0)))) {
                config.remove("sound_defaults.soundDefaults");
                truncated = true;
                SoundAttractMod.LOGGER.info("Repair: detected truncated soundDefaults; restoring defaults.");
            }
        }
        catch (Exception e) {
            SoundAttractMod.LOGGER.warn("Repair: failed checking soundDefaults for truncation", (Throwable)e);
        }
        if (truncated) {
            try {
                SoundAttractConfig.COMMON_SPEC.correct((CommentedConfig)config);
                SoundAttractMod.LOGGER.info("Repair: defaults restored for truncated lists.");
            }
            catch (Exception e) {
                SoundAttractMod.LOGGER.warn("Repair: failed restoring defaults after truncation fix", (Throwable)e);
            }
        }
        try {
            String pbWl;
            wlPath = "Sounds White List.soundIdWhitelist";
            wl = (List)config.get("Sounds White List.soundIdWhitelist");
            if (wl == null) {
                wl = new ArrayList<String>();
                config.set("Sounds White List.soundIdWhitelist", wl);
            }
            if (!wl.contains(pbWl = "pointblank:gun_action")) {
                wl.add(pbWl);
                SoundAttractMod.LOGGER.info("Repair: appended '{}' to {}.", (Object)pbWl, (Object)"Sounds White List.soundIdWhitelist");
            }
        }
        catch (Exception e) {
            SoundAttractMod.LOGGER.warn("Repair: failed ensuring pointblank in soundIdWhitelist", (Throwable)e);
        }
        try {
            String pbDef;
            defPath = "sound_defaults.soundDefaults";
            defs = (List)config.get("sound_defaults.soundDefaults");
            if (defs == null) {
                defs = new ArrayList<String>();
                config.set("sound_defaults.soundDefaults", defs);
            }
            if (!defs.contains(pbDef = "pointblank:gun_action;15;5")) {
                defs.add(pbDef);
                SoundAttractMod.LOGGER.info("Repair: appended '{}' to {}.", (Object)pbDef, (Object)"sound_defaults.soundDefaults");
            }
        }
        catch (Exception e) {
            SoundAttractMod.LOGGER.warn("Repair: failed ensuring pointblank in soundDefaults", (Throwable)e);
        }
    }

    private static void updateAndMigrateConfig(Path path) {
        SoundAttractMod.LOGGER.debug("Checking config file at {} for corrections and migrations.", (Object)path);
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        configData.load();
        int originalVersion = configData.getOptionalInt("internal.configSchemaVersion").orElse(0);
        if (!SoundAttractConfig.COMMON_SPEC.isCorrect((CommentedConfig)configData)) {
            SoundAttractMod.LOGGER.info("Configuration file is missing values. Correcting and saving...");
            SoundAttractConfig.COMMON_SPEC.correct((CommentedConfig)configData);
            configData.save();
            SoundAttractMod.LOGGER.info("Configuration file updated successfully.");
        } else {
            SoundAttractMod.LOGGER.debug("Configuration file is up to date.");
        }
        ConfigHelper.repairTruncatedListsAndEnsurePointBlank(configData);
        ConfigHelper.migrateConfig(configData, originalVersion);
        configData.close();
    }

    private static void migrateConfig(CommentedFileConfig config, int originalVersion) {
        if (originalVersion < 6) {
            SoundAttractMod.LOGGER.info("Old config version ({}) detected. Migrating to version {}...", (Object)originalVersion, (Object)6);
            if (originalVersion < 1) {
                // empty if block
            }
            if (originalVersion < 3) {
                ConfigHelper.renameKey((CommentedConfig)config, "muffling.specialMobProfilesRaw", "profiles.specialMobProfilesRaw");
                ConfigHelper.renameKey((CommentedConfig)config, "muffling.specialPlayerProfilesRaw", "profiles.specialPlayerProfilesRaw");
            }
            if (originalVersion < 6) {
                ArrayList<String> defs;
                String defPath;
                ArrayList<String> wl;
                String wlPath;
                boolean correctedTruncatedLists = false;
                try {
                    wlPath = "Sounds White List.soundIdWhitelist";
                    wl = (ArrayList<String>)config.get("Sounds White List.soundIdWhitelist");
                    if (wl != null && wl.size() == 1 && "pointblank:gun_action".equals(String.valueOf(wl.get(0)))) {
                        config.remove("Sounds White List.soundIdWhitelist");
                        correctedTruncatedLists = true;
                        SoundAttractMod.LOGGER.info("Migration v6: detected truncated soundIdWhitelist from v4.1.3; restoring defaults.");
                    }
                }
                catch (Exception e) {
                    SoundAttractMod.LOGGER.warn("Migration v6: failed checking soundIdWhitelist for truncation", (Throwable)e);
                }
                try {
                    defPath = "sound_defaults.soundDefaults";
                    defs = (ArrayList<String>)config.get("sound_defaults.soundDefaults");
                    if (defs != null && defs.size() == 1 && "pointblank:gun_action;15;5".equals(String.valueOf(defs.get(0)))) {
                        config.remove("sound_defaults.soundDefaults");
                        correctedTruncatedLists = true;
                        SoundAttractMod.LOGGER.info("Migration v6: detected truncated soundDefaults from v4.1.3; restoring defaults.");
                    }
                }
                catch (Exception e) {
                    SoundAttractMod.LOGGER.warn("Migration v6: failed checking soundDefaults for truncation", (Throwable)e);
                }
                if (correctedTruncatedLists) {
                    try {
                        SoundAttractConfig.COMMON_SPEC.correct((CommentedConfig)config);
                        SoundAttractMod.LOGGER.info("Migration v6: defaults restored for truncated lists.");
                    }
                    catch (Exception e) {
                        SoundAttractMod.LOGGER.warn("Migration v6: failed restoring defaults after truncation fix", (Throwable)e);
                    }
                }
                try {
                    String gunAction;
                    wlPath = "Sounds White List.soundIdWhitelist";
                    wl = (List)config.get("Sounds White List.soundIdWhitelist");
                    if (wl == null) {
                        wl = new ArrayList<String>();
                        config.set("Sounds White List.soundIdWhitelist", wl);
                    }
                    if (!wl.contains(gunAction = "pointblank:gun_action")) {
                        wl.add(gunAction);
                        SoundAttractMod.LOGGER.info("Migration v6: appended '{}' to {}.", (Object)gunAction, (Object)"Sounds White List.soundIdWhitelist");
                    }
                }
                catch (Exception e) {
                    SoundAttractMod.LOGGER.warn("Migration v6: failed updating soundIdWhitelist", (Throwable)e);
                }
                try {
                    String defEntry;
                    defPath = "sound_defaults.soundDefaults";
                    defs = (List)config.get("sound_defaults.soundDefaults");
                    if (defs == null) {
                        defs = new ArrayList<String>();
                        config.set("sound_defaults.soundDefaults", defs);
                    }
                    if (!defs.contains(defEntry = "pointblank:gun_action;15;5")) {
                        defs.add(defEntry);
                        SoundAttractMod.LOGGER.info("Migration v6: appended '{}' to {}.", (Object)defEntry, (Object)"sound_defaults.soundDefaults");
                    }
                }
                catch (Exception e) {
                    SoundAttractMod.LOGGER.warn("Migration v6: failed updating soundDefaults", (Throwable)e);
                }
            }
            config.set("internal.configSchemaVersion", (Object)6);
            SoundAttractMod.LOGGER.info("Config migration complete.");
        }
    }

    private static void renameKey(CommentedConfig config, String oldPath, String newPath) {
        if (config.contains(oldPath)) {
            Object value = config.get(oldPath);
            config.set(newPath, value);
            config.remove(oldPath);
            SoundAttractMod.LOGGER.debug("Migrated config key '{}' to '{}'.", (Object)oldPath, (Object)newPath);
        }
    }
}

