/*
 * Decompiled with CFR 0.152.
 */
package com.min01.gravityapi.api;

import com.min01.gravityapi.api.GravityChangerAPI;
import com.min01.gravityapi.util.RotationUtil;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GravityNodeEvaluator
extends WalkNodeEvaluator {
    private Direction gravityDirection = Direction.DOWN;
    private final Direction[] horizontalDirections = new Direction[4];
    private final Object2BooleanMap<AABB> collisionCache = new Object2BooleanOpenHashMap();

    public void m_6028_(PathNavigationRegion p_77620_, Mob p_77621_) {
        this.collisionCache.clear();
        super.m_6028_(p_77620_, p_77621_);
        this.gravityDirection = GravityChangerAPI.getGravityDirection((Entity)p_77621_);
        this.updateHorizontalDirections();
    }

    private void updateHorizontalDirections() {
        this.horizontalDirections[0] = RotationUtil.dirPlayerToWorld(Direction.NORTH, this.gravityDirection);
        this.horizontalDirections[1] = RotationUtil.dirPlayerToWorld(Direction.SOUTH, this.gravityDirection);
        this.horizontalDirections[2] = RotationUtil.dirPlayerToWorld(Direction.WEST, this.gravityDirection);
        this.horizontalDirections[3] = RotationUtil.dirPlayerToWorld(Direction.EAST, this.gravityDirection);
    }

    public Node m_7171_() {
        BlockPos blockPos;
        block9: {
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            blockPos = this.f_77313_.m_20183_();
            BlockState blockstate = this.f_77312_.m_8055_((BlockPos)blockpos$mutableblockpos.m_122190_((Vec3i)blockPos));
            if (!this.f_77313_.m_203441_(blockstate.m_60819_())) {
                if (this.m_77361_() && this.f_77313_.m_20069_()) {
                    while (true) {
                        if (!blockstate.m_60713_(Blocks.f_49990_) && blockstate.m_60819_() != Fluids.f_76193_.m_76068_(false)) {
                            blockPos = blockPos.m_121945_(this.gravityDirection);
                            break block9;
                        }
                        blockPos = blockPos.m_121945_(this.gravityDirection.m_122424_());
                        blockstate = this.f_77312_.m_8055_((BlockPos)blockpos$mutableblockpos.m_122190_((Vec3i)blockPos));
                    }
                }
                if (this.f_77313_.m_20096_()) {
                    blockPos = this.f_77313_.m_20183_();
                } else {
                    int i = 0;
                    BlockPos blockpos = this.f_77313_.m_20183_();
                    while ((this.f_77312_.m_8055_(blockpos).m_60795_() || this.f_77312_.m_8055_(blockpos).m_60647_((BlockGetter)this.f_77312_, blockpos, PathComputationType.LAND)) && i < this.f_77313_.f_19853_.m_151558_()) {
                        ++i;
                        blockpos = blockpos.m_121945_(this.gravityDirection);
                    }
                    blockPos = blockpos.m_121945_(this.gravityDirection.m_122424_());
                }
            } else {
                while (this.f_77313_.m_203441_(blockstate.m_60819_())) {
                    blockPos = blockPos.m_121945_(this.gravityDirection.m_122424_());
                    blockstate = this.f_77312_.m_8055_((BlockPos)blockpos$mutableblockpos.m_122190_((Vec3i)blockPos));
                }
                blockPos = blockPos.m_121945_(this.gravityDirection);
            }
        }
        return this.m_230631_(blockPos);
    }

    protected double m_142213_(BlockPos p_164733_) {
        return (this.m_77361_() || this.m_141974_()) && this.f_77312_.m_6425_(p_164733_).m_205070_(FluidTags.f_13131_) ? (double)p_164733_.m_123304_(this.gravityDirection.m_122434_()) + 0.5 : this.getFloorLevelForGravity((BlockGetter)this.f_77312_, p_164733_);
    }

    public double getFloorLevelForGravity(BlockGetter p_77612_, BlockPos p_77613_) {
        BlockPos blockpos = p_77613_.m_121945_(this.gravityDirection);
        VoxelShape voxelshape = p_77612_.m_8055_(blockpos).m_60812_(p_77612_, blockpos);
        return (double)blockpos.m_123304_(this.gravityDirection.m_122434_()) + (voxelshape.m_83281_() ? 0.0 : voxelshape.m_83297_(this.gravityDirection.m_122424_().m_122434_()));
    }

    public int m_6065_(Node[] neighbors, Node currentNode) {
        Node southEastNode;
        Node southWestNode;
        Node northEastNode;
        Node northWestNode;
        Node northNode;
        Node eastNode;
        Node westNode;
        int i = 0;
        int stepHeight = 0;
        BlockPos currentNodePos = currentNode.m_77288_();
        BlockPos upPos = currentNodePos.m_121945_(this.gravityDirection.m_122424_());
        BlockPathTypes pathTypeUp = this.m_77567_(this.f_77313_, upPos.m_123341_(), upPos.m_123342_(), upPos.m_123343_());
        BlockPathTypes pathTypeCurrent = this.m_77567_(this.f_77313_, currentNodePos.m_123341_(), currentNodePos.m_123342_(), currentNodePos.m_123343_());
        if (this.f_77313_.m_21439_(pathTypeUp) >= 0.0f && pathTypeCurrent != BlockPathTypes.STICKY_HONEY) {
            stepHeight = Mth.m_14143_((float)Math.max(1.0f, this.f_77313_.getStepHeight()));
        }
        double floorLevel = this.m_142213_(currentNodePos);
        Node southNode = this.findAcceptedNode(currentNodePos.m_121945_(this.horizontalDirections[1]), stepHeight, floorLevel, this.horizontalDirections[1], pathTypeCurrent);
        if (this.m_77626_(southNode, currentNode)) {
            neighbors[i++] = southNode;
        }
        if (this.m_77626_(westNode = this.findAcceptedNode(currentNodePos.m_121945_(this.horizontalDirections[2]), stepHeight, floorLevel, this.horizontalDirections[2], pathTypeCurrent), currentNode)) {
            neighbors[i++] = westNode;
        }
        if (this.m_77626_(eastNode = this.findAcceptedNode(currentNodePos.m_121945_(this.horizontalDirections[3]), stepHeight, floorLevel, this.horizontalDirections[3], pathTypeCurrent), currentNode)) {
            neighbors[i++] = eastNode;
        }
        if (this.m_77626_(northNode = this.findAcceptedNode(currentNodePos.m_121945_(this.horizontalDirections[0]), stepHeight, floorLevel, this.horizontalDirections[0], pathTypeCurrent), currentNode)) {
            neighbors[i++] = northNode;
        }
        if (this.m_77629_(currentNode, westNode, northNode, northWestNode = this.findAcceptedNode(currentNodePos.m_121945_(this.horizontalDirections[0]).m_121945_(this.horizontalDirections[2]), stepHeight, floorLevel, this.horizontalDirections[0], pathTypeCurrent))) {
            neighbors[i++] = northWestNode;
        }
        if (this.m_77629_(currentNode, eastNode, northNode, northEastNode = this.findAcceptedNode(currentNodePos.m_121945_(this.horizontalDirections[0]).m_121945_(this.horizontalDirections[3]), stepHeight, floorLevel, this.horizontalDirections[0], pathTypeCurrent))) {
            neighbors[i++] = northEastNode;
        }
        if (this.m_77629_(currentNode, westNode, southNode, southWestNode = this.findAcceptedNode(currentNodePos.m_121945_(this.horizontalDirections[1]).m_121945_(this.horizontalDirections[2]), stepHeight, floorLevel, this.horizontalDirections[1], pathTypeCurrent))) {
            neighbors[i++] = southWestNode;
        }
        if (this.m_77629_(currentNode, eastNode, southNode, southEastNode = this.findAcceptedNode(currentNodePos.m_121945_(this.horizontalDirections[1]).m_121945_(this.horizontalDirections[3]), stepHeight, floorLevel, this.horizontalDirections[1], pathTypeCurrent))) {
            neighbors[i++] = southEastNode;
        }
        return i;
    }

    private int getGravityAxisCoord(Node node) {
        return node.m_77288_().m_123304_(this.gravityDirection.m_122434_());
    }

    private boolean isLowerOrSame(Node node1, Node node2) {
        int coord1 = this.getGravityAxisCoord(node1);
        int coord2 = this.getGravityAxisCoord(node2);
        if (this.gravityDirection.m_122421_() == Direction.AxisDirection.POSITIVE) {
            return coord1 >= coord2;
        }
        return coord1 <= coord2;
    }

    private boolean isLower(Node node1, Node node2) {
        int coord1 = this.getGravityAxisCoord(node1);
        int coord2 = this.getGravityAxisCoord(node2);
        if (this.gravityDirection.m_122421_() == Direction.AxisDirection.POSITIVE) {
            return coord1 > coord2;
        }
        return coord1 < coord2;
    }

    protected boolean m_77629_(Node p_77630_, @Nullable Node p_77631_, @Nullable Node p_77632_, @Nullable Node p_77633_) {
        if (p_77633_ == null || p_77632_ == null || p_77631_ == null) {
            return false;
        }
        if (p_77633_.f_77279_) {
            return false;
        }
        if (this.isLowerOrSame(p_77632_, p_77630_) && this.isLowerOrSame(p_77631_, p_77630_)) {
            if (p_77631_.f_77282_ == BlockPathTypes.WALKABLE_DOOR || p_77632_.f_77282_ == BlockPathTypes.WALKABLE_DOOR || p_77633_.f_77282_ == BlockPathTypes.WALKABLE_DOOR) {
                return false;
            }
            boolean flag = p_77632_.f_77282_ == BlockPathTypes.FENCE && p_77631_.f_77282_ == BlockPathTypes.FENCE && (double)this.f_77313_.m_20205_() < 0.5;
            return p_77633_.f_77281_ >= 0.0f && (this.isLower(p_77632_, p_77630_) || p_77632_.f_77281_ >= 0.0f || flag) && (this.isLower(p_77631_, p_77630_) || p_77631_.f_77281_ >= 0.0f || flag);
        }
        return false;
    }

    protected Node m_164725_(int p_164726_, int p_164727_, int p_164728_, int p_164729_, double p_164730_, Direction p_164731_, BlockPathTypes p_164732_) {
        Node node = null;
        BlockPos currentPos = new BlockPos(p_164726_, p_164727_, p_164728_);
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos(p_164726_, p_164727_, p_164728_);
        double d0 = this.m_142213_((BlockPos)mutablePos);
        if (d0 - p_164730_ > this.m_255203_()) {
            return null;
        }
        BlockPathTypes blockpathtypes = this.m_77567_(this.f_77313_, p_164726_, p_164727_, p_164728_);
        float f = this.f_77313_.m_21439_(blockpathtypes);
        if (f >= 0.0f) {
            node = this.m_230619_(p_164726_, p_164727_, p_164728_, blockpathtypes, f);
        }
        if (GravityNodeEvaluator.m_230625_(p_164732_) && node != null && node.f_77281_ >= 0.0f && !this.m_77624_(node)) {
            node = null;
        }
        if (!(blockpathtypes == BlockPathTypes.WALKABLE || this.m_141974_() && blockpathtypes == BlockPathTypes.WATER)) {
            BlockPos upPos;
            if (!(node != null && !(node.f_77281_ < 0.0f) || p_164729_ <= 0 || blockpathtypes == BlockPathTypes.FENCE && !this.m_255100_() || blockpathtypes == BlockPathTypes.UNPASSABLE_RAIL || blockpathtypes == BlockPathTypes.TRAPDOOR || blockpathtypes == BlockPathTypes.POWDER_SNOW || (node = this.m_164725_((upPos = currentPos.m_121945_(this.gravityDirection.m_122424_())).m_123341_(), upPos.m_123342_(), upPos.m_123343_(), p_164729_ - 1, p_164730_, p_164731_, p_164732_)) == null || node.f_77282_ != BlockPathTypes.OPEN && node.f_77282_ != BlockPathTypes.WALKABLE || !(this.f_77313_.m_20205_() < 1.0f))) {
                AABB rawAABB = this.getBoundingBoxForPose(this.f_77313_.m_20089_());
                if (this.gravityDirection.m_122421_() == Direction.AxisDirection.POSITIVE) {
                    rawAABB = rawAABB.m_82386_(0.0, -1.0E-6, 0.0);
                }
                Vec3 targetPosition = Vec3.m_82539_((Vec3i)node.m_77288_());
                AABB aabb = RotationUtil.boxPlayerToWorld(rawAABB, this.gravityDirection).m_82383_(targetPosition);
                if (this.m_77634_(aabb)) {
                    node = null;
                }
            }
            if (!this.m_141974_() && blockpathtypes == BlockPathTypes.WATER && !this.m_77361_()) {
                BlockPos downPos = currentPos.m_121945_(this.gravityDirection);
                if (this.m_77567_(this.f_77313_, downPos.m_123341_(), downPos.m_123342_(), downPos.m_123343_()) != BlockPathTypes.WATER) {
                    return node;
                }
                mutablePos.m_122190_((Vec3i)currentPos);
                while (mutablePos.m_123342_() > this.f_77313_.f_19853_.m_141937_()) {
                    mutablePos.m_122173_(this.gravityDirection);
                    blockpathtypes = this.m_77567_(this.f_77313_, mutablePos.m_123341_(), mutablePos.m_123342_(), mutablePos.m_123343_());
                    if (blockpathtypes != BlockPathTypes.WATER) {
                        return node;
                    }
                    node = this.m_230619_(mutablePos.m_123341_(), mutablePos.m_123342_(), mutablePos.m_123343_(), blockpathtypes, this.f_77313_.m_21439_(blockpathtypes));
                }
            }
            if (blockpathtypes == BlockPathTypes.OPEN) {
                int fallDistance = 0;
                mutablePos.m_122190_((Vec3i)currentPos);
                while (blockpathtypes == BlockPathTypes.OPEN) {
                    mutablePos.m_122173_(this.gravityDirection);
                    if (mutablePos.m_123342_() < this.f_77313_.f_19853_.m_141937_()) {
                        return this.m_230627_(p_164726_, p_164727_, p_164728_);
                    }
                    if (fallDistance++ >= this.f_77313_.m_6056_()) {
                        return this.m_230627_(mutablePos.m_123341_(), mutablePos.m_123342_(), mutablePos.m_123343_());
                    }
                    blockpathtypes = this.m_77567_(this.f_77313_, mutablePos.m_123341_(), mutablePos.m_123342_(), mutablePos.m_123343_());
                    f = this.f_77313_.m_21439_(blockpathtypes);
                    if (blockpathtypes != BlockPathTypes.OPEN && f >= 0.0f) {
                        node = this.m_230619_(mutablePos.m_123341_(), mutablePos.m_123342_(), mutablePos.m_123343_(), blockpathtypes, f);
                        break;
                    }
                    if (!(f < 0.0f)) continue;
                    return this.m_230627_(mutablePos.m_123341_(), mutablePos.m_123342_(), mutablePos.m_123343_());
                }
            }
            if (GravityNodeEvaluator.m_230625_(blockpathtypes) && node == null) {
                node = this.m_5676_(p_164726_, p_164727_, p_164728_);
                node.f_77279_ = true;
                node.f_77282_ = blockpathtypes;
                node.f_77281_ = blockpathtypes.m_77124_();
            }
        }
        return node;
    }

    protected AABB getBoundingBoxForPose(Pose p_20218_) {
        EntityDimensions entitydimensions = this.f_77313_.m_6972_(p_20218_);
        float f = entitydimensions.f_20377_ / 2.0f;
        Vec3 vec3 = new Vec3(this.f_77313_.m_20185_() - (double)f, this.f_77313_.m_20186_(), this.f_77313_.m_20189_() - (double)f);
        Vec3 vec31 = new Vec3(this.f_77313_.m_20185_() + (double)f, this.f_77313_.m_20186_() + (double)entitydimensions.f_20378_, this.f_77313_.m_20189_() + (double)f);
        return new AABB(vec3, vec31);
    }

    @Nullable
    protected Node findAcceptedNode(BlockPos pos, int stepHeight, double floorLevel, Direction moveDir, BlockPathTypes originPathType) {
        return this.m_164725_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), stepHeight, floorLevel, moveDir, originPathType);
    }

    private boolean m_77624_(Node p_77625_) {
        AABB aabb = this.f_77313_.m_20191_();
        Vec3 vec3 = new Vec3((double)p_77625_.f_77271_ - this.f_77313_.m_20185_() + aabb.m_82362_() / 2.0, (double)p_77625_.f_77272_ - this.f_77313_.m_20186_() + aabb.m_82376_() / 2.0, (double)p_77625_.f_77273_ - this.f_77313_.m_20189_() + aabb.m_82385_() / 2.0);
        int i = Mth.m_14165_((double)(vec3.m_82553_() / aabb.m_82309_()));
        vec3 = vec3.m_82490_((double)(1.0f / (float)i));
        for (int j = 1; j <= i; ++j) {
            if (!this.m_77634_(aabb = aabb.m_82383_(vec3))) continue;
            return false;
        }
        return true;
    }

    private boolean m_77634_(AABB p_77635_) {
        return this.collisionCache.computeIfAbsent((Object)p_77635_, p_192973_ -> !this.f_77312_.m_45756_((Entity)this.f_77313_, p_77635_));
    }

    private Node m_230619_(int p_230620_, int p_230621_, int p_230622_, BlockPathTypes p_230623_, float p_230624_) {
        Node node = this.m_5676_(p_230620_, p_230621_, p_230622_);
        node.f_77282_ = p_230623_;
        node.f_77281_ = Math.max(node.f_77281_, p_230624_);
        return node;
    }

    private Node m_230627_(int p_230628_, int p_230629_, int p_230630_) {
        Node node = this.m_5676_(p_230628_, p_230629_, p_230630_);
        node.f_77282_ = BlockPathTypes.BLOCKED;
        node.f_77281_ = -1.0f;
        return node;
    }

    private static boolean m_230625_(BlockPathTypes p_230626_) {
        return p_230626_ == BlockPathTypes.FENCE || p_230626_ == BlockPathTypes.DOOR_WOOD_CLOSED || p_230626_ == BlockPathTypes.DOOR_IRON_CLOSED;
    }

    private double m_255203_() {
        return Math.max(1.125, (double)this.f_77313_.getStepHeight());
    }
}

