/*
 * Decompiled with CFR 0.152.
 */
package com.min01.gravityapi.command;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;

public class DirectionArgumentType
implements ArgumentType<Direction> {
    public static final DynamicCommandExceptionType exceptionType = new DynamicCommandExceptionType(object -> Component.m_237113_((String)("Invalid Direction " + object)));

    public static Direction getDirection(CommandContext<?> context, String direction) {
        return (Direction)context.getArgument(direction, Direction.class);
    }

    public Direction parse(StringReader reader) throws CommandSyntaxException {
        String s;
        return switch (s = reader.readUnquotedString().toLowerCase()) {
            case "up", "u" -> Direction.UP;
            case "down", "d" -> Direction.DOWN;
            case "north", "n" -> Direction.NORTH;
            case "south", "s" -> Direction.SOUTH;
            case "east", "e" -> Direction.EAST;
            case "west", "w" -> Direction.WEST;
            default -> throw exceptionType.createWithContext((ImmutableStringReader)reader, (Object)s);
        };
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return SharedSuggestionProvider.m_82970_((Iterable)Arrays.stream(Direction.values()).map(d -> d.name().toLowerCase()).collect(Collectors.toList()), (SuggestionsBuilder)builder);
    }

    public Collection<String> getExamples() {
        return Arrays.stream(Direction.values()).map(Enum::toString).collect(Collectors.toList());
    }
}

