/*
 * Decompiled with CFR 0.152.
 */
package com.min01.gravityapi.network;

import com.min01.gravityapi.api.GravityChangerAPI;
import com.min01.gravityapi.capabilities.GravityCapabilityImpl;
import com.min01.gravityapi.util.GCUtil;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class UpdateGravitySyncStatePacket {
    private final UUID entityUUID;

    public UpdateGravitySyncStatePacket(UUID entityUUID) {
        this.entityUUID = entityUUID;
    }

    public UpdateGravitySyncStatePacket(FriendlyByteBuf buf) {
        this.entityUUID = buf.m_130259_();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130077_(this.entityUUID);
    }

    public static class Handler {
        public static boolean onMessage(UpdateGravitySyncStatePacket message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isServer()) {
                    Entity entity = GCUtil.getEntityByUUID(((NetworkEvent.Context)ctx.get()).getSender().f_19853_, message.entityUUID);
                    GravityCapabilityImpl cap = GravityChangerAPI.getGravityComponent(entity);
                    cap.needsSync = false;
                    cap.noAnimation = false;
                }
            });
            ctx.get().setPacketHandled(true);
            return true;
        }
    }
}

