/*
 * Decompiled with CFR 0.152.
 */
package com.min01.gravityapi.util;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.player.RemotePlayer;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

public class GCUtil {
    public static final Map<Integer, Entity> ENTITY_MAP = new HashMap<Integer, Entity>();
    public static final Map<Integer, Entity> ENTITY_MAP2 = new HashMap<Integer, Entity>();
    public static final Method GET_ENTITY = ObfuscationReflectionHelper.findMethod(Level.class, (String)"m_142646_", (Class[])new Class[0]);

    public static void getClientLevel(Consumer<Level> consumer) {
        ((Optional)LogicalSidedProvider.CLIENTWORLD.get(LogicalSide.CLIENT)).filter(ClientLevel.class::isInstance).ifPresent(level -> consumer.accept((Level)level));
    }

    public static Iterable<Entity> getAllEntities(Level level) {
        try {
            LevelEntityGetter entities = (LevelEntityGetter)GET_ENTITY.invoke((Object)level, new Object[0]);
            return entities.m_142273_();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Entity getEntityByUUID(Level level, UUID uuid) {
        try {
            LevelEntityGetter entities = (LevelEntityGetter)GET_ENTITY.invoke((Object)level, new Object[0]);
            return (Entity)entities.m_142694_(uuid);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static MutableComponent getLinkText(String link) {
        return Component.m_237113_((String)link).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, link)).m_131162_(Boolean.valueOf(true)));
    }

    public static MutableComponent getDirectionText(Direction gravityDirection) {
        return Component.m_237115_((String)("direction." + gravityDirection.m_122433_()));
    }

    public static double distanceToRange(double value, double rangeStart, double rangeEnd) {
        if (value < rangeStart) {
            return rangeStart - value;
        }
        if (value > rangeEnd) {
            return value - rangeEnd;
        }
        return 0.0;
    }

    public static boolean isClientPlayer(Entity entity) {
        if (entity.m_9236_().m_5776_()) {
            return entity instanceof LocalPlayer;
        }
        return false;
    }

    public static boolean isRemotePlayer(Entity entity) {
        if (entity.m_9236_().m_5776_()) {
            return entity instanceof RemotePlayer;
        }
        return false;
    }
}

