/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.many_bows.entity;

import net.bandit.many_bows.registry.EntityRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;

public class DuskReaperArrow
extends AbstractArrow {
    private float powerMultiplier = 1.0f;
    private static final byte MARKER_MASK = 16;
    private static final float BASE_DAMAGE = 8.0f;
    private static final int SLOWNESS_DURATION = 60;
    private static final int WEAKNESS_DURATION = 60;
    private static final int GLOW_DURATION = 200;
    private static final int HARM_DURATION = 100;

    public void setPowerMultiplier(float power) {
        this.powerMultiplier = power;
    }

    public DuskReaperArrow(EntityType<? extends DuskReaperArrow> entityType, Level level) {
        super(entityType, level);
        this.setBaseDamage(8.0);
    }

    public DuskReaperArrow(Level level, LivingEntity shooter, ItemStack bowStack, ItemStack arrowStack) {
        super((EntityType)EntityRegistry.DUSK_REAPER_ARROW.get(), shooter, level, bowStack, arrowStack);
        this.setBaseDamage(8.0);
    }

    protected void onHitEntity(EntityHitResult result) {
        Entity entity;
        super.onHitEntity(result);
        if (!this.level().isClientSide() && (entity = result.getEntity()) instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            if (target == this.getOwner()) {
                return;
            }
            Level lvl = target.level();
            float scaledDamage = (float)this.getBaseDamage();
            Entity entity2 = this.getOwner();
            if (entity2 instanceof LivingEntity) {
                AttributeInstance inst;
                LivingEntity shooter = (LivingEntity)entity2;
                Registry reg = lvl.registryAccess().registryOrThrow(Registries.ATTRIBUTE);
                Holder.Reference rangedAttrHolder = reg.getHolder(ResourceLocation.fromNamespaceAndPath((String)"ranged_weapon", (String)"damage")).orElse(null);
                if (rangedAttrHolder != null && (inst = shooter.getAttribute((Holder)rangedAttrHolder)) != null) {
                    scaledDamage = (float)inst.getValue() * 2.0f;
                }
            }
            target.hurt(this.damageSources().magic(), scaledDamage * this.powerMultiplier);
            target.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 60, 1));
            target.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 60, 1));
            target.addEffect(new MobEffectInstance(MobEffects.GLOWING, 200, 0));
            target.addTag("manybows:marked_for_death");
            if (lvl instanceof ServerLevel) {
                ServerLevel sl = (ServerLevel)lvl;
                DuskReaperArrow.spawnFloatingLabel(sl, target, (Component)Component.literal((String)"Marked for Death"), 60);
            }
        }
        this.level().playSound(null, this.getX(), this.getY(), this.getZ(), (Holder)SoundEvents.GENERIC_EXPLODE, SoundSource.PLAYERS, 1.0f, 0.5f);
        this.discard();
    }

    protected ItemStack getPickupItem() {
        return ItemStack.EMPTY;
    }

    protected ItemStack getDefaultPickupItem() {
        return ItemStack.EMPTY;
    }

    private static void spawnFloatingLabel(ServerLevel sl, LivingEntity target, Component text, int durationTicks) {
        ArmorStand stand = new ArmorStand((Level)sl, target.getX(), target.getY() + (double)target.getBbHeight() + 0.25, target.getZ());
        stand.setInvisible(true);
        stand.setNoGravity(true);
        stand.setInvulnerable(true);
        stand.setCustomName(text);
        stand.setCustomNameVisible(true);
        stand.setSilent(true);
        SynchedEntityData data = stand.getEntityData();
        byte flags = (Byte)data.get(ArmorStand.DATA_CLIENT_FLAGS);
        data.set(ArmorStand.DATA_CLIENT_FLAGS, (Object)((byte)(flags | 0x10)));
        sl.addFreshEntity((Entity)stand);
        stand.startRiding((Entity)target, true);
        sl.getServer().execute(() -> sl.getServer().tell((Runnable)new TickTask(sl.getServer().getTickCount() + durationTicks, () -> {
            if (stand.isAlive()) {
                stand.discard();
            }
            if (target.isAlive()) {
                target.removeTag("manybows:marked_for_death");
            }
        })));
    }
}

