/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.many_bows.entity;

import net.bandit.many_bows.registry.EntityRegistry;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;

public class HunterArrow
extends AbstractArrow {
    public HunterArrow(EntityType<? extends HunterArrow> entityType, Level level) {
        super(entityType, level);
    }

    public HunterArrow(Level level, LivingEntity shooter, ItemStack bowStack, ItemStack arrowStack) {
        super((EntityType)EntityRegistry.HUNTER_ARROW.get(), shooter, level, bowStack, arrowStack);
    }

    protected void onHitEntity(EntityHitResult result) {
        Entity entity;
        LivingEntity target;
        super.onHitEntity(result);
        Entity entity2 = result.getEntity();
        if (entity2 instanceof LivingEntity && this.isPassiveMob(target = (LivingEntity)entity2) && (entity = this.getOwner()) instanceof Player) {
            Player player = (Player)entity;
            this.improveDrops(target);
        }
    }

    protected ItemStack getPickupItem() {
        return new ItemStack((ItemLike)Items.ARROW);
    }

    protected ItemStack getDefaultPickupItem() {
        return null;
    }

    private boolean isPassiveMob(LivingEntity entity) {
        return entity.getType() == EntityType.COW || entity.getType() == EntityType.PIG || entity.getType() == EntityType.SHEEP || entity.getType() == EntityType.CHICKEN || entity.getType() == EntityType.RABBIT;
    }

    private void improveDrops(LivingEntity entity) {
        entity.spawnAtLocation((ItemLike)Items.LEATHER, 2);
        entity.spawnAtLocation((ItemLike)Items.COOKED_BEEF, 2);
    }
}

