/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.many_bows.entity;

import net.bandit.many_bows.registry.EntityRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.EntityHitResult;

public class IcicleJavelin
extends AbstractArrow {
    private boolean hasFrozen = false;

    public IcicleJavelin(EntityType<? extends AbstractArrow> entityType, Level level) {
        super(entityType, level);
    }

    public IcicleJavelin(Level level, LivingEntity shooter, ItemStack bowStack, ItemStack arrowStack) {
        super((EntityType)EntityRegistry.ICICLE_JAVELIN.get(), shooter, level, bowStack, arrowStack);
        this.setBaseDamage(8.0);
    }

    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
        Entity entity = result.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity target = (LivingEntity)entity;
        float scaledDamage = (float)this.getBaseDamage();
        Entity entity2 = this.getOwner();
        if (entity2 instanceof LivingEntity) {
            AttributeInstance attrInstance;
            LivingEntity shooter = (LivingEntity)entity2;
            Registry registry = this.level().registryAccess().registryOrThrow(Registries.ATTRIBUTE);
            Holder.Reference rangedAttrHolder = registry.getHolder(ResourceLocation.fromNamespaceAndPath((String)"ranged_weapon", (String)"damage")).orElse(null);
            if (rangedAttrHolder != null && (attrInstance = shooter.getAttribute((Holder)rangedAttrHolder)) != null) {
                scaledDamage = (float)attrInstance.getValue() * 1.5f;
            }
        }
        target.hurt(this.damageSources().magic(), scaledDamage);
        target.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 60, 4));
        this.freezeAreaAround(this.getX(), this.getY(), this.getZ());
        this.createIceExplosion();
        this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.SNOW_STEP, SoundSource.PLAYERS, 1.0f, 1.0f);
        this.discard();
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide() && this.inGround && !this.hasFrozen) {
            this.freezeAreaAround(this.getX(), this.getY(), this.getZ());
            this.hasFrozen = true;
            this.discard();
        }
        if (this.level().isClientSide()) {
            this.createTrailParticles();
        }
    }

    private void freezeAreaAround(double x, double y, double z) {
        BlockPos impactPos = new BlockPos((int)x, (int)y, (int)z);
        if (this.level().getBlockState(impactPos).isAir() || this.level().getBlockState(impactPos).canBeReplaced()) {
            this.level().setBlockAndUpdate(impactPos, Blocks.PACKED_ICE.defaultBlockState());
        } else {
            BlockPos adjacentPos = this.findAdjacentBlock(impactPos);
            if (adjacentPos != null) {
                this.level().setBlockAndUpdate(adjacentPos, Blocks.PACKED_ICE.defaultBlockState());
            }
        }
    }

    private BlockPos findAdjacentBlock(BlockPos impactPos) {
        BlockPos[] adjacentPositions;
        for (BlockPos pos : adjacentPositions = new BlockPos[]{impactPos.above(), impactPos.below(), impactPos.north(), impactPos.south(), impactPos.east(), impactPos.west()}) {
            if (!this.level().getBlockState(pos).isAir() && !this.level().getBlockState(pos).canBeReplaced()) continue;
            return pos;
        }
        return null;
    }

    private void createIceExplosion() {
        for (int i = 0; i < 20; ++i) {
            double offsetX = (this.random.nextDouble() - 0.5) * 0.5;
            double offsetY = this.random.nextDouble() * 0.5;
            double offsetZ = (this.random.nextDouble() - 0.5) * 0.5;
            this.level().addParticle((ParticleOptions)ParticleTypes.SNOWFLAKE, this.getX() + offsetX, this.getY() + offsetY, this.getZ() + offsetZ, 0.0, 0.0, 0.0);
        }
    }

    private void createTrailParticles() {
        for (int i = 0; i < 5; ++i) {
            double offsetX = (this.random.nextDouble() - 0.5) * 0.2;
            double offsetY = (this.random.nextDouble() - 0.5) * 0.2;
            double offsetZ = (this.random.nextDouble() - 0.5) * 0.2;
            this.level().addParticle((ParticleOptions)ParticleTypes.SNOWFLAKE, this.getX() + offsetX, this.getY() + offsetY, this.getZ() + offsetZ, 0.0, 0.0, 0.0);
        }
    }

    protected ItemStack getPickupItem() {
        return ItemStack.EMPTY;
    }

    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)Items.ARROW);
    }
}

