/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.many_bows.entity;

import net.bandit.many_bows.registry.EntityRegistry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;

public class LightningArrow
extends AbstractArrow {
    private boolean lightningStruck = false;

    public LightningArrow(EntityType<? extends LightningArrow> entityType, Level level) {
        super(entityType, level);
    }

    public LightningArrow(Level level, LivingEntity shooter, ItemStack bowStack, ItemStack arrowStack) {
        super((EntityType)EntityRegistry.LIGHTNING_ARROW.get(), shooter, level, bowStack, arrowStack);
    }

    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
        if (!this.level().isClientSide() && !this.lightningStruck) {
            this.summonLightning(result.getLocation().x(), result.getLocation().y(), result.getLocation().z());
            this.lightningStruck = true;
            this.discard();
        }
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide() && this.inGround && !this.lightningStruck) {
            this.summonLightning(this.getX(), this.getY(), this.getZ());
            this.lightningStruck = true;
            this.discard();
        }
        if (this.level().isClientSide()) {
            this.createParticles();
        }
    }

    private void summonLightning(double x, double y, double z) {
        LightningBolt lightningBolt = (LightningBolt)EntityType.LIGHTNING_BOLT.create(this.level());
        if (lightningBolt == null) {
            return;
        }
        lightningBolt.moveTo(x, y, z);
        Entity entity = this.getOwner();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            lightningBolt.setCause(player);
        }
        this.level().addFreshEntity((Entity)lightningBolt);
    }

    private void createParticles() {
        for (int i = 0; i < 10; ++i) {
            double offsetX = (this.random.nextDouble() - 0.5) * 0.5;
            double offsetY = this.random.nextDouble() * 0.5;
            double offsetZ = (this.random.nextDouble() - 0.5) * 0.5;
            this.level().addParticle((ParticleOptions)ParticleTypes.ELECTRIC_SPARK, this.getX() + offsetX, this.getY() + offsetY, this.getZ() + offsetZ, 0.0, 0.1, 0.0);
        }
    }

    protected ItemStack getPickupItem() {
        return new ItemStack((ItemLike)Items.ARROW);
    }

    protected ItemStack getDefaultPickupItem() {
        return null;
    }
}

