/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.many_bows.entity;

import java.util.List;
import net.bandit.many_bows.registry.EntityRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;

public class ShulkerBlastProjectile
extends AbstractArrow {
    private float powerMultiplier = 1.0f;
    private static final double HOMING_RANGE = 20.0;
    private static final float SPEED = 0.7f;
    private static final float DAMAGE = 6.0f;
    private static final int LEVITATION_DURATION = 40;
    private static final int MAX_LIFETIME = 100;
    private int lifetime = 0;

    public void setPowerMultiplier(float power) {
        this.powerMultiplier = power;
    }

    public ShulkerBlastProjectile(EntityType<? extends AbstractArrow> entityType, Level level) {
        super(entityType, level);
        this.setNoGravity(true);
    }

    public ShulkerBlastProjectile(Level level, LivingEntity shooter, ItemStack bowStack, ItemStack arrowStack) {
        super((EntityType)EntityRegistry.SHULKER_BLAST_PROJECTILE.get(), shooter, level, bowStack, arrowStack);
        this.setNoGravity(true);
    }

    public void tick() {
        double dz;
        double dy;
        double dx;
        double distance;
        LivingEntity target;
        super.tick();
        ++this.lifetime;
        if (this.lifetime > 100) {
            this.discard();
            return;
        }
        if (!this.level().isClientSide && (target = this.findNearestTarget()) != null && (distance = Math.sqrt((dx = target.getX() - this.getX()) * dx + (dy = target.getY() + (double)(target.getEyeHeight() / 2.0f) - this.getY()) * dy + (dz = target.getZ() - this.getZ()) * dz)) > 0.0) {
            double homingFactor = 0.2;
            this.setDeltaMovement(this.getDeltaMovement().x * (1.0 - homingFactor) + dx / distance * (double)0.7f * homingFactor, this.getDeltaMovement().y * (1.0 - homingFactor) + dy / distance * (double)0.7f * homingFactor, this.getDeltaMovement().z * (1.0 - homingFactor) + dz / distance * (double)0.7f * homingFactor);
        }
        this.level().addParticle((ParticleOptions)ParticleTypes.END_ROD, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
    }

    private LivingEntity findNearestTarget() {
        AABB searchBox = this.getBoundingBox().inflate(20.0);
        List entities = this.level().getEntitiesOfClass(LivingEntity.class, searchBox, entity -> {
            TamableAnimal tamable;
            return entity != this.getOwner() && entity.isAlive() && !(entity instanceof ArmorStand) && (!(entity instanceof TamableAnimal) || !(tamable = (TamableAnimal)entity).isTame());
        });
        return entities.stream().min((e1, e2) -> Double.compare(e1.distanceTo((Entity)this), e2.distanceTo((Entity)this))).orElse(null);
    }

    protected void onHitEntity(EntityHitResult result) {
        Entity entity;
        super.onHitEntity(result);
        if (!this.level().isClientSide() && (entity = result.getEntity()) instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            Entity entity2 = this.getOwner();
            if (entity2 instanceof LivingEntity) {
                AttributeInstance attrInstance;
                LivingEntity shooter = (LivingEntity)entity2;
                Registry registry = this.level().registryAccess().registryOrThrow(Registries.ATTRIBUTE);
                Holder.Reference rangedAttrHolder = registry.getHolder(ResourceLocation.fromNamespaceAndPath((String)"ranged_weapon", (String)"damage")).orElse(null);
                scaledDamage = rangedAttrHolder != null ? ((attrInstance = shooter.getAttribute((Holder)rangedAttrHolder)) != null ? (float)attrInstance.getValue() : 6.0f) : 6.0f;
            } else {
                scaledDamage = 6.0f;
            }
            DamageSource damageSource = this.level().damageSources().arrow((AbstractArrow)this, this.getOwner());
            target.hurt(damageSource, scaledDamage *= this.powerMultiplier);
            target.addEffect(new MobEffectInstance(MobEffects.LEVITATION, 40, 1));
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.SHULKER_BULLET_HIT, SoundSource.PLAYERS, 1.0f, 1.0f);
            for (int i = 0; i < 10; ++i) {
                double xOffset = (this.random.nextDouble() - 0.5) * 0.3;
                double yOffset = this.random.nextDouble() * 0.3;
                double zOffset = (this.random.nextDouble() - 0.5) * 0.3;
                this.level().addParticle((ParticleOptions)ParticleTypes.ENCHANTED_HIT, this.getX() + xOffset, this.getY() + yOffset, this.getZ() + zOffset, 0.0, 0.0, 0.0);
            }
        }
        this.discard();
    }

    protected ItemStack getPickupItem() {
        return new ItemStack((ItemLike)Items.ARROW);
    }

    protected ItemStack getDefaultPickupItem() {
        return null;
    }
}

