/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.many_bows.entity;

import java.util.function.Consumer;
import net.bandit.many_bows.registry.EntityRegistry;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;

public class VitalityArrow
extends AbstractArrow {
    private Consumer<LivingEntity> onHitCallback;

    public VitalityArrow(EntityType<? extends VitalityArrow> entityType, Level level) {
        super(entityType, level);
    }

    public VitalityArrow(Level level, LivingEntity shooter, ItemStack bowStack, ItemStack arrowStack) {
        super((EntityType)EntityRegistry.VITALITY_ARROW.get(), shooter, level, bowStack, arrowStack);
    }

    public void setOnHitCallback(Consumer<LivingEntity> callback) {
        this.onHitCallback = callback;
    }

    protected void onHitEntity(EntityHitResult result) {
        Entity entity;
        super.onHitEntity(result);
        if (!this.level().isClientSide() && (entity = result.getEntity()) instanceof LivingEntity) {
            float damageDealt;
            DamageSource damageSource;
            boolean didDamage;
            LivingEntity shooter;
            LivingEntity target = (LivingEntity)entity;
            LivingEntity livingEntity = shooter = this.getOwner() instanceof LivingEntity ? (LivingEntity)this.getOwner() : null;
            if (shooter != null && (didDamage = target.hurt(damageSource = this.level().damageSources().arrow((AbstractArrow)this, (Entity)shooter), damageDealt = (float)this.getBaseDamage())) && damageDealt > 0.0f) {
                if (this.onHitCallback != null) {
                    this.onHitCallback.accept(target);
                }
                float healAmount = Math.min(damageDealt * 0.5f, target.getHealth());
                shooter.heal(healAmount);
                this.level().playSound(null, target.getX(), target.getY(), target.getZ(), SoundEvents.PLAYER_LEVELUP, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
        this.discard();
    }

    protected ItemStack getPickupItem() {
        return new ItemStack((ItemLike)Items.ARROW);
    }

    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)Items.ARROW);
    }
}

