/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.many_bows.item;

import java.util.List;
import java.util.function.Predicate;
import net.bandit.many_bows.entity.EtherealArrow;
import net.bandit.many_bows.registry.ItemRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class EtherealHunterBow
extends BowItem {
    private static final int HUNGER_COST = 1;

    public EtherealHunterBow(Item.Properties properties) {
        super(properties);
    }

    public void releaseUsing(ItemStack bowStack, Level level, LivingEntity entity, int chargeTime) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            int charge = this.getUseDuration(bowStack, entity) - chargeTime;
            float power = EtherealHunterBow.getPowerForTime((int)charge);
            if (power >= 0.1f && (this.consumeHunger(player) || player.getAbilities().instabuild) && level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                boolean arrowConsumed = false;
                ItemStack fakeArrow = new ItemStack((ItemLike)Items.ARROW);
                List projectiles = EtherealHunterBow.draw((ItemStack)bowStack, (ItemStack)fakeArrow, (LivingEntity)player);
                for (ItemStack projectileStack : projectiles) {
                    AbstractArrow arrow;
                    if (projectileStack.is(Items.SPECTRAL_ARROW) || projectileStack.is(Items.TIPPED_ARROW)) {
                        arrow = ((ArrowItem)projectileStack.getItem()).createArrow((Level)serverLevel, projectileStack, (LivingEntity)player, bowStack);
                    } else {
                        arrow = new EtherealArrow((Level)serverLevel, (LivingEntity)player, bowStack, projectileStack);
                        if (arrow instanceof EtherealArrow) {
                            AttributeInstance attrInstance;
                            EtherealArrow etherealArrow = (EtherealArrow)arrow;
                            Holder rangedDamageAttr = level.registryAccess().registryOrThrow(Registries.ATTRIBUTE).getHolder(ResourceLocation.fromNamespaceAndPath((String)"ranged_weapon", (String)"damage")).orElse(null);
                            if (rangedDamageAttr != null && (attrInstance = player.getAttribute(rangedDamageAttr)) != null) {
                                float damage = (float)attrInstance.getValue();
                                etherealArrow.setBaseDamage((double)damage / 1.5);
                            }
                        }
                    }
                    this.applyPowerEnchantment(arrow, bowStack, level);
                    this.applyKnockbackEnchantment(arrow, bowStack, (LivingEntity)player, level);
                    this.applyFlameEnchantment(arrow, bowStack, level);
                    arrow.pickup = AbstractArrow.Pickup.DISALLOWED;
                    arrow.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, power * 2.5f, 1.0f);
                    serverLevel.addFreshEntity((Entity)arrow);
                    if (player.getAbilities().instabuild || arrowConsumed) continue;
                    projectileStack.shrink(1);
                    arrowConsumed = true;
                }
                level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ARROW_SHOOT, SoundSource.PLAYERS, 1.0f, 1.0f);
                player.awardStat(Stats.ITEM_USED.get((Object)this));
                if (!player.getAbilities().instabuild) {
                    bowStack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
                }
            }
        }
    }

    private boolean consumeHunger(Player player) {
        int currentHunger = player.getFoodData().getFoodLevel();
        if (currentHunger >= 1) {
            player.getFoodData().setFoodLevel(currentHunger - 1);
            return true;
        }
        player.displayClientMessage((Component)Component.translatable((String)"item.many_bows.ethereal_hunter.no_hunger").withStyle(ChatFormatting.RED), true);
        return false;
    }

    private void applyFlameEnchantment(AbstractArrow arrow, ItemStack bow, Level level) {
        Holder<Enchantment> flame = this.getEnchantmentHolder(level, (ResourceKey<Enchantment>)Enchantments.FLAME);
        int flameLevel = EnchantmentHelper.getItemEnchantmentLevel(flame, (ItemStack)bow);
        if (flameLevel > 0) {
            arrow.igniteForSeconds(5.0f);
        }
    }

    private void applyKnockbackEnchantment(AbstractArrow arrow, ItemStack bow, LivingEntity shooter, Level level) {
        Holder<Enchantment> punch = this.getEnchantmentHolder(level, (ResourceKey<Enchantment>)Enchantments.PUNCH);
        int punchLevel = EnchantmentHelper.getItemEnchantmentLevel(punch, (ItemStack)bow);
        if (punchLevel > 0) {
            double resistance = Math.max(0.0, 1.0 - shooter.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE));
            Vec3 knockbackVec = arrow.getDeltaMovement().normalize().scale((double)punchLevel * 0.6 * resistance);
            arrow.push(knockbackVec.x, 0.1, knockbackVec.z);
        }
    }

    private void applyPowerEnchantment(AbstractArrow arrow, ItemStack bow, Level level) {
        Holder<Enchantment> power = this.getEnchantmentHolder(level, (ResourceKey<Enchantment>)Enchantments.POWER);
        int powerLevel = EnchantmentHelper.getItemEnchantmentLevel(power, (ItemStack)bow);
        if (powerLevel > 0) {
            double extraDamage = 0.5 * (double)powerLevel + 1.0;
            arrow.setBaseDamage(arrow.getBaseDamage() + extraDamage);
        }
    }

    private Holder<Enchantment> getEnchantmentHolder(Level level, ResourceKey<Enchantment> enchantmentKey) {
        return level.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(enchantmentKey);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack bowStack = player.getItemInHand(hand);
        if (this.consumeHunger(player) || player.getAbilities().instabuild) {
            player.startUsingItem(hand);
            return InteractionResultHolder.consume((Object)bowStack);
        }
        return InteractionResultHolder.fail((Object)bowStack);
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public boolean isEnchantable(ItemStack stack) {
        return true;
    }

    public int getEnchantmentValue() {
        return 16;
    }

    public boolean isValidRepairItem(ItemStack toRepair, ItemStack repair) {
        return repair.is((Item)ItemRegistry.POWER_CRYSTAL.get());
    }

    public Predicate<ItemStack> getAllSupportedProjectiles() {
        return stack -> false;
    }

    public int getDefaultProjectileRange() {
        return 64;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (Screen.hasShiftDown()) {
            tooltipComponents.add((Component)Component.translatable((String)"item.many_bows.ethereal_hunter.tooltip.info").withStyle(ChatFormatting.DARK_PURPLE));
            tooltipComponents.add((Component)Component.translatable((String)"item.many_bows.ethereal_hunter.tooltip.hunger", (Object[])new Object[]{1}).withStyle(ChatFormatting.GRAY));
            tooltipComponents.add((Component)Component.translatable((String)"item.many_bows.ethereal_hunter.tooltip.legend").withStyle(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.ITALIC}));
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"item.too_many_bows.hold_shift").withStyle(ChatFormatting.YELLOW));
        }
    }
}

