/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.many_bows.item;

import java.util.List;
import java.util.function.Predicate;
import net.bandit.many_bows.entity.RadiantArrow;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class RadianceBow
extends BowItem {
    private static final int EXPERIENCE_COST = 5;

    public RadianceBow(Item.Properties properties) {
        super(properties);
    }

    public void releaseUsing(ItemStack bowStack, Level level, LivingEntity entity, int chargeTime) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!level.isClientSide()) {
                boolean hasXP;
                int charge = this.getUseDuration(bowStack, entity) - chargeTime;
                float power = RadianceBow.getPowerForTime((int)charge);
                boolean hasInfinity = this.hasInfinityEnchantment(bowStack, level);
                boolean bl = hasXP = this.consumeExperience(player) || hasInfinity || player.getAbilities().instabuild;
                if (power >= 0.1f && hasXP) {
                    RadiantArrow arrow = new RadiantArrow(level, (LivingEntity)player, bowStack, new ItemStack((ItemLike)Items.ARROW));
                    if (arrow instanceof RadiantArrow) {
                        AttributeInstance attrInstance;
                        RadiantArrow radiantArrow = arrow;
                        Holder rangedDamageAttr = level.registryAccess().registryOrThrow(Registries.ATTRIBUTE).getHolder(ResourceLocation.fromNamespaceAndPath((String)"ranged_weapon", (String)"damage")).orElse(null);
                        if (rangedDamageAttr != null && (attrInstance = player.getAttribute(rangedDamageAttr)) != null) {
                            float damage = (float)attrInstance.getValue();
                            radiantArrow.setBaseDamage(damage / 2.0f);
                        }
                        radiantArrow.setPowerMultiplier(power);
                    }
                    this.applyPowerEnchantment(arrow, bowStack, level);
                    this.applyKnockbackEnchantment(arrow, bowStack, (LivingEntity)player, level);
                    this.applyFlameEnchantment(arrow, bowStack, level);
                    arrow.pickup = hasInfinity ? AbstractArrow.Pickup.CREATIVE_ONLY : AbstractArrow.Pickup.ALLOWED;
                    arrow.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, power * 3.0f, 1.0f);
                    level.addFreshEntity((Entity)arrow);
                    level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.PLAYERS, 1.0f, 1.5f);
                    bowStack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
                    player.awardStat(Stats.ITEM_USED.get((Object)this));
                }
            }
        }
    }

    private boolean consumeExperience(Player player) {
        int totalExperience = player.totalExperience;
        if (totalExperience >= 5) {
            player.giveExperiencePoints(-5);
            return true;
        }
        player.displayClientMessage((Component)Component.translatable((String)"item.many_bows.radiance.no_experience").withStyle(ChatFormatting.RED), true);
        return false;
    }

    private void applyFlameEnchantment(AbstractArrow arrow, ItemStack bow, Level level) {
        Holder<Enchantment> flame = this.getEnchantmentHolder(level, (ResourceKey<Enchantment>)Enchantments.FLAME);
        int flameLevel = EnchantmentHelper.getItemEnchantmentLevel(flame, (ItemStack)bow);
        if (flameLevel > 0) {
            arrow.igniteForSeconds(5.0f);
        }
    }

    private void applyKnockbackEnchantment(AbstractArrow arrow, ItemStack bow, LivingEntity shooter, Level level) {
        Holder<Enchantment> punch = this.getEnchantmentHolder(level, (ResourceKey<Enchantment>)Enchantments.PUNCH);
        int punchLevel = EnchantmentHelper.getItemEnchantmentLevel(punch, (ItemStack)bow);
        if (punchLevel > 0) {
            double resistance = Math.max(0.0, 1.0 - shooter.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE));
            Vec3 knockbackVec = arrow.getDeltaMovement().normalize().scale((double)punchLevel * 0.6 * resistance);
            arrow.push(knockbackVec.x, 0.1, knockbackVec.z);
        }
    }

    private void applyPowerEnchantment(AbstractArrow arrow, ItemStack bow, Level level) {
        Holder<Enchantment> power = this.getEnchantmentHolder(level, (ResourceKey<Enchantment>)Enchantments.POWER);
        int powerLevel = EnchantmentHelper.getItemEnchantmentLevel(power, (ItemStack)bow);
        if (powerLevel > 0) {
            double extraDamage = 0.5 * (double)powerLevel + 1.0;
            arrow.setBaseDamage(arrow.getBaseDamage() + extraDamage);
        }
    }

    private boolean hasInfinityEnchantment(ItemStack bow, Level level) {
        Holder<Enchantment> infinity = this.getEnchantmentHolder(level, (ResourceKey<Enchantment>)Enchantments.INFINITY);
        return EnchantmentHelper.getItemEnchantmentLevel(infinity, (ItemStack)bow) > 0;
    }

    private Holder<Enchantment> getEnchantmentHolder(Level level, ResourceKey<Enchantment> enchantmentKey) {
        return level.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(enchantmentKey);
    }

    @NotNull
    public Predicate<ItemStack> getAllSupportedProjectiles() {
        return stack -> true;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (Screen.hasShiftDown()) {
            tooltipComponents.add((Component)Component.translatable((String)"item.many_bows.radiance.tooltip.info").withStyle(ChatFormatting.GOLD));
            tooltipComponents.add((Component)Component.translatable((String)"item.many_bows.radiance.tooltip.xp", (Object[])new Object[]{5}).withStyle(ChatFormatting.RED));
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"item.many_bows.radiance.tooltip.legend").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
            tooltipComponents.add((Component)Component.translatable((String)"item.too_many_bows.hold_shift"));
        }
    }
}

