/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.many_bows.loot;

import dev.architectury.event.events.common.LootEvent;
import java.util.Set;
import net.bandit.many_bows.config.BowLootConfig;
import net.bandit.many_bows.registry.ItemRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public class ModLootModifiers {
    private static final BowLootConfig CONFIG = BowLootConfig.loadConfig();
    private static final Set<ResourceKey<LootTable>> EASY_LOOT_TABLES = Set.of(ModLootModifiers.createKey("minecraft", "chests/simple_dungeon"), ModLootModifiers.createKey("minecraft", "chests/abandoned_mineshaft"));
    private static final Set<ResourceKey<LootTable>> MEDIUM_LOOT_TABLES = Set.of(ModLootModifiers.createKey("minecraft", "chests/jungle_temple"), ModLootModifiers.createKey("minecraft", "chests/pillager_outpost"), ModLootModifiers.createKey("minecraft", "chests/abandoned_mineshaft"), ModLootModifiers.createKey("minecraft", "chests/simple_dungeon"));
    private static final Set<ResourceKey<LootTable>> HARD_LOOT_TABLES = Set.of(ModLootModifiers.createKey("minecraft", "chests/stronghold_corridor"), ModLootModifiers.createKey("minecraft", "chests/nether_bridge"), ModLootModifiers.createKey("minecraft", "chests/bastion_treasure"));
    private static final Set<ResourceKey<LootTable>> ENDGAME_LOOT_TABLES = Set.of(ModLootModifiers.createKey("minecraft", "chests/end_city_treasure"), ModLootModifiers.createKey("minecraft", "chests/nether_bridge"), ModLootModifiers.createKey("minecraft", "chests/bastion_treasure"));

    private static ResourceKey<LootTable> createKey(String namespace, String path) {
        return ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)namespace, (String)path));
    }

    public static void registerLootModifiers() {
        LootEvent.MODIFY_LOOT_TABLE.register((key, context, builtin) -> {
            if (!builtin) {
                return;
            }
            if (ModLootModifiers.CONFIG.easyLootEnabled && EASY_LOOT_TABLES.contains(key)) {
                context.addPool(ModLootModifiers.createCommonBowPool(ModLootModifiers.CONFIG.easyLootDropChance));
            }
            if (ModLootModifiers.CONFIG.mediumLootEnabled && MEDIUM_LOOT_TABLES.contains(key)) {
                context.addPool(ModLootModifiers.createUncommonBowPool(ModLootModifiers.CONFIG.mediumLootDropChance));
            }
            if (ModLootModifiers.CONFIG.hardLootEnabled && HARD_LOOT_TABLES.contains(key)) {
                context.addPool(ModLootModifiers.createRareBowPool(ModLootModifiers.CONFIG.hardLootDropChance));
            }
            if (ModLootModifiers.CONFIG.endgameLootEnabled && ENDGAME_LOOT_TABLES.contains(key)) {
                context.addPool(ModLootModifiers.createEpicBowPool(ModLootModifiers.CONFIG.endgameLootDropChance));
            }
        });
    }

    private static LootPool.Builder createCommonBowPool(float chance) {
        return LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemRegistry.ANCIENT_SAGE_BOW.get()))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemRegistry.AETHERS_CALL.get()))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemRegistry.BURNT_RELIC.get()))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemRegistry.ARCANE_BOW.get()))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemRegistry.CYROHEART_BOW.get()))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemRegistry.POWER_CRYSTAL.get()))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemRegistry.EMERALD_SAGE_BOW.get()))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemRegistry.TORCHBEARER.get()))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemRegistry.DEMONS_GRASP.get()))).when(LootItemRandomChanceCondition.randomChance((float)chance));
    }

    private static LootPool.Builder createUncommonBowPool(float chance) {
        return LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemRegistry.ARCANE_BOW.get()))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemRegistry.CYROHEART_BOW.get()))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemRegistry.POWER_CRYSTAL.get()))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemRegistry.TORCHBEARER.get()))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemRegistry.EMERALD_SAGE_BOW.get()))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemRegistry.DEMONS_GRASP.get()))).when(LootItemRandomChanceCondition.randomChance((float)chance));
    }

    private static LootPool.Builder createRareBowPool(float chance) {
        return LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemRegistry.SENTINELS_WRATH.get()))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemRegistry.CURSED_STONE.get()))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemRegistry.SOLAR_BOW.get()))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemRegistry.ARC_HEAVENS.get()))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemRegistry.SCATTER_BOW.get()))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemRegistry.VITALITY_WEAVER.get()))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemRegistry.SPECTRAL_WHISPER.get()))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemRegistry.WEBSTRING.get()))).when(LootItemRandomChanceCondition.randomChance((float)chance));
    }

    private static LootPool.Builder createEpicBowPool(float chance) {
        return LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemRegistry.FLAME_BOW.get()))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemRegistry.DARK_BOW.get()))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemRegistry.DRAGONS_BREATH.get()))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemRegistry.WIND_BOW.get()))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemRegistry.SHULKER_BLAST.get()))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemRegistry.ASTRAL_BOUND.get()))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemRegistry.AURORAS_GRACE.get()))).when(LootItemRandomChanceCondition.randomChance((float)chance));
    }
}

