/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.many_bows.mixin;

import net.bandit.many_bows.registry.EffectRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin {
    @Unique
    private static final ResourceKey<MobEffect> TMB_CURSED_KEY = ResourceKey.create((ResourceKey)Registries.MOB_EFFECT, (ResourceLocation)EffectRegistry.CURSED_FLAME.getId());

    @Unique
    private static boolean tmb$hasCursedByKey(LivingEntity self) {
        for (MobEffectInstance inst : self.getActiveEffects()) {
            if (!inst.getEffect().is(TMB_CURSED_KEY)) continue;
            return true;
        }
        return false;
    }

    @Inject(method={"heal(F)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void tmb$blockHeal(float amount, CallbackInfo ci) {
        LivingEntity self = (LivingEntity)this;
        if (LivingEntityMixin.tmb$hasCursedByKey(self)) {
            ci.cancel();
        }
    }

    @Inject(method={"setHealth(F)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void tmb$noSetHealthUp(float newHealth, CallbackInfo ci) {
        LivingEntity self = (LivingEntity)this;
        if (LivingEntityMixin.tmb$hasCursedByKey(self) && newHealth > self.getHealth()) {
            ci.cancel();
        }
    }

    @Inject(method={"baseTick()V"}, at={@At(value="TAIL")})
    private void tmb$afterBaseTick(CallbackInfo ci) {
        LivingEntity self = (LivingEntity)this;
        if (!LivingEntityMixin.tmb$hasCursedByKey(self)) {
            return;
        }
        if (self.getRemainingFireTicks() < 20) {
            self.setRemainingFireTicks(20);
        }
        self.removeEffect(MobEffects.REGENERATION);
        self.removeEffect(MobEffects.HEAL);
        if (!self.fireImmune() && self.tickCount % 20 == 0) {
            self.hurt(self.damageSources().onFire(), 1.0f);
        }
    }
}

