/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.many_bows.item;

import java.util.List;
import java.util.function.Predicate;
import net.bandit.many_bows.registry.ItemRegistry;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1667;
import net.minecraft.class_1753;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_437;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7924;

public class ScatterBow
extends class_1753 {
    private static final int MAX_ARROWS = 8;

    public ScatterBow(class_1792.class_1793 properties) {
        super(properties);
    }

    public void method_7840(class_1799 bowStack, class_1937 level, class_1309 entity, int chargeTime) {
        class_1799 arrowStack;
        int arrowsToFire;
        if (!(entity instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)entity;
        boolean hasInfinity = this.hasInfinityEnchantment(bowStack, level);
        int charge = this.method_7881(bowStack, entity) - chargeTime;
        float power = ScatterBow.getPowerForTime(charge);
        if (power < 0.1f) {
            return;
        }
        int n = arrowsToFire = hasInfinity || player.method_31549().field_7477 ? 8 : Math.min(8, this.countAvailableArrows(player));
        if (arrowsToFire <= 0) {
            return;
        }
        int arrowsConsumed = 0;
        for (int i = 0; i < arrowsToFire && (!(arrowStack = player.method_18808(bowStack)).method_7960() || hasInfinity || player.method_31549().field_7477); ++i) {
            class_1324 attrInstance;
            class_1667 arrow = (class_1667)class_1299.field_6122.method_5883(level);
            if (arrow == null) continue;
            arrow.method_7432((class_1297)player);
            arrow.method_5814(player.method_23317(), player.method_23320() - 0.1, player.method_23321());
            float baseDamage = 2.0f;
            class_6880 rangedDamageAttr = level.method_30349().method_30530(class_7924.field_41251).method_55841(class_2960.method_60655((String)"ranged_weapon", (String)"damage")).orElse(null);
            if (rangedDamageAttr != null && (attrInstance = player.method_5996(rangedDamageAttr)) != null) {
                baseDamage = (float)attrInstance.method_6194() / 11.0f;
            }
            arrow.method_7438((double)baseDamage);
            this.applyPowerEnchantment((class_1665)arrow, bowStack, level);
            this.applyKnockbackEnchantment((class_1665)arrow, bowStack, (class_1309)player, level);
            this.applyFlameEnchantment((class_1665)arrow, bowStack, level);
            arrow.field_7572 = hasInfinity || player.method_31549().field_7477 ? class_1665.class_1666.field_7594 : class_1665.class_1666.field_7593;
            float yawOffset = (level.method_8409().method_43057() - 0.5f) * 20.0f;
            float pitchOffset = (level.method_8409().method_43057() - 0.5f) * 10.0f;
            arrow.method_24919((class_1297)player, player.method_36455() + pitchOffset, player.method_36454() + yawOffset, 0.0f, power * 3.0f, 1.0f);
            level.method_8649((class_1297)arrow);
            if (player.method_31549().field_7477 || hasInfinity || arrowStack.method_7960()) continue;
            arrowStack.method_7934(1);
            ++arrowsConsumed;
        }
        if (arrowsConsumed > 0 || hasInfinity) {
            level.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14600, class_3419.field_15248, 1.0f, 1.0f);
        }
        player.method_7259(class_3468.field_15372.method_14956((Object)this));
        bowStack.method_7970(1, (class_1309)player, class_1304.field_6173);
    }

    private int countAvailableArrows(class_1657 player) {
        int count = 0;
        for (class_1799 stack : player.method_31548().field_7547) {
            if (!field_18281.test(stack)) continue;
            count += stack.method_7947();
        }
        return count;
    }

    private void consumeArrows(class_1657 player, int amount) {
        int remaining = amount;
        for (class_1799 stack : player.method_31548().field_7547) {
            if (!field_18281.test(stack)) continue;
            int toRemove = Math.min(remaining, stack.method_7947());
            stack.method_7934(toRemove);
            if ((remaining -= toRemove) > 0) continue;
            break;
        }
    }

    private void applyFlameEnchantment(class_1665 arrow, class_1799 bow, class_1937 level) {
        class_6880<class_1887> flame = this.getEnchantmentHolder(level, (class_5321<class_1887>)class_1893.field_9126);
        int flameLevel = class_1890.method_8225(flame, (class_1799)bow);
        if (flameLevel > 0) {
            arrow.method_5639(5.0f);
        }
    }

    private void applyKnockbackEnchantment(class_1665 arrow, class_1799 bow, class_1309 shooter, class_1937 level) {
        class_6880<class_1887> punch = this.getEnchantmentHolder(level, (class_5321<class_1887>)class_1893.field_9116);
        int punchLevel = class_1890.method_8225(punch, (class_1799)bow);
        if (punchLevel > 0) {
            double resistance = Math.max(0.0, 1.0 - shooter.method_45325(class_5134.field_23718));
            class_243 knockbackVec = arrow.method_18798().method_1029().method_1021((double)punchLevel * 0.6 * resistance);
            arrow.method_5762(knockbackVec.field_1352, 0.1, knockbackVec.field_1350);
        }
    }

    private void applyPowerEnchantment(class_1665 arrow, class_1799 bow, class_1937 level) {
        class_6880<class_1887> power = this.getEnchantmentHolder(level, (class_5321<class_1887>)class_1893.field_9103);
        int powerLevel = class_1890.method_8225(power, (class_1799)bow);
        if (powerLevel > 0) {
            double extraDamage = 0.5 * (double)powerLevel + 1.0;
            arrow.method_7438(arrow.method_7448() + extraDamage);
        }
    }

    private boolean hasInfinityEnchantment(class_1799 bow, class_1937 level) {
        class_6880<class_1887> infinity = this.getEnchantmentHolder(level, (class_5321<class_1887>)class_1893.field_9125);
        return class_1890.method_8225(infinity, (class_1799)bow) > 0;
    }

    private class_6880<class_1887> getEnchantmentHolder(class_1937 level, class_5321<class_1887> enchantmentKey) {
        return level.method_30349().method_30530(class_7924.field_41265).method_40290(enchantmentKey);
    }

    public static float getPowerForTime(int charge) {
        float f = (float)charge / 16.0f;
        f = (f * f + f * 2.0f) / 3.0f;
        return Math.min(f, 1.0f);
    }

    public Predicate<class_1799> method_19268() {
        return field_18281;
    }

    public int method_7881(class_1799 stack, class_1309 entity) {
        return 72000;
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8953;
    }

    public boolean method_7870(class_1799 stack) {
        return true;
    }

    public int method_7837() {
        return 16;
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        boolean hasArrows;
        class_1799 bowStack = player.method_5998(hand);
        boolean bl = hasArrows = !player.method_18808(bowStack).method_7960();
        if (!player.method_56992() && !hasArrows) {
            return class_1271.method_22431((Object)bowStack);
        }
        player.method_6019(hand);
        return class_1271.method_22428((Object)bowStack);
    }

    public int method_24792() {
        return 64;
    }

    public boolean method_7878(class_1799 toRepair, class_1799 repair) {
        return repair.method_31574((class_1792)ItemRegistry.POWER_CRYSTAL.get());
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltipComponents, class_1836 tooltipFlag) {
        if (class_437.method_25442()) {
            tooltipComponents.add((class_2561)class_2561.method_43471((String)"item.many_bows.scatter_bow.tooltip").method_27692(class_124.field_1065));
            tooltipComponents.add((class_2561)class_2561.method_43471((String)"item.many_bows.scatter_bow.tooltip.ability").method_27692(class_124.field_1077));
        } else {
            tooltipComponents.add((class_2561)class_2561.method_43471((String)"item.too_many_bows.hold_shift"));
        }
    }
}

