/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.many_bows.item;

import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import net.bandit.many_bows.entity.VitalityArrow;
import net.bandit.many_bows.registry.ItemRegistry;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1676;
import net.minecraft.class_1744;
import net.minecraft.class_1753;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_437;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public class VerdantVigorBow
extends class_1753 {
    private static final int HEALTH_BOOST_LEVEL = 1;
    private static final int REGENERATION_DURATION = 40;
    private static final int HEALTH_BOOST_DURATION = 100;
    private static final int BUFFER_DURATION = 100;
    private static final int HEALTH_BOOST_HEARTS = 4;
    private static final UUID BONUS_HEALTH_UUID = UUID.fromString("d4c9e510-70a4-4a27-b4e1-7f54e882e58a");
    private int bufferTimer = 0;

    public VerdantVigorBow(class_1792.class_1793 properties) {
        super(properties);
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            if (!world.field_9236) {
                boolean isHoldingBow = player.method_6047() == stack || player.method_6079() == stack;
                class_6880 attribute = class_5134.field_23716;
                class_2960 BONUS_HEALTH_ID = class_2960.method_60655((String)"many_bows", (String)"verdant_vigor_bonus_health");
                class_1324 attr = player.method_5996(attribute);
                if (attr == null) {
                    return;
                }
                if (isHoldingBow) {
                    if (attr.method_6199(BONUS_HEALTH_ID) == null) {
                        attr.method_26837(new class_1322(BONUS_HEALTH_ID, 8.0, class_1322.class_1323.field_6328));
                    }
                } else if (attr.method_6199(BONUS_HEALTH_ID) != null) {
                    attr.method_6200(BONUS_HEALTH_ID);
                }
                if (isHoldingBow && world.method_8510() % 40L == 0L) {
                    class_238 area = new class_238(player.method_23317() - 5.0, player.method_23318() - 5.0, player.method_23321() - 5.0, player.method_23317() + 5.0, player.method_23318() + 5.0, player.method_23321() + 5.0);
                    world.method_8333((class_1297)player, area, e -> e instanceof class_1309 && e.method_5805() && e != player && (e.method_5864().method_5891().method_6136() || e instanceof class_1657)).forEach(entityNearby -> ((class_1309)entityNearby).method_6092(new class_1293(class_1294.field_5924, 40, 0, true, false, false)));
                }
            }
        }
    }

    public void method_7840(class_1799 bowStack, class_1937 level, class_1309 entity, int chargeTime) {
        int charge;
        float power;
        class_1657 player;
        class_1799 arrowStack;
        if (entity instanceof class_1657 && (!(arrowStack = (player = (class_1657)entity).method_18808(bowStack)).method_7960() || player.method_31549().field_7477) && (power = VerdantVigorBow.getPowerForTime(charge = this.method_7881(bowStack, entity) - chargeTime)) >= 0.1f) {
            List projectiles = VerdantVigorBow.method_57390((class_1799)bowStack, (class_1799)arrowStack, (class_1309)player);
            boolean arrowConsumed = false;
            if (!projectiles.isEmpty() && level instanceof class_3218) {
                class_3218 serverLevel = (class_3218)level;
                for (class_1799 projectileStack : projectiles) {
                    class_1665 arrow;
                    if (projectileStack.method_31574(class_1802.field_8236) || projectileStack.method_31574(class_1802.field_8087)) {
                        arrow = ((class_1744)projectileStack.method_7909()).method_7702((class_1937)serverLevel, projectileStack, (class_1309)player, bowStack);
                    } else {
                        arrow = new VitalityArrow((class_1937)serverLevel, (class_1309)player, bowStack, projectileStack);
                        if (arrow instanceof VitalityArrow) {
                            class_1324 attrInstance;
                            VitalityArrow vitalityArrow = (VitalityArrow)arrow;
                            class_6880 rangedDamageAttr = level.method_30349().method_30530(class_7924.field_41251).method_55841(class_2960.method_60655((String)"ranged_weapon", (String)"damage")).orElse(null);
                            if (rangedDamageAttr != null && (attrInstance = player.method_5996(rangedDamageAttr)) != null) {
                                float damage = (float)attrInstance.method_6194();
                                vitalityArrow.method_7438((double)damage / 2.25);
                            }
                        }
                    }
                    this.applyPowerEnchantment(arrow, bowStack, level);
                    this.applyKnockbackEnchantment(arrow, bowStack, (class_1309)player, level);
                    this.applyFlameEnchantment(arrow, bowStack, level);
                    arrow.field_7572 = this.hasInfinityEnchantment(bowStack, level) || player.method_31549().field_7477 ? class_1665.class_1666.field_7594 : class_1665.class_1666.field_7593;
                    arrow.method_24919((class_1297)player, player.method_36455(), player.method_36454(), 0.0f, power * 2.5f, 1.0f);
                    serverLevel.method_8649((class_1297)arrow);
                    if (this.hasInfinityEnchantment(bowStack, level) || player.method_31549().field_7477 || arrowConsumed) continue;
                    projectileStack.method_7934(1);
                    arrowConsumed = true;
                }
            }
            level.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14600, class_3419.field_15248, 1.0f, 1.0f);
            player.method_7259(class_3468.field_15372.method_14956((Object)this));
            if (!player.method_31549().field_7477) {
                bowStack.method_7970(1, (class_1309)player, class_1304.field_6173);
            }
        }
    }

    private void applyFlameEnchantment(class_1665 arrow, class_1799 bow, class_1937 level) {
        class_6880<class_1887> flame = this.getEnchantmentHolder(level, (class_5321<class_1887>)class_1893.field_9126);
        int flameLevel = class_1890.method_8225(flame, (class_1799)bow);
        if (flameLevel > 0) {
            arrow.method_5639(5.0f);
        }
    }

    private void applyKnockbackEnchantment(class_1665 arrow, class_1799 bow, class_1309 shooter, class_1937 level) {
        class_6880<class_1887> punch = this.getEnchantmentHolder(level, (class_5321<class_1887>)class_1893.field_9116);
        int punchLevel = class_1890.method_8225(punch, (class_1799)bow);
        if (punchLevel > 0) {
            double resistance = Math.max(0.0, 1.0 - shooter.method_45325(class_5134.field_23718));
            class_243 knockbackVec = arrow.method_18798().method_1029().method_1021((double)punchLevel * 0.6 * resistance);
            arrow.method_5762(knockbackVec.field_1352, 0.1, knockbackVec.field_1350);
        }
    }

    private void applyPowerEnchantment(class_1665 arrow, class_1799 bow, class_1937 level) {
        class_6880<class_1887> power = this.getEnchantmentHolder(level, (class_5321<class_1887>)class_1893.field_9103);
        int powerLevel = class_1890.method_8225(power, (class_1799)bow);
        if (powerLevel > 0) {
            double extraDamage = 0.5 * (double)powerLevel + 1.0;
            arrow.method_7438(arrow.method_7448() + extraDamage);
        }
    }

    private boolean hasInfinityEnchantment(class_1799 bow, class_1937 level) {
        class_6880<class_1887> infinity = this.getEnchantmentHolder(level, (class_5321<class_1887>)class_1893.field_9125);
        return class_1890.method_8225(infinity, (class_1799)bow) > 0;
    }

    private class_6880<class_1887> getEnchantmentHolder(class_1937 level, class_5321<class_1887> enchantmentKey) {
        return level.method_30349().method_30530(class_7924.field_41265).method_40290(enchantmentKey);
    }

    protected void method_7763(class_1309 shooter, class_1676 projectile, int index, float velocity, float inaccuracy, float angle, @Nullable class_1309 target) {
        projectile.method_24919((class_1297)shooter, shooter.method_36455(), shooter.method_36454() + angle, 0.0f, velocity, inaccuracy);
    }

    public static float getPowerForTime(int pCharge) {
        float f = (float)pCharge / 16.0f;
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public Predicate<class_1799> method_19268() {
        return field_18281;
    }

    public int method_7881(class_1799 stack, class_1309 entity) {
        return 72000;
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8953;
    }

    public boolean method_7870(class_1799 stack) {
        return true;
    }

    public int method_7837() {
        return 16;
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        boolean hasArrows;
        class_1799 bowStack = player.method_5998(hand);
        boolean bl = hasArrows = !player.method_18808(bowStack).method_7960();
        if (!player.method_56992() && !hasArrows) {
            return class_1271.method_22431((Object)bowStack);
        }
        player.method_6019(hand);
        return class_1271.method_22428((Object)bowStack);
    }

    public int method_24792() {
        return 64;
    }

    public boolean method_7878(class_1799 toRepair, class_1799 repair) {
        return repair.method_31574((class_1792)ItemRegistry.POWER_CRYSTAL.get());
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltipComponents, class_1836 tooltipFlag) {
        if (class_437.method_25442()) {
            tooltipComponents.add((class_2561)class_2561.method_43471((String)"item.many_bows.verdant_vigor.tooltip").method_27692(class_124.field_1060));
            tooltipComponents.add((class_2561)class_2561.method_43471((String)"item.many_bows.verdant_vigor.tooltip.ability").method_27692(class_124.field_1065));
        } else {
            tooltipComponents.add((class_2561)class_2561.method_43471((String)"item.too_many_bows.hold_shift").method_27692(class_124.field_1054));
        }
    }
}

