/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.many_bows.entity;

import net.bandit.many_bows.registry.EntityRegistry;
import net.bandit.many_bows.util.AncientSageDamageSource;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;

public class AncientSageArrow
extends AbstractArrow {
    private static final float DEFAULT_ARMOR_PENETRATION_FACTOR = 0.33f;
    private static final int PARTICLE_LIFESPAN = 60;
    private float armorPenetration = 0.33f;
    private int particleTicksRemaining = 60;

    public AncientSageArrow(EntityType<? extends AncientSageArrow> entityType, Level level) {
        super(entityType, level);
    }

    public AncientSageArrow(Level level, LivingEntity shooter) {
        super((EntityType)EntityRegistry.ANCIENT_SAGE_ARROW.get(), shooter, level);
    }

    public void setArmorPenetration(float armorPenetration) {
        this.armorPenetration = armorPenetration;
    }

    protected void m_5790_(EntityHitResult result) {
        Entity entity;
        super.m_5790_(result);
        if (!this.m_9236_().m_5776_() && (entity = result.m_82443_()) instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            float baseDamage = (float)this.m_36789_();
            float armorReducedDamage = baseDamage * (1.0f - this.armorPenetration);
            target.m_6469_(AncientSageDamageSource.create(this.m_9236_(), (Entity)this, this.m_19749_()), armorReducedDamage);
            this.createHitParticles();
        }
        this.m_146870_();
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.particleTicksRemaining > 0) {
            this.createTrailParticles();
            --this.particleTicksRemaining;
        }
    }

    private void createHitParticles() {
        for (int i = 0; i < 15; ++i) {
            double offsetX = (this.f_19796_.m_188500_() - 0.5) * 0.5;
            double offsetY = this.f_19796_.m_188500_() * 0.5;
            double offsetZ = (this.f_19796_.m_188500_() - 0.5) * 0.5;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123808_, this.m_20185_() + offsetX, this.m_20186_() + offsetY, this.m_20189_() + offsetZ, 0.0, 0.1, 0.0);
        }
    }

    private void createTrailParticles() {
        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_175827_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.05, 0.0);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    protected ItemStack m_7941_() {
        return new ItemStack((ItemLike)Items.f_42412_);
    }
}

