/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.many_bows.entity;

import java.util.List;
import net.bandit.many_bows.registry.EntityRegistry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;

public class DuskReaperArrow
extends AbstractArrow {
    private static final float BASE_DAMAGE = 8.0f;
    private static final int SLOWNESS_DURATION = 60;
    private static final int WEAKNESS_DURATION = 60;
    private static final int GLOW_DURATION = 200;
    private static final int HARM_DURATION = 100;
    private static final String MARK_TAG = "manybows_marked";
    private static final String MARK_PREFIX = "manybows_marked_until:";
    private static final int MARK_DURATION_TICKS = 200;

    public DuskReaperArrow(EntityType<? extends DuskReaperArrow> entityType, Level level) {
        super(entityType, level);
        this.m_36781_(8.0);
    }

    public DuskReaperArrow(Level level, LivingEntity shooter) {
        super((EntityType)EntityRegistry.DUSK_REAPER_ARROW.get(), shooter, level);
        this.m_36781_(8.0);
    }

    protected void m_5790_(EntityHitResult result) {
        Entity entity;
        super.m_5790_(result);
        if (!this.m_9236_().m_5776_() && (entity = result.m_82443_()) instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            if (target == this.m_19749_()) {
                return;
            }
            target.m_6469_(this.m_269291_().m_269425_(), (float)this.m_36789_());
            target.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 60, 1));
            target.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 60, 1));
            target.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 200, 0));
            target.m_7292_(new MobEffectInstance(MobEffects.f_19602_, 100, 0));
            long expireAt = target.m_9236_().m_46467_() + 200L;
            for (String tag : List.copyOf(target.m_19880_())) {
                if (!tag.startsWith(MARK_PREFIX)) continue;
                target.m_20137_(tag);
            }
            target.m_20049_(MARK_TAG);
            target.m_20049_(MARK_PREFIX + expireAt);
            Entity entity2 = this.m_19749_();
            if (entity2 instanceof LivingEntity) {
                LivingEntity shooter = (LivingEntity)entity2;
                shooter.m_213846_((Component)Component.m_237113_((String)("Marked " + target.m_5446_().getString() + " for death")));
            }
            target.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123745_, target.m_20185_(), target.m_20227_(0.5), target.m_20189_(), 0.0, 0.0, 0.0);
            for (int i = 0; i < 18; ++i) {
                target.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123746_, target.m_20185_(), target.m_20227_(0.5), target.m_20189_(), (target.m_217043_().m_188500_() - 0.5) * 0.4, target.m_217043_().m_188500_() * 0.2, (target.m_217043_().m_188500_() - 0.5) * 0.4);
            }
            target.m_9236_().m_6263_(null, target.m_20185_(), target.m_20186_(), target.m_20189_(), SoundEvents.f_12404_, SoundSource.PLAYERS, 0.8f, 0.9f + target.m_217043_().m_188501_() * 0.2f);
        }
        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11913_, SoundSource.PLAYERS, 1.0f, 0.5f);
        this.m_146870_();
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123746_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.1, 0.0);
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    protected ItemStack m_7941_() {
        return new ItemStack((ItemLike)Items.f_42412_);
    }

    public static boolean isMarked(LivingEntity entity) {
        block7: {
            if (entity == null || !entity.m_6084_()) {
                return false;
            }
            long now = entity.m_9236_().m_46467_();
            String expiryTag = null;
            for (String tag : entity.m_19880_()) {
                if (!tag.startsWith(MARK_PREFIX)) continue;
                expiryTag = tag;
                break;
            }
            if (expiryTag == null) {
                return entity.m_19880_().contains(MARK_TAG);
            }
            try {
                long until = Long.parseLong(expiryTag.substring(MARK_PREFIX.length()));
                if (now <= until) {
                    return true;
                }
                if (!entity.m_9236_().m_5776_()) {
                    entity.m_20137_(MARK_TAG);
                    entity.m_20137_(expiryTag);
                }
            }
            catch (NumberFormatException ignored) {
                if (entity.m_9236_().m_5776_()) break block7;
                entity.m_20137_(expiryTag);
            }
        }
        return false;
    }
}

