/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.many_bows.entity;

import java.util.List;
import net.bandit.many_bows.registry.EntityRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class RiftEntity
extends Entity {
    private int lifeTime = 60;
    private static final double PULL_RADIUS = 5.0;
    private static final double EXPLOSION_RADIUS = 4.0;
    private static final double PULL_STRENGTH = 0.1;
    private LivingEntity owner;

    public RiftEntity(EntityType<?> type, Level world) {
        super(type, world);
        this.f_19794_ = true;
    }

    public RiftEntity(Level world, double x, double y, double z) {
        this((EntityType)EntityRegistry.RIFT_ENTITY.get(), world);
        this.m_6034_(x, y, z);
    }

    public RiftEntity(Level world, LivingEntity owner, BlockPos pos) {
        this(world, (double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5);
        this.owner = owner;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.lifeTime-- <= 0) {
            if (!this.m_9236_().f_46443_) {
                this.explode();
            }
            this.m_146870_();
        } else {
            if (!this.m_9236_().f_46443_) {
                List entities = this.m_9236_().m_45933_((Entity)this, new AABB(this.m_20185_() - 5.0, this.m_20186_() - 5.0, this.m_20189_() - 5.0, this.m_20185_() + 5.0, this.m_20186_() + 5.0, this.m_20189_() + 5.0));
                for (Entity entity : entities) {
                    double dz;
                    double dy;
                    double dx;
                    double distance;
                    if (!(entity instanceof LivingEntity)) continue;
                    LivingEntity living = (LivingEntity)entity;
                    if (entity instanceof Player && ((Player)entity).m_150110_().f_35937_ || !((distance = Math.sqrt((dx = this.m_20185_() - living.m_20185_()) * dx + (dy = this.m_20186_() - living.m_20186_()) * dy + (dz = this.m_20189_() - living.m_20189_()) * dz)) > 0.1)) continue;
                    double strength = 0.1 / distance;
                    living.m_5997_(dx * strength, dy * strength, dz * strength);
                }
            }
            if (this.m_9236_().f_46443_) {
                int i;
                double corePulse = Math.sin((double)this.lifeTime * 0.1) * 0.5 + 1.5;
                for (i = 0; i < 30; ++i) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123789_, this.m_20185_() + this.f_19796_.m_188583_() * corePulse, this.m_20186_() + this.f_19796_.m_188583_() * corePulse, this.m_20189_() + this.f_19796_.m_188583_() * corePulse, 0.0, 0.0, 0.0);
                }
                for (i = 0; i < 20; ++i) {
                    double spawnRadius = 8.0;
                    double angle = this.f_19796_.m_188500_() * Math.PI * 2.0;
                    double offsetX = Math.cos(angle) * spawnRadius;
                    double offsetZ = Math.sin(angle) * spawnRadius;
                    double offsetY = (this.f_19796_.m_188500_() - 0.5) * 4.0;
                    double velocityX = (this.m_20185_() - (this.m_20185_() + offsetX)) * 0.2;
                    double velocityY = (this.m_20186_() - (this.m_20186_() + offsetY)) * 0.2;
                    double velocityZ = (this.m_20189_() - (this.m_20189_() + offsetZ)) * 0.2;
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123809_, this.m_20185_() + offsetX, this.m_20186_() + offsetY, this.m_20189_() + offsetZ, velocityX, velocityY, velocityZ);
                }
                for (int layer = 0; layer < 3; ++layer) {
                    double height = this.m_20186_() + (double)layer * 0.3;
                    double radius = 2.5 + (double)layer * 0.3;
                    for (int i2 = 0; i2 < 40; ++i2) {
                        double angle = ((double)this.lifeTime * 0.1 + (double)i2) % (Math.PI * 2);
                        double offsetX = Math.cos(angle) * radius;
                        double offsetZ = Math.sin(angle) * radius;
                        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123810_, this.m_20185_() + offsetX, height, this.m_20189_() + offsetZ, 0.0, 0.0, 0.0);
                    }
                }
                if (this.lifeTime % 20 == 0) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123812_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
                }
            }
        }
    }

    private void explode() {
        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11913_, SoundSource.PLAYERS, 1.0f, 1.0f);
        List entities = this.m_9236_().m_6443_(LivingEntity.class, new AABB(this.m_20185_() - 4.0, this.m_20186_() - 4.0, this.m_20189_() - 4.0, this.m_20185_() + 4.0, this.m_20186_() + 4.0, this.m_20189_() + 4.0), e -> e.m_6084_() && (!(e instanceof Player) || !((Player)e).m_150110_().f_35937_));
        for (LivingEntity target : entities) {
            float damage = 8.0f;
            DamageSource source = this.m_9236_().m_269111_().m_269333_(this.owner);
            target.m_6469_(source, damage);
        }
    }

    protected void m_8097_() {
    }

    protected void m_7378_(CompoundTag compound) {
        this.lifeTime = compound.m_128451_("LifeTime");
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128405_("LifeTime", this.lifeTime);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }
}

