/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.many_bows.item;

import java.util.List;
import net.bandit.many_bows.registry.ItemRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ArcaneBow
extends BowItem {
    public ArcaneBow(Item.Properties properties) {
        super(properties);
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity entity, int timeCharged) {
        if (entity instanceof Player) {
            ItemStack arrowStack;
            Player player = (Player)entity;
            int charge = this.m_8105_(stack) - timeCharged;
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12348_, SoundSource.PLAYERS, 1.0f, 1.0f);
            boolean hasInfinity = player.m_150110_().f_35937_ || EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44952_, (ItemStack)stack) > 0;
            ItemStack itemStack = arrowStack = hasInfinity ? ItemStack.f_41583_ : player.m_6298_(stack);
            if (charge >= 20 && (hasInfinity || !arrowStack.m_41619_())) {
                this.fireExtraArrows(level, player, hasInfinity, arrowStack, stack);
                stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(player.m_7655_()));
            }
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        }
    }

    private void fireExtraArrows(Level level, Player player, boolean hasInfinity, ItemStack arrowStack, ItemStack bowStack) {
        boolean consumeArrow;
        float basePitch = player.m_146909_();
        float baseYaw = player.m_146908_();
        boolean bl = consumeArrow = !hasInfinity && !arrowStack.m_41619_();
        if (consumeArrow) {
            arrowStack.m_41774_(1);
            if (arrowStack.m_41619_()) {
                player.m_150109_().m_36057_(arrowStack);
            }
        }
        boolean hasPickedUpArrow = false;
        for (int i = -1; i <= 1; ++i) {
            ArrowItem arrowItem = (ArrowItem)(arrowStack.m_41720_() instanceof ArrowItem ? arrowStack.m_41720_() : Items.f_42412_);
            AbstractArrow arrow = arrowItem.m_6394_(level, arrowStack, (LivingEntity)player);
            arrow.m_37251_((Entity)player, basePitch, baseYaw + (float)i * 5.0f, 0.0f, 4.0f, 1.0f);
            int powerLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44988_, (ItemStack)bowStack);
            if (powerLevel > 0) {
                arrow.m_36781_(arrow.m_36789_() + (double)powerLevel * 0.5 + 4.0);
            } else {
                arrow.m_36781_(arrow.m_36789_() + 4.0);
            }
            int punchLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44989_, (ItemStack)bowStack);
            if (punchLevel > 0) {
                arrow.m_36735_(punchLevel);
            }
            if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44990_, (ItemStack)bowStack) > 0) {
                arrow.m_20254_(100);
            }
            if (!hasPickedUpArrow) {
                arrow.f_36705_ = hasInfinity ? AbstractArrow.Pickup.CREATIVE_ONLY : AbstractArrow.Pickup.ALLOWED;
                hasPickedUpArrow = true;
            } else {
                arrow.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
            }
            level.m_7967_((Entity)arrow);
        }
        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11687_, SoundSource.PLAYERS, 1.0f, 1.0f);
        player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return repair.m_150930_((Item)ItemRegistry.POWER_CRYSTAL.get());
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        if (Screen.m_96638_()) {
            tooltip.add((Component)Component.m_237115_((String)"item.many_bows.arcane_bow.tooltip").m_130940_(ChatFormatting.LIGHT_PURPLE));
            tooltip.add((Component)Component.m_237115_((String)"item.many_bows.arcane_bow.tooltip.ability").m_130940_(ChatFormatting.GOLD));
            tooltip.add((Component)Component.m_237115_((String)"item.many_bows.arcane_bow.tooltip.legend").m_130944_(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"item.too_many_bows.hold_shift"));
        }
    }
}

