/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.many_bows.item;

import java.util.List;
import java.util.function.Predicate;
import net.bandit.many_bows.entity.AuroraArrowEntity;
import net.bandit.many_bows.registry.ItemRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AuroraBow
extends BowItem {
    public AuroraBow(Item.Properties properties) {
        super(properties);
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity entity, int timeCharged) {
        if (entity instanceof Player) {
            int charge;
            float power;
            Player player = (Player)entity;
            if (!level.m_5776_() && (power = AuroraBow.m_40661_((int)(charge = this.m_8105_(stack) - timeCharged))) >= 0.1f) {
                ItemStack arrowStack;
                boolean hasInfinity = player.m_150110_().f_35937_ || EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44952_, (ItemStack)stack) > 0;
                ItemStack itemStack = arrowStack = hasInfinity ? ItemStack.f_41583_ : player.m_6298_(stack);
                if (!arrowStack.m_41619_() || hasInfinity) {
                    if (this.consumeRiftShard(player, 1)) {
                        this.fireRiftArrow(level, player, arrowStack, hasInfinity, stack, power);
                        stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(player.m_7655_()));
                    } else {
                        player.m_5661_((Component)Component.m_237115_((String)"item.many_bows.aurora_bow.no_rift_shard").m_130940_(ChatFormatting.RED), true);
                    }
                } else {
                    player.m_5661_((Component)Component.m_237115_((String)"item.many_bows.aurora_bow.no_arrows").m_130940_(ChatFormatting.RED), true);
                }
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            }
        }
    }

    private void fireRiftArrow(Level level, Player player, ItemStack arrowStack, boolean hasInfinity, ItemStack bowStack, float power) {
        AuroraArrowEntity riftArrow = new AuroraArrowEntity(level, (LivingEntity)player);
        riftArrow.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, power * 3.0f, 1.0f);
        this.applyEnchantments(bowStack, riftArrow);
        if (hasInfinity) {
            riftArrow.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
        } else {
            arrowStack.m_41774_(1);
            if (arrowStack.m_41619_()) {
                player.m_150109_().m_36057_(arrowStack);
            }
        }
        level.m_7967_((Entity)riftArrow);
        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11687_, SoundSource.PLAYERS, 1.0f, 1.0f / (level.m_213780_().m_188501_() * 0.4f + 1.2f) + power * 0.5f);
        player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
    }

    private void applyEnchantments(ItemStack stack, AuroraArrowEntity arrow) {
        int punchLevel;
        int powerLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44988_, (ItemStack)stack);
        if (powerLevel > 0) {
            arrow.m_36781_(arrow.m_36789_() + (double)powerLevel * 0.5 + 1.0);
        }
        if ((punchLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44989_, (ItemStack)stack)) > 0) {
            arrow.m_36735_(punchLevel);
        }
        if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44990_, (ItemStack)stack) > 0) {
            arrow.m_20254_(100);
        }
    }

    private boolean consumeRiftShard(Player player, int count) {
        if (player.m_150110_().f_35937_) {
            return true;
        }
        int shardsRemoved = 0;
        for (ItemStack stack : player.m_150109_().f_35974_) {
            if (stack.m_41720_() != ItemRegistry.RIFT_SHARD.get()) continue;
            int removeAmount = Math.min(stack.m_41613_(), count - shardsRemoved);
            stack.m_41774_(removeAmount);
            if ((shardsRemoved += removeAmount) < count) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public Predicate<ItemStack> m_6437_() {
        return stack -> stack.m_41720_() instanceof ArrowItem;
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return repair.m_150930_((Item)ItemRegistry.POWER_CRYSTAL.get());
    }

    public boolean m_8120_(ItemStack stack) {
        return true;
    }

    public int m_6473_() {
        return 20;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        if (Screen.m_96638_()) {
            tooltip.add((Component)Component.m_237115_((String)"item.many_bows.aurora_bow.tooltip.extended").m_130940_(ChatFormatting.GRAY));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"item.many_bows.aurora_bow.tooltip").m_130940_(ChatFormatting.AQUA));
            tooltip.add((Component)Component.m_237115_((String)"item.too_many_bows.hold_shift").m_130944_(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}));
        }
    }
}

