/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.many_bows.item;

import java.util.List;
import net.bandit.many_bows.registry.ItemRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class SolarBow
extends BowItem {
    public SolarBow(Item.Properties properties) {
        super(properties);
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity entity, int timeCharged) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!level.m_5776_()) {
                ItemStack arrowStack;
                int charge = this.m_8105_(stack) - timeCharged;
                level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11705_, SoundSource.PLAYERS, 0.4f, 0.3f);
                boolean hasInfinity = player.m_150110_().f_35937_ || EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44952_, (ItemStack)stack) > 0;
                ItemStack itemStack = arrowStack = hasInfinity ? ItemStack.f_41583_ : player.m_6298_(stack);
                if (charge >= 20 && (hasInfinity || !arrowStack.m_41619_())) {
                    this.fireFlamingArrow(level, player, hasInfinity, stack);
                    stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(player.m_7655_()));
                    if (!hasInfinity && !arrowStack.m_41619_()) {
                        arrowStack.m_41774_(1);
                        if (arrowStack.m_41619_()) {
                            player.m_150109_().m_36057_(arrowStack);
                        }
                    }
                } else {
                    level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11686_, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            }
        }
    }

    private void fireFlamingArrow(Level level, Player player, boolean hasInfinity, ItemStack stack) {
        if (!level.m_5776_()) {
            int punchLevel;
            Arrow arrow = new Arrow(level, (LivingEntity)player);
            int powerLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44988_, (ItemStack)stack);
            if (powerLevel > 0) {
                arrow.m_36781_(arrow.m_36789_() + (double)powerLevel * 0.5 + 0.5);
            }
            if ((punchLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44989_, (ItemStack)stack)) > 0) {
                arrow.m_36735_(punchLevel);
            }
            if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44990_, (ItemStack)stack) > 0) {
                arrow.m_20254_(100);
            }
            if (hasInfinity) {
                arrow.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
            }
            arrow.m_20254_(100);
            arrow.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 3.0f, 1.0f);
            arrow.m_36781_(arrow.m_36789_() + 4.0);
            level.m_7967_((Entity)arrow);
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11874_, SoundSource.PLAYERS, 0.8f, 1.2f);
        }
    }

    private ItemStack findArrowInInventory(Player player) {
        for (ItemStack stack : player.m_150109_().f_35974_) {
            if (!(stack.m_41720_() instanceof ArrowItem)) continue;
            return stack;
        }
        return ItemStack.f_41583_;
    }

    public void m_5929_(Level level, LivingEntity entity, ItemStack stack, int timeLeft) {
        super.m_5929_(level, entity, stack, timeLeft);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            int charge = this.m_8105_(stack) - timeLeft;
            if (charge == 10) {
                level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11701_, SoundSource.PLAYERS, 0.4f, 1.0f);
            }
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        if (Screen.m_96638_()) {
            tooltip.add((Component)Component.m_237115_((String)"item.many_bows.solar_bow.tooltip").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}));
            tooltip.add((Component)Component.m_237115_((String)"item.many_bows.solar_bow.tooltip.ability").m_130938_(style -> style.m_131148_(TextColor.m_131266_((int)16729344))));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"item.too_many_bows.hold_shift"));
        }
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return repair.m_150930_((Item)ItemRegistry.POWER_CRYSTAL.get());
    }
}

