/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.many_bows.item;

import java.util.List;
import net.bandit.many_bows.entity.VitalityArrow;
import net.bandit.many_bows.registry.ItemRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class VerdantVigorBow
extends BowItem {
    private static final int HEALTH_BOOST_LEVEL = 1;
    private static final int REGENERATION_DURATION = 40;
    private static final int HEALTH_BOOST_DURATION = 100;
    private static final int BUFFER_DURATION = 100;
    private static final int HEALTH_BOOST_HEARTS = 4;
    private int bufferTimer = 0;

    public VerdantVigorBow(Item.Properties properties) {
        super(properties);
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!world.f_46443_) {
                boolean isHoldingBow;
                boolean bl = isHoldingBow = player.m_21205_() == stack || player.m_21206_() == stack;
                if (isHoldingBow) {
                    this.bufferTimer = 100;
                    MobEffectInstance healthBoost = player.m_21124_(MobEffects.f_19616_);
                    if (healthBoost == null || healthBoost.m_19564_() != 1 || healthBoost.m_19557_() < 60) {
                        player.m_7292_(new MobEffectInstance(MobEffects.f_19616_, 100, 1, true, false, false));
                        if (player.m_21223_() < player.m_21233_()) {
                            player.m_21153_(Math.min(player.m_21233_(), player.m_21223_() + 8.0f));
                        }
                    }
                    if (world.m_46467_() % 40L == 0L) {
                        AABB area = new AABB(player.m_20185_() - 5.0, player.m_20186_() - 5.0, player.m_20189_() - 5.0, player.m_20185_() + 5.0, player.m_20186_() + 5.0, player.m_20189_() + 5.0);
                        world.m_6249_((Entity)player, area, e -> e instanceof LivingEntity && e.m_6084_() && e != player).forEach(entityNearby -> {
                            if (entityNearby instanceof LivingEntity) {
                                LivingEntity livingEntity = (LivingEntity)entityNearby;
                                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 40, 0, true, false, false));
                            }
                        });
                    }
                } else if (this.bufferTimer > 0) {
                    --this.bufferTimer;
                } else if (player.m_21023_(MobEffects.f_19616_)) {
                    player.m_21195_(MobEffects.f_19616_);
                }
            }
        }
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity entity, int timeCharged) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!level.f_46443_) {
                ItemStack arrowStack;
                int charge = this.m_8105_(stack) - timeCharged;
                float power = VerdantVigorBow.m_40661_((int)charge);
                boolean hasInfinity = player.m_150110_().f_35937_ || EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44952_, (ItemStack)stack) > 0;
                ItemStack itemStack = arrowStack = hasInfinity ? ItemStack.f_41583_ : player.m_6298_(stack);
                if (power >= 0.1f && (hasInfinity || !arrowStack.m_41619_())) {
                    int punchLevel;
                    VitalityArrow arrow = new VitalityArrow(level, (LivingEntity)player);
                    arrow.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, power * 3.0f, 1.0f);
                    arrow.m_36781_(8.0);
                    int powerLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44988_, (ItemStack)stack);
                    if (powerLevel > 0) {
                        arrow.m_36781_(arrow.m_36789_() + (double)powerLevel * 0.5 + 0.5);
                    }
                    if ((punchLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44989_, (ItemStack)stack)) > 0) {
                        arrow.m_36735_(punchLevel);
                    }
                    if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44990_, (ItemStack)stack) > 0) {
                        arrow.m_20254_(100);
                    }
                    arrow.f_36705_ = hasInfinity ? AbstractArrow.Pickup.CREATIVE_ONLY : AbstractArrow.Pickup.ALLOWED;
                    arrow.setOnHitCallback(target -> target.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 100, 1)));
                    level.m_7967_((Entity)arrow);
                    level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11687_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    if (!hasInfinity && !arrowStack.m_41619_()) {
                        arrowStack.m_41774_(1);
                        if (arrowStack.m_41619_()) {
                            player.m_150109_().m_36057_(arrowStack);
                        }
                    }
                    stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(player.m_7655_()));
                } else {
                    level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11686_, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            }
        }
    }

    public boolean m_8120_(ItemStack stack) {
        return true;
    }

    public int m_6473_() {
        return 15;
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return repair.m_150930_((Item)ItemRegistry.POWER_CRYSTAL.get());
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        if (Screen.m_96638_()) {
            tooltip.add((Component)Component.m_237115_((String)"item.many_bows.verdant_vigor.tooltip").m_130940_(ChatFormatting.GREEN));
            tooltip.add((Component)Component.m_237115_((String)"item.many_bows.verdant_vigor.tooltip.ability").m_130940_(ChatFormatting.GOLD));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"item.too_many_bows.hold_shift").m_130940_(ChatFormatting.YELLOW));
        }
    }
}

