/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.many_bows.platform.forge;

import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import top.theillusivec4.curios.api.CuriosApi;

public class ForgeArrowHelper {
    public static boolean consumeArrows(Player player, int count) {
        boolean success;
        LazyOptional curiosHandler = CuriosApi.getCuriosHelper().getEquippedCurios((LivingEntity)player);
        if (curiosHandler.isPresent() && (success = curiosHandler.resolve().map(itemHandler -> ForgeArrowHelper.consumeFromItemHandler((IItemHandler)itemHandler, count)).orElse(false).booleanValue())) {
            System.out.println("Arrows consumed from Curios slot.");
            return true;
        }
        return ForgeArrowHelper.consumeFromVanillaInventory(player, count);
    }

    public static ItemStack findArrow(Player player) {
        LazyOptional curiosHandler = CuriosApi.getCuriosHelper().getEquippedCurios((LivingEntity)player);
        if (curiosHandler.isPresent()) {
            for (int slot = 0; slot < ((IItemHandlerModifiable)curiosHandler.resolve().get()).getSlots(); ++slot) {
                ItemStack stack = ((IItemHandlerModifiable)curiosHandler.resolve().get()).getStackInSlot(slot);
                if (stack.m_41619_()) continue;
                return stack;
            }
        }
        for (ItemStack stack : player.m_150109_().f_35974_) {
            if (stack.m_41619_()) continue;
            return stack;
        }
        return ItemStack.f_41583_;
    }

    private static boolean consumeFromItemHandler(IItemHandler itemHandler, int count) {
        int arrowsRemoved = 0;
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            ItemStack stack = itemHandler.getStackInSlot(slot);
            if (stack.m_41619_() || !(stack.m_41720_() instanceof ArrowItem)) continue;
            int removeAmount = Math.min(stack.m_41613_(), count - arrowsRemoved);
            stack.m_41774_(removeAmount);
            if ((arrowsRemoved += removeAmount) < count) continue;
            return true;
        }
        return false;
    }

    private static boolean consumeFromVanillaInventory(Player player, int count) {
        int arrowsRemoved = 0;
        for (ItemStack stack : player.m_150109_().f_35974_) {
            if (stack.m_41619_() || !(stack.m_41720_() instanceof ArrowItem)) continue;
            int removeAmount = Math.min(stack.m_41613_(), count - arrowsRemoved);
            stack.m_41774_(removeAmount);
            if ((arrowsRemoved += removeAmount) < count) continue;
            System.out.println("Arrows consumed from vanilla inventory.");
            return true;
        }
        System.out.println("Not enough arrows in vanilla inventory.");
        return false;
    }
}

