/*
 * Decompiled with CFR 0.152.
 */
package com.gaura.energizer.mixin;

import com.gaura.energizer.Energizer;
import com.gaura.energizer.mixin.InGameHudInvoker;
import com.gaura.energizer.utils.IPlayerEntity;
import com.gaura.energizer.utils.MyHeartType;
import com.gaura.energizer.utils.Utils;
import com.mojang.blaze3d.systems.RenderSystem;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1267;
import net.minecraft.class_1291;
import net.minecraft.class_1294;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_329.class})
public class InGameHudMixin {
    private static final class_2960 STAMINA_ICONS = new class_2960("energizer", "textures/stamina/stamina_icons.png");
    private static final int X_OFFSET = 82;
    private static final int Y_OFFSET = 39;
    private int lastFullFillTime = -1;
    private static final class_2960 ICONS = new class_2960("textures/gui/icons.png");
    private final class_5819 random = class_5819.method_43047();

    @Inject(method={"renderStatusBars"}, at={@At(value="TAIL")})
    private void renderStaminaBar(class_332 context, CallbackInfo ci) {
        class_310 client = class_310.method_1551();
        if (!(client.field_1724 == null || ((InGameHudInvoker)((Object)this)).invokeGetHeartCount(((InGameHudInvoker)((Object)this)).invokeGetRiddenEntity()) != 0 || client.field_1724.method_37908().method_8407() == class_1267.field_5801 && Energizer.CONFIG.disable_stamina_in_peaceful)) {
            int x = client.method_22683().method_4486() / 2 + 82 + Energizer.CONFIG.x_offset_stamina_bar;
            int y = client.method_22683().method_4502() - 39 - Energizer.CONFIG.y_offset_stamina_bar;
            int vigorIndex = -1;
            float maxStamina = (float)client.field_1724.method_26825(Energizer.STAMINA_ATTRIBUTE);
            float currentStamina = ((Float)client.field_1724.method_5841().method_12789(Energizer.STAMINA_DATA)).floatValue();
            boolean hasHunger = client.field_1724.method_6059(class_1294.field_5903);
            boolean hasVigor = client.field_1724.method_6059((class_1291)Energizer.VIGOR);
            boolean stopSprint = ((IPlayerEntity)client.field_1724).getStopSprint().method_10577("stopSprint");
            int lines = (int)Math.ceil(maxStamina / 20.0f);
            int fullIconsPerLine = (int)(currentStamina / 2.0f);
            boolean halfIcon = Math.floor(currentStamina) % 2.0 != 0.0;
            int backgroundsPerLine = (int)Math.ceil(maxStamina / 2.0f);
            if (hasVigor && Energizer.CONFIG.vigor_wave) {
                vigorIndex = client.field_1705.method_1738() % class_3532.method_15386((float)(maxStamina + 5.0f));
            }
            if (currentStamina == maxStamina) {
                if (this.lastFullFillTime == -1) {
                    this.lastFullFillTime = client.field_1705.method_1738();
                }
            } else {
                this.lastFullFillTime = -1;
            }
            int yDecrement = Utils.getYDecrement(maxStamina);
            int line = 0;
            while (line < lines) {
                int vigor;
                int u;
                int i;
                for (i = 0; i < Math.min(backgroundsPerLine, 10); ++i) {
                    u = this.lastFullFillTime != -1 && client.field_1705.method_1738() - this.lastFullFillTime < 3 && Energizer.CONFIG.stamina_blink ? 9 : 0;
                    vigor = this.getVigorIndex(i, maxStamina, vigorIndex, line);
                    context.method_25290(STAMINA_ICONS, x - i * 8, y - line * yDecrement - vigor, (float)u, 0.0f, 9, 9, 81, 9);
                }
                for (i = 0; i < Math.min(fullIconsPerLine, 10); ++i) {
                    u = hasVigor ? 72 : (stopSprint ? 36 : (hasHunger ? 54 : 18));
                    vigor = this.getVigorIndex(i, maxStamina, vigorIndex, line);
                    context.method_25290(STAMINA_ICONS, x - i * 8, y - line * yDecrement - vigor, (float)u, 0.0f, 9, 9, 81, 9);
                }
                if (halfIcon && fullIconsPerLine < 10) {
                    int u2 = stopSprint ? 45 : (hasHunger ? 63 : 27);
                    context.method_25290(STAMINA_ICONS, x - fullIconsPerLine * 8, y - line * yDecrement, (float)u2, 0.0f, 9, 9, 81, 9);
                    halfIcon = false;
                }
                ++line;
                fullIconsPerLine -= 10;
                backgroundsPerLine -= 10;
            }
        }
    }

    private int getVigorIndex(int i, float maxStamina, int vigorIndex, int line) {
        int index = 0;
        if ((float)i < maxStamina && i == vigorIndex - line * 10) {
            index = 2;
        }
        return index;
    }

    @Inject(method={"renderHealthBar"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderHealthBar(class_332 context, class_1657 player, int x, int y, int lines, int regeneratingHeartIndex, float maxHealth, int lastHealth, int health, int absorption, boolean blinking, CallbackInfo ci) {
        if (!FabricLoader.getInstance().isModLoaded("heartymeals") && Energizer.CONFIG.remove_hunger) {
            MyHeartType heartType = MyHeartType.fromPlayerState(player);
            int i = 9 * (player.method_37908().method_8401().method_152() ? 5 : 0);
            int j = class_3532.method_15384((double)((double)maxHealth / 2.0));
            int k = class_3532.method_15384((double)((double)absorption / 2.0));
            int l = j * 2;
            for (int m = j + k - 1; m >= 0; --m) {
                int healthAmount;
                boolean bl3;
                int s;
                int n = m / 10;
                int o = m % 10;
                int p = x + o * 8;
                int q = y - n * lines;
                if (lastHealth + absorption <= 4) {
                    q += this.random.method_43048(2);
                }
                if (m < j && m == regeneratingHeartIndex) {
                    q -= 2;
                }
                this.myDrawHeart(context, MyHeartType.CONTAINER, p, q, i, blinking, false);
                int r = m * 2;
                boolean bl = m >= j;
                boolean bl2 = bl;
                if (bl && (s = r - l) < absorption) {
                    boolean bl22 = s + 1 == absorption;
                    this.myDrawHeart(context, heartType == MyHeartType.WITHERED ? heartType : MyHeartType.ABSORBING, p, q, i, false, bl22);
                }
                if (blinking && r < health) {
                    bl3 = r + 1 == health;
                    this.myDrawHeart(context, heartType, p, q, i, true, bl3);
                }
                if ((healthAmount = Utils.getHealAmount(player.method_6047())) <= 0) {
                    healthAmount = Utils.getHealAmount(player.method_6079());
                }
                if (healthAmount > 0 && player.method_6032() < player.method_6063() && r < lastHealth + healthAmount && r >= lastHealth - healthAmount) {
                    class_310 client = class_310.method_1551();
                    int ticks = client.field_1705.method_1738();
                    float opacity = class_3532.method_15374((float)((float)ticks / Energizer.CONFIG.healing_animation_frequency)) * 0.5f + 0.5f;
                    bl3 = r + 1 == lastHealth + healthAmount;
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)opacity);
                    this.myDrawHeart(context, heartType, p, q, i, false, bl3);
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
                if (r >= lastHealth) continue;
                bl3 = r + 1 == lastHealth;
                this.myDrawHeart(context, heartType, p, q, i, false, bl3);
            }
            ci.cancel();
        }
    }

    private void myDrawHeart(class_332 context, MyHeartType type, int x, int y, int v, boolean blinking, boolean halfHeart) {
        context.method_25302(ICONS, x, y, type.getU(halfHeart, blinking), v, 9, 9);
    }
}

