/*
 * Decompiled with CFR 0.152.
 */
package com.gaura.energizer.mixin;

import com.gaura.energizer.Energizer;
import com.gaura.energizer.EnergizerClient;
import com.gaura.energizer.mixin.LivingEntityInvoker;
import com.gaura.energizer.utils.IPlayerEntity;
import com.gaura.energizer.utils.Utils;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1267;
import net.minecraft.class_1291;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1536;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3532;
import net.minecraft.class_5132;
import net.minecraft.class_5712;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1657.class})
public class PlayerEntityMixin
implements IPlayerEntity {
    @Shadow
    @Nullable
    public class_1536 field_7513;
    public boolean stopSprint;
    private long lastStaminaLossTime = 0L;
    private class_2487 persistentData;

    @Inject(method={"canConsume"}, at={@At(value="RETURN")}, cancellable=true)
    public void canConsume(boolean ignoreHunger, CallbackInfoReturnable<Boolean> cir) {
        class_1657 player;
        if (!FabricLoader.getInstance().isModLoaded("heartymeals") && Energizer.CONFIG.remove_hunger && !(player = (class_1657)this).method_7337()) {
            cir.setReturnValue((Object)(player.method_6032() != player.method_6063() || ignoreHunger ? 1 : 0));
        }
    }

    @Inject(method={"eatFood"}, at={@At(value="HEAD")}, cancellable=true)
    public void eatFood(class_1937 world, class_1799 stack, CallbackInfoReturnable<class_1799> cir) {
        if (!FabricLoader.getInstance().isModLoaded("heartymeals") && Energizer.CONFIG.remove_hunger) {
            class_1657 player = (class_1657)this;
            if (stack.method_19267() && player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                if (!world.method_8608()) {
                    serverPlayer.method_7259(class_3468.field_15372.method_14956((Object)stack.method_7909()));
                    world.method_43128(null, serverPlayer.method_23317(), serverPlayer.method_23318(), serverPlayer.method_23321(), class_3417.field_19149, class_3419.field_15248, 0.5f, world.field_9229.method_43057() * 0.1f + 0.9f);
                    ((LivingEntityInvoker)serverPlayer).invokeApplyFoodEffects(stack, world, (class_1309)serverPlayer);
                    class_174.field_1198.method_8821(serverPlayer, stack);
                    serverPlayer.method_6025((float)Utils.getHealAmount(stack));
                    if (!serverPlayer.method_7337()) {
                        stack.method_7934(1);
                    }
                    serverPlayer.method_32876(class_5712.field_28735);
                }
            }
            cir.setReturnValue((Object)stack);
        }
    }

    @Inject(method={"createPlayerAttributes"}, at={@At(value="RETURN")})
    private static void addStaminaAttribute(CallbackInfoReturnable<class_5132.class_5133> cir) {
        ((class_5132.class_5133)cir.getReturnValue()).method_26867(Energizer.STAMINA_ATTRIBUTE);
    }

    @Inject(method={"initDataTracker"}, at={@At(value="TAIL")})
    protected void addStaminaDataTracker(CallbackInfo ci) {
        class_1657 player = (class_1657)this;
        player.method_5841().method_12784(Energizer.STAMINA_DATA, (Object)Float.valueOf(1.0f));
    }

    @Inject(method={"tickMovement"}, at={@At(value="HEAD")})
    private void updateStamina(CallbackInfo ci) {
        class_1657 player = (class_1657)this;
        long currentTime = player.method_37908().method_8510();
        if (!(player.method_7337() || player.method_7325() || player.method_37908().field_9236 || player.method_37908().method_8407() == class_1267.field_5801 && Energizer.CONFIG.disable_stamina_in_peaceful)) {
            float staminaIncrease;
            boolean hasHunger = player.method_6059(class_1294.field_5903);
            float staminaDecrease = 0.0f;
            float f = hasHunger && this.stopSprint ? Energizer.CONFIG.stamina_increase_hunger_empty : (hasHunger ? Energizer.CONFIG.stamina_increase_hunger : (staminaIncrease = this.stopSprint ? Energizer.CONFIG.stamina_increase_empty : Energizer.CONFIG.stamina_increase));
            if (player.method_6059((class_1291)Energizer.VIGOR)) {
                this.setStamina(this.getMaxStamina());
                this.stopSprint = false;
            } else if (player.method_5765()) {
                if (this.getStamina() < this.getMaxStamina() && currentTime - this.lastStaminaLossTime >= (long)Energizer.CONFIG.stamina_regeneration_delay) {
                    this.setStamina(this.getStamina() + staminaIncrease);
                }
            } else if (player.method_5624() && !player.method_5869() && !this.stopSprint) {
                staminaDecrease = hasHunger ? Energizer.CONFIG.sprinting_stamina_decrease_hunger : Energizer.CONFIG.sprinting_stamina_decrease;
                this.setStamina(this.getStamina() - staminaDecrease);
                this.lastStaminaLossTime = currentTime;
                if (this.getStamina() <= 0.0f && Energizer.CONFIG.disable_sprint_swim_empty_stamina) {
                    this.stopSprint = true;
                }
            } else if (player.method_5681() && player.method_5869() && Energizer.CONFIG.swimming_cost_stamina && !this.stopSprint) {
                staminaDecrease = hasHunger ? Energizer.CONFIG.swimming_stamina_decrease_hunger : Energizer.CONFIG.swimming_stamina_decrease;
                this.setStamina(this.getStamina() - staminaDecrease);
                this.lastStaminaLossTime = currentTime;
                if (this.getStamina() <= 0.0f && Energizer.CONFIG.disable_sprint_swim_empty_stamina) {
                    this.stopSprint = true;
                }
            } else if (this.getStamina() < this.getMaxStamina() && currentTime - this.lastStaminaLossTime >= (long)Energizer.CONFIG.stamina_regeneration_delay) {
                this.setStamina(this.getStamina() + staminaIncrease);
            } else if (this.getStamina() == this.getMaxStamina()) {
                this.stopSprint = false;
            }
            class_2540 buf = PacketByteBufs.create();
            buf.writeBoolean(this.stopSprint);
            ServerPlayNetworking.send((class_3222)((class_3222)player), (class_2960)EnergizerClient.STOP_SPRINT_ID, (class_2540)buf);
        }
    }

    private float getStamina() {
        class_1657 player = (class_1657)this;
        return ((Float)player.method_5841().method_12789(Energizer.STAMINA_DATA)).floatValue();
    }

    private void setStamina(float stamina) {
        class_1657 player = (class_1657)this;
        player.method_5841().method_12778(Energizer.STAMINA_DATA, (Object)Float.valueOf(class_3532.method_15363((float)stamina, (float)0.0f, (float)this.getMaxStamina())));
    }

    private float getMaxStamina() {
        class_1657 player = (class_1657)this;
        return (float)player.method_26825(Energizer.STAMINA_ATTRIBUTE);
    }

    @Override
    public class_2487 getStopSprint() {
        if (this.persistentData == null) {
            this.persistentData = new class_2487();
        }
        return this.persistentData;
    }

    @Inject(method={"writeCustomDataToNbt"}, at={@At(value="TAIL")})
    private void writeCustomDataToNbt(class_2487 nbt, CallbackInfo ci) {
        nbt.method_10556("StopSprint", this.stopSprint);
        nbt.method_10548("Stamina", this.getStamina());
    }

    @Inject(method={"readCustomDataFromNbt"}, at={@At(value="TAIL")})
    private void readCustomDataFromNbt(class_2487 nbt, CallbackInfo ci) {
        if (nbt.method_10573("Stamina", 99)) {
            this.setStamina(nbt.method_10583("Stamina"));
        }
        if (nbt.method_10545("StopSprint")) {
            this.stopSprint = nbt.method_10577("StopSprint");
        }
    }
}

