/*
 * Decompiled with CFR 0.152.
 */
package net.uhb217.playertracker;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.github.cottonmc.cotton.gui.GuiDescription;
import java.util.Objects;
import java.util.UUID;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.uhb217.playertracker.client.Global;
import net.uhb217.playertracker.gui.GUI;
import net.uhb217.playertracker.gui.TestScreen;
import net.uhb217.playertracker.utils.NBTConfigUtils;
import net.uhb217.playertracker.utils.NetworkUtils;

@Environment(value=EnvType.CLIENT)
public class PlayerTrackerClient
implements ClientModInitializer,
Global {
    public void onInitializeClient() {
        this.registerCommands();
        this.registerKeyBindings();
    }

    private void registerCommands() {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"set_target").then(ClientCommandManager.argument((String)"target", (ArgumentType)StringArgumentType.string()).suggests(NetworkUtils.playerNameSuggestions).executes(context -> {
            String targetName = StringArgumentType.getString((CommandContext)context, (String)"target");
            UUID targetUUID = NetworkUtils.getPlayerUuidFromName(targetName);
            if (targetUUID != null) {
                NBTConfigUtils playerData = (NBTConfigUtils)((FabricClientCommandSource)context.getSource()).getClient().field_1724;
                Objects.requireNonNull(playerData).playerTracker$getPersistentData().method_25927("compass_target", targetUUID);
            } else {
                ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43470((String)"\u00a7r\u00a76Player Tracker:\u00a7r Compass target isn't in the game or in this dimension."));
            }
            return 1;
        }))));
    }

    private void registerKeyBindings() {
        class_304 openLSScreenKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("Open the player tracker screen", class_3675.class_307.field_1668, 82, "Player Tracker Keys"));
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (openLSScreenKey.method_1436() && client.field_1687 != null) {
                client.method_1507((class_437)new TestScreen((GuiDescription)new GUI()));
            }
        });
    }
}

