/*
 * Decompiled with CFR 0.152.
 */
package net.uhb217.playertracker.gui;

import io.github.cottonmc.cotton.gui.client.LightweightGuiDescription;
import io.github.cottonmc.cotton.gui.widget.WPanel;
import io.github.cottonmc.cotton.gui.widget.WPlainPanel;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import io.github.cottonmc.cotton.gui.widget.data.Insets;
import io.github.cottonmc.cotton.gui.widget.icon.Icon;
import io.github.cottonmc.cotton.gui.widget.icon.ItemIcon;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.uhb217.playertracker.client.Global;
import net.uhb217.playertracker.gui.widgets.Button;
import net.uhb217.playertracker.gui.widgets.SlotButton;
import net.uhb217.playertracker.utils.NBTConfigUtils;
import net.uhb217.playertracker.utils.NetworkUtils;

@Environment(value=EnvType.CLIENT)
public class GUI
extends LightweightGuiDescription
implements Global {
    private int page = 0;

    public GUI() {
        WPlainPanel root = new WPlainPanel().setInsets(new Insets(0, 0, 0, 0));
        this.setRootPanel((WPanel)root);
        root.setSize(118, 70);
        ArrayList<SlotButton> buttons = new ArrayList<SlotButton>();
        int index = 0;
        class_1799[] playerHeads = NetworkUtils.getPlayersHeads();
        String[] playerNames = NetworkUtils.getPlayersNames();
        class_2487 nbt = ((NBTConfigUtils)Objects.requireNonNull(GUI.mc.field_1724)).playerTracker$getPersistentData();
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 3; ++j) {
                buttons.add(new SlotButton());
                ((SlotButton)buttons.get(index)).setSize(25, 25);
                if (index < playerHeads.length && playerNames.length > 1) {
                    String playerName = playerNames[index];
                    ((SlotButton)buttons.get(index)).setToolTip((class_2561)class_2561.method_43470((String)playerName).method_27692(class_124.field_1078)).setIcon((Icon)new ItemIcon(playerHeads[index]));
                    ((SlotButton)buttons.get(index)).setOnClick(() -> {
                        UUID uuid = NetworkUtils.getPlayerUuidFromName(playerName);
                        if (uuid != null) {
                            nbt.method_10556("player_tracker", true);
                            nbt.method_25927("compass_target", uuid);
                            Objects.requireNonNull(GUI.mc.field_1755).method_25419();
                            GUI.mc.field_1724.method_43496((class_2561)class_2561.method_43470((String)("\u00a7r\u00a76Player Tracker:\u00a7r \u00a73The compass target set to: " + playerName)));
                        } else {
                            GUI.mc.field_1724.method_43496((class_2561)class_2561.method_43470((String)"\u00a7r\u00a76Player Tracker:\u00a7r Compass target isn't in the game or in this dimension.").method_27692(class_124.field_1061));
                        }
                    });
                } else {
                    buttons.set(index, SlotButton.defaultSlotButton(null));
                }
                root.add((WWidget)buttons.get(index), 15 + 20 * i, 5 + 20 * j);
                ++index;
            }
        }
        Button left = new Button(new class_2960("textures/gui/sprites/transferable_list/unselect.png")).setSelectedTexture(new class_2960("textures/gui/sprites/transferable_list/unselect_highlighted.png"));
        Button right = new Button(new class_2960("textures/gui/sprites/transferable_list/select.png")).setSelectedTexture(new class_2960("textures/gui/sprites/transferable_list/select_highlighted.png"));
        Button normal = new Button(new class_2960("textures/item/compass_19.png")).setToolTip((class_2561)class_2561.method_43470((String)"Returns the compass to normal").method_27692(class_124.field_1062));
        Button back = new Button(new class_2960("textures/gui/sprites/spectator/close.png")).setToolTip((class_2561)class_2561.method_43470((String)"Back").method_27692(class_124.field_1061));
        left.setOnClick(() -> this.scrollLeft(buttons, playerHeads, playerNames));
        right.setOnClick(() -> this.scrollRight(buttons, playerHeads, playerNames));
        normal.setOnClick(() -> {
            nbt.method_10556("player_tracker", false);
            GUI.mc.field_1724.method_43496((class_2561)class_2561.method_43470((String)"\u00a7r\u00a76Player Tracker:\u00a7r \u00a73The compass sets back to normal"));
        });
        back.setOnClick(() -> Objects.requireNonNull(GUI.mc.field_1755).method_25419());
        root.add((WWidget)left, 3, 15, 20, 40);
        root.add((WWidget)right, 109, 15, 20, 40);
        root.add((WWidget)normal, 5, 53, 10, 10);
        root.add((WWidget)back, 114, 53, 10, 10);
    }

    private void scrollLeft(List<SlotButton> buttons, class_1799[] playerHeads, String[] playerNames) {
        if (this.page == 0) {
            return;
        }
        --this.page;
        this.updateButtons(buttons, playerHeads, playerNames);
    }

    private void scrollRight(List<SlotButton> buttons, class_1799[] playerHeads, String[] playerNames) {
        ++this.page;
        this.updateButtons(buttons, playerHeads, playerNames);
    }

    private void updateButtons(List<SlotButton> buttons, class_1799[] playerHeads, String[] playerNames) {
        int counter = buttons.size() * this.page;
        for (SlotButton button : buttons) {
            if (counter < playerHeads.length && counter < playerNames.length && playerNames[counter] != null && !playerNames[counter].isEmpty()) {
                String playerName = playerNames[counter];
                class_2487 nbt = ((NBTConfigUtils)Objects.requireNonNull(GUI.mc.field_1724)).playerTracker$getPersistentData();
                button.setToolTip((class_2561)class_2561.method_43470((String)playerNames[counter]).method_27692(class_124.field_1078)).setIcon((Icon)new ItemIcon(playerHeads[counter]));
                button.setOnClick(() -> {
                    UUID uuid = NetworkUtils.getPlayerUuidFromName(playerName);
                    if (uuid != null) {
                        nbt.method_10556("player_tracker", true);
                        nbt.method_25927("compass_target", uuid);
                        GUI.mc.field_1755.method_25419();
                        GUI.mc.field_1724.method_43496((class_2561)class_2561.method_43470((String)("\u00a7r\u00a76Player Tracker:\u00a7r \u00a73The compass target set to: " + playerName)));
                    } else {
                        GUI.mc.field_1724.method_43496((class_2561)class_2561.method_43470((String)"\u00a7r\u00a76Player Tracker:\u00a7r Compass target not in the game or in this dimension.").method_27692(class_124.field_1061));
                    }
                });
            } else {
                button = SlotButton.defaultSlotButton(button);
            }
            ++counter;
        }
    }
}

