/*
 * Decompiled with CFR 0.152.
 */
package dontneg.improvedfletching;

import dontneg.improvedfletching.ImprovedFletching;
import dontneg.improvedfletching.codec.FletchingData;
import dontneg.improvedfletching.interfaces.ImplementedInventory;
import dontneg.improvedfletching.item.ArrowItems;
import dontneg.improvedfletching.screen.FletchingScreenHandler;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1262;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3914;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public class FletchingTableBlockEntity
extends class_2586
implements ExtendedScreenHandlerFactory,
ImplementedInventory {
    private final class_2371<class_1799> inventory = class_2371.method_10213((int)5, (Object)class_1799.field_8037);
    public static final class_2746 FILLED = class_2746.method_11825((String)"filled");
    private final class_2371<class_1799> oldInventory = class_2371.method_10213((int)5, (Object)class_1799.field_8037);
    public final List<class_1792> arrowTypes = Arrays.asList(class_1799.field_8037.method_7909(), class_1802.field_8107, ArrowItems.ARROW_BLAZE, ArrowItems.ARROW_CARROT, ArrowItems.ARROW_HONEY, ArrowItems.ARROW_QUARTZ);

    public FletchingTableBlockEntity(class_2338 pos, class_2680 state) {
        this(ImprovedFletching.FLETCHING_TABLE_ENTITY, pos, state);
    }

    public FletchingTableBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)"Fletching Table");
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new FletchingScreenHandler(syncId, playerInventory, this, class_3914.method_17392((class_1937)this.field_11863, (class_2338)this.field_11867));
    }

    @Override
    public class_2371<class_1799> getItems() {
        return this.inventory;
    }

    @Override
    public int method_5439() {
        return 5;
    }

    public void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        class_1262.method_5429((class_2487)nbt, this.inventory, (class_7225.class_7874)registryLookup);
    }

    public void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        class_1262.method_5426((class_2487)nbt, this.inventory, (class_7225.class_7874)registryLookup);
    }

    @Override
    public void method_5431() {
        assert (this.field_11863 != null);
        this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
        super.method_5431();
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, FletchingTableBlockEntity blockEntity) {
        int i;
        if (world.method_8608()) {
            return;
        }
        class_2371<class_1799> inventory = blockEntity.inventory;
        boolean changed = false;
        for (int o = 0; o < blockEntity.method_5439(); ++o) {
            if (((class_1799)inventory.get(o)).method_7909().equals(((class_1799)blockEntity.oldInventory.get(o)).method_7909()) && ((class_1799)inventory.get(o)).method_7947() == ((class_1799)blockEntity.oldInventory.get(o)).method_7947()) continue;
            changed = true;
            break;
        }
        if (changed) {
            if (((class_1799)blockEntity.inventory.get(3)).method_7960()) {
                Objects.requireNonNull(blockEntity.method_10997()).method_8501(pos, (class_2680)state.method_11657((class_2769)FILLED, (Comparable)Boolean.valueOf(false)));
            } else {
                Objects.requireNonNull(blockEntity.method_10997()).method_8501(pos, (class_2680)state.method_11657((class_2769)FILLED, (Comparable)Boolean.valueOf(true)));
            }
            for (i = 0; i < 6; ++i) {
                boolean hasModifier;
                boolean bl = hasModifier = i > 1;
                if (FletchingTableBlockEntity.arrowReady(blockEntity.inventory) != i) continue;
                FletchingTableBlockEntity.craft(blockEntity, blockEntity.arrowTypes.get(i).method_7854(), hasModifier);
                break;
            }
        }
        for (i = 0; i < blockEntity.method_5439(); ++i) {
            blockEntity.oldInventory.set(i, (Object)new class_1799((class_1935)((class_1799)inventory.get(i)).method_7909(), ((class_1799)inventory.get(i)).method_7947()));
        }
    }

    private static void craft(FletchingTableBlockEntity blockEntity, class_1799 output, boolean hasModifier) {
        int[] nArray;
        if (hasModifier) {
            int[] nArray2 = new int[4];
            nArray2[0] = 0;
            nArray2[1] = 1;
            nArray2[2] = 2;
            nArray = nArray2;
            nArray2[3] = 3;
        } else {
            int[] nArray3 = new int[3];
            nArray3[0] = 0;
            nArray3[1] = 1;
            nArray = nArray3;
            nArray3[2] = 2;
        }
        int[] indexes = nArray;
        int min = 64;
        for (int index : indexes) {
            int slotCount = ((class_1799)blockEntity.inventory.get(index)).method_7947();
            if (slotCount >= min) continue;
            min = slotCount;
        }
        if (((class_1799)blockEntity.inventory.get(4)).method_7947() == min && ((class_1799)blockEntity.inventory.get(4)).method_7909() == output.method_7909()) {
            return;
        }
        blockEntity.method_5431();
        blockEntity.method_5447(4, new class_1799((class_1935)output.method_7909(), min * 4));
    }

    public static boolean inventoryReady(class_2371<class_1799> inventory) {
        return ((class_1799)inventory.get(0)).method_31574(class_1802.field_8153) && ((class_1799)inventory.get(1)).method_31574(class_1802.field_8600) && ((class_1799)inventory.get(2)).method_31574(class_1802.field_8145);
    }

    public static int arrowReady(class_2371<class_1799> inventory) {
        List<class_1792> modifiers = ImprovedFletching.getModifiers();
        if (FletchingTableBlockEntity.inventoryReady(inventory)) {
            for (int i = 0; i < modifiers.size(); ++i) {
                if (!((class_1799)inventory.get(3)).method_7909().equals(modifiers.get(i))) continue;
                return i + 1;
            }
        }
        return 0;
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        return this.method_38244(registryLookup);
    }

    public Object getScreenOpeningData(class_3222 player) {
        return new FletchingData(this.method_11016());
    }
}

