/*
 * Decompiled with CFR 0.152.
 */
package net.almer.avm_mod.entity.custom;

import java.util.Collection;
import java.util.EnumSet;
import net.almer.avm_mod.entity.ModEntities;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1295;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1314;
import net.minecraft.class_1331;
import net.minecraft.class_1341;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1353;
import net.minecraft.class_1355;
import net.minecraft.class_1391;
import net.minecraft.class_1400;
import net.minecraft.class_1407;
import net.minecraft.class_1408;
import net.minecraft.class_1429;
import net.minecraft.class_1432;
import net.minecraft.class_1548;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3481;
import net.minecraft.class_3489;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4538;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5530;
import net.minecraft.class_5531;
import net.minecraft.class_5533;
import net.minecraft.class_5712;
import net.minecraft.class_5996;
import net.minecraft.class_6053;
import net.minecraft.class_6862;
import net.minecraft.class_7;
import org.jetbrains.annotations.Nullable;

public class CreeperBeeEntity
extends class_1429
implements class_1432 {
    public static final int field_28638 = class_3532.method_15386((float)1.4959966f);
    public static final String FLOWER_POS_KEY = "FlowerPos";
    private float currentPitch;
    private float lastPitch;
    @Nullable
    class_2338 flowerPos;
    private MoveToFlowerGoal moveToFlowerGoal;
    private int ticksInsideWater;
    private static final class_2940<Integer> FUSE_SPEED = class_2945.method_12791(class_1548.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> CHARGED = class_2945.method_12791(class_1548.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> IGNITED = class_2945.method_12791(class_1548.class, (class_2941)class_2943.field_13323);
    private int lastFuseTime;
    private int currentFuseTime;
    private int fuseTime = 30;
    private int explosionRadius = 3;

    public CreeperBeeEntity(class_1299<? extends class_1429> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6207 = new class_1331((class_1308)this, 20, true);
        this.method_5941(class_7.field_9, -1.0f);
        this.method_5941(class_7.field_18, -1.0f);
        this.method_5941(class_7.field_4, 16.0f);
        this.method_5941(class_7.field_21516, -1.0f);
        this.method_5941(class_7.field_10, -1.0f);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1391((class_1314)this, 1.25, class_1856.method_8106((class_6862)class_3489.field_20344), false));
        this.field_6201.method_6277(1, (class_1352)new CreeperIgniteGoal(this));
        this.field_6201.method_6277(2, (class_1352)new class_1341((class_1429)this, 1.0));
        this.field_6201.method_6277(5, (class_1352)new class_1353((class_1429)this, 1.25));
        this.moveToFlowerGoal = new MoveToFlowerGoal();
        this.field_6201.method_6277(6, (class_1352)this.moveToFlowerGoal);
        this.field_6201.method_6277(8, (class_1352)new BeeWanderAroundGoal());
        this.field_6201.method_6277(9, (class_1352)new class_1347((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
    }

    void startMovingTo(class_2338 pos) {
        class_243 vec3d2;
        class_243 vec3d = class_243.method_24955((class_2382)pos);
        int i = 0;
        class_2338 blockPos = this.method_24515();
        int j = (int)vec3d.field_1351 - blockPos.method_10264();
        if (j > 2) {
            i = 4;
        } else if (j < -2) {
            i = -4;
        }
        int k = 6;
        int l = 8;
        int m = blockPos.method_19455((class_2382)pos);
        if (m < 15) {
            k = m / 2;
            l = m / 2;
        }
        if ((vec3d2 = class_5531.method_31508((class_1314)this, (int)k, (int)l, (int)i, (class_243)vec3d, (double)0.3141592741012573)) == null) {
            return;
        }
        this.field_6189.method_23964(0.5f);
        this.field_6189.method_6337(vec3d2.field_1352, vec3d2.field_1351, vec3d2.field_1350, 1.0);
    }

    @Nullable
    public class_2338 getFlowerPos() {
        return this.flowerPos;
    }

    public boolean hasFlower() {
        return this.flowerPos != null;
    }

    public void setFlowerPos(class_2338 flowerPos) {
        this.flowerPos = flowerPos;
    }

    public float getBodyPitch(float tickDelta) {
        return class_3532.method_16439((float)tickDelta, (float)this.lastPitch, (float)this.currentPitch);
    }

    protected void method_5958() {
        int n = this.ticksInsideWater = this.method_5816() ? (this.ticksInsideWater = this.ticksInsideWater + 1) : 0;
        if (this.ticksInsideWater > 20) {
            this.method_5643(this.method_48923().method_48824(), 1.0f);
        }
        if (this.method_5968() != null && (this.method_5968().method_5998(class_1268.field_5808).method_40133().anyMatch(s -> s.method_41007(class_3489.field_20344.comp_326())) || this.method_5968().method_5998(class_1268.field_5810).method_40133().anyMatch(s -> s.method_41007(class_3489.field_20344.comp_326())))) {
            this.method_5980(null);
        }
    }

    @class_5996
    public class_1355 getGoalSelector() {
        return this.field_6201;
    }

    boolean isTooFar(class_2338 pos) {
        return !this.isWithinDistance(pos, 32);
    }

    public static class_5132.class_5133 createBeeAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 10.0).method_26868(class_5134.field_23720, (double)0.6f).method_26868(class_5134.field_23719, (double)0.3f).method_26868(class_5134.field_23721, 2.0).method_26868(class_5134.field_23717, 48.0);
    }

    public float method_6144(class_2338 pos, class_4538 world) {
        if (world.method_8320(pos).method_26215()) {
            return 10.0f;
        }
        return 0.0f;
    }

    protected class_1408 method_5965(class_1937 world) {
        class_1407 birdNavigation = new class_1407((class_1308)this, world){

            public boolean method_6333(class_2338 pos) {
                return !this.field_6677.method_8320(pos.method_10074()).method_26215();
            }
        };
        birdNavigation.method_6332(false);
        birdNavigation.method_6354(false);
        birdNavigation.method_6331(true);
        return birdNavigation;
    }

    public boolean method_6481(class_1799 stack) {
        return stack.method_31573(class_3489.field_20344);
    }

    boolean isFlowers(class_2338 pos) {
        return this.method_37908().method_8477(pos) && this.method_37908().method_8320(pos).method_26164(class_3481.field_20339);
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
    }

    protected class_3414 method_5994() {
        return null;
    }

    protected class_3414 method_6011(class_1282 source) {
        return class_3417.field_20603;
    }

    protected class_3414 method_6002() {
        return class_3417.field_20602;
    }

    protected float method_6107() {
        return 0.4f;
    }

    @Nullable
    public CreeperBeeEntity createChild(class_3218 serverWorld, class_1296 passiveEntity) {
        return (CreeperBeeEntity)ModEntities.CREEPER_BEE.method_5883((class_1937)serverWorld);
    }

    protected float method_18394(class_4050 pose, class_4048 dimensions) {
        if (this.method_6109()) {
            return dimensions.field_18068 * 0.5f;
        }
        return dimensions.field_18068 * 0.5f;
    }

    protected void method_5623(double heightDifference, boolean onGround, class_2680 state, class_2338 landedPosition) {
    }

    public boolean method_5776() {
        return this.method_6581() && this.field_6012 % field_28638 == 0;
    }

    public boolean method_6581() {
        return true;
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (this.method_5679(source)) {
            return false;
        }
        return super.method_5643(source, amount);
    }

    public class_1310 method_6046() {
        return class_1310.field_6293;
    }

    protected void method_6010(class_6862<class_3611> fluid) {
        this.method_18799(this.method_18798().method_1031(0.0, 0.01, 0.0));
    }

    public class_243 method_29919() {
        return new class_243(0.0, (double)(0.5f * this.method_5751()), (double)(this.method_17681() * 0.2f));
    }

    boolean isWithinDistance(class_2338 pos, int distance) {
        return pos.method_19771((class_2382)this.method_24515(), (double)distance);
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        if (this.hasFlower()) {
            nbt.method_10566(FLOWER_POS_KEY, (class_2520)class_2512.method_10692((class_2338)this.getFlowerPos()));
        }
        if (((Boolean)this.field_6011.method_12789(CHARGED)).booleanValue()) {
            nbt.method_10556("powered", true);
        }
        nbt.method_10575("Fuse", (short)this.fuseTime);
        nbt.method_10567("ExplosionRadius", (byte)this.explosionRadius);
        nbt.method_10556("ignited", this.isIgnited());
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.flowerPos = null;
        if (nbt.method_10545(FLOWER_POS_KEY)) {
            this.flowerPos = class_2512.method_10691((class_2487)nbt.method_10562(FLOWER_POS_KEY));
        }
        this.field_6011.method_12778(CHARGED, (Object)nbt.method_10577("powered"));
        if (nbt.method_10573("Fuse", 99)) {
            this.fuseTime = nbt.method_10568("Fuse");
        }
        if (nbt.method_10573("ExplosionRadius", 99)) {
            this.explosionRadius = nbt.method_10571("ExplosionRadius");
        }
        if (nbt.method_10577("ignited")) {
            this.ignite();
        }
    }

    public void method_5773() {
        if (this.method_5805()) {
            int i;
            this.lastFuseTime = this.currentFuseTime;
            if (this.isIgnited()) {
                this.setFuseSpeed(1);
            }
            if ((i = this.getFuseSpeed()) > 0 && this.currentFuseTime == 0) {
                this.method_5783(class_3417.field_15057, 1.0f, 0.5f);
                this.method_32876(class_5712.field_28727);
            }
            this.currentFuseTime += i;
            if (this.currentFuseTime < 0) {
                this.currentFuseTime = 0;
            }
            if (this.currentFuseTime >= this.fuseTime) {
                this.currentFuseTime = this.fuseTime;
                this.explode();
            }
        }
        super.method_5773();
    }

    public float getClientFuseTime(float timeDelta) {
        return class_3532.method_16439((float)timeDelta, (float)this.lastFuseTime, (float)this.currentFuseTime) / (float)(this.fuseTime - 2);
    }

    public int getFuseSpeed() {
        return (Integer)this.field_6011.method_12789(FUSE_SPEED);
    }

    public void setFuseSpeed(int fuseSpeed) {
        this.field_6011.method_12778(FUSE_SPEED, (Object)fuseSpeed);
    }

    public void method_5980(@Nullable class_1309 target) {
        if (target instanceof class_6053) {
            return;
        }
        super.method_5980(target);
    }

    public boolean method_6121(class_1297 target) {
        return true;
    }

    public int method_5850() {
        if (this.method_5968() == null) {
            return 3;
        }
        return 3 + (int)(this.method_6032() - 1.0f);
    }

    public boolean method_5747(float fallDistance, float damageMultiplier, class_1282 damageSource) {
        boolean bl = super.method_5747(fallDistance, damageMultiplier, damageSource);
        this.currentFuseTime += (int)(fallDistance * 1.5f);
        if (this.currentFuseTime > this.fuseTime - 5) {
            this.currentFuseTime = this.fuseTime - 5;
        }
        return bl;
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(FUSE_SPEED, (Object)-1);
        this.field_6011.method_12784(CHARGED, (Object)false);
        this.field_6011.method_12784(IGNITED, (Object)false);
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        if (itemStack.method_31573(class_3489.field_41662)) {
            class_3414 soundEvent = itemStack.method_31574(class_1802.field_8814) ? class_3417.field_15013 : class_3417.field_15145;
            this.method_37908().method_43128(player, this.method_23317(), this.method_23318(), this.method_23321(), soundEvent, this.method_5634(), 1.0f, this.field_5974.method_43057() * 0.4f + 0.8f);
            if (!this.method_37908().field_9236) {
                this.ignite();
                if (!itemStack.method_7963()) {
                    itemStack.method_7934(1);
                } else {
                    itemStack.method_7956(1, (class_1309)player, playerx -> playerx.method_20236(hand));
                }
            }
            return class_1269.method_29236((boolean)this.method_37908().field_9236);
        }
        return super.method_5992(player, hand);
    }

    private void explode() {
        if (!this.method_37908().field_9236) {
            float f = this.shouldRenderOverlay() ? 2.0f : 1.0f;
            this.field_6272 = true;
            this.method_37908().method_8437((class_1297)this, this.method_23317(), this.method_23318(), this.method_23321(), (float)this.explosionRadius * f, class_1937.class_7867.field_40890);
            this.method_31472();
            this.spawnEffectsCloud();
        }
    }

    private void spawnEffectsCloud() {
        Collection collection = this.method_6026();
        if (!collection.isEmpty()) {
            class_1295 areaEffectCloudEntity = new class_1295(this.method_37908(), this.method_23317(), this.method_23318(), this.method_23321());
            areaEffectCloudEntity.method_5603(2.5f);
            areaEffectCloudEntity.method_5609(-0.5f);
            areaEffectCloudEntity.method_5595(10);
            areaEffectCloudEntity.method_5604(areaEffectCloudEntity.method_5605() / 2);
            areaEffectCloudEntity.method_5596(-areaEffectCloudEntity.method_5599() / (float)areaEffectCloudEntity.method_5605());
            for (class_1293 statusEffectInstance : collection) {
                areaEffectCloudEntity.method_5610(new class_1293(statusEffectInstance));
            }
            this.method_37908().method_8649((class_1297)areaEffectCloudEntity);
        }
    }

    public boolean isIgnited() {
        return (Boolean)this.field_6011.method_12789(IGNITED);
    }

    public void ignite() {
        this.field_6011.method_12778(IGNITED, (Object)true);
    }

    public boolean shouldRenderOverlay() {
        return false;
    }

    public class CreeperIgniteGoal
    extends class_1352 {
        private final CreeperBeeEntity creeper;
        @Nullable
        private class_1309 target;

        public CreeperIgniteGoal(CreeperBeeEntity creeper) {
            this.creeper = creeper;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            class_1309 livingEntity = this.creeper.method_5968();
            return this.creeper.getFuseSpeed() > 0 || livingEntity != null && this.creeper.method_5858((class_1297)livingEntity) < 9.0;
        }

        public void method_6269() {
            this.creeper.method_5942().method_6340();
            this.target = this.creeper.method_5968();
        }

        public void method_6270() {
            this.target = null;
        }

        public boolean method_38846() {
            return true;
        }

        public void method_6268() {
            if (this.target == null) {
                this.creeper.setFuseSpeed(-1);
                return;
            }
            if (this.creeper.method_5858((class_1297)this.target) > 49.0) {
                this.creeper.setFuseSpeed(-1);
                return;
            }
            if (!this.creeper.method_5985().method_6369((class_1297)this.target)) {
                this.creeper.setFuseSpeed(-1);
                return;
            }
            this.creeper.setFuseSpeed(1);
        }
    }

    public class MoveToFlowerGoal
    extends NotAngryGoal {
        private static final int MAX_FLOWER_NAVIGATION_TICKS = 600;
        int ticks;

        MoveToFlowerGoal() {
            this.ticks = CreeperBeeEntity.this.method_37908().field_9229.method_43048(10);
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        @Override
        public boolean canBeeStart() {
            return CreeperBeeEntity.this.flowerPos != null && !CreeperBeeEntity.this.method_18410() && this.shouldMoveToFlower() && CreeperBeeEntity.this.isFlowers(CreeperBeeEntity.this.flowerPos) && !CreeperBeeEntity.this.isWithinDistance(CreeperBeeEntity.this.flowerPos, 2);
        }

        @Override
        public boolean canBeeContinue() {
            return this.canBeeStart();
        }

        public void method_6269() {
            this.ticks = 0;
            super.method_6269();
        }

        public void method_6270() {
            this.ticks = 0;
            CreeperBeeEntity.this.field_6189.method_6340();
            CreeperBeeEntity.this.field_6189.method_23965();
        }

        public void method_6268() {
            if (CreeperBeeEntity.this.flowerPos == null) {
                return;
            }
            ++this.ticks;
            if (this.ticks > this.method_38847(600)) {
                CreeperBeeEntity.this.flowerPos = null;
                return;
            }
            if (CreeperBeeEntity.this.field_6189.method_23966()) {
                return;
            }
            if (CreeperBeeEntity.this.isTooFar(CreeperBeeEntity.this.flowerPos)) {
                CreeperBeeEntity.this.flowerPos = null;
                return;
            }
            CreeperBeeEntity.this.startMovingTo(CreeperBeeEntity.this.flowerPos);
        }

        private boolean shouldMoveToFlower() {
            return true;
        }
    }

    class BeeWanderAroundGoal
    extends class_1352 {
        private static final int MAX_DISTANCE = 22;

        BeeWanderAroundGoal() {
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            return CreeperBeeEntity.this.field_6189.method_6357() && CreeperBeeEntity.this.field_5974.method_43048(10) == 0;
        }

        public boolean method_6266() {
            return CreeperBeeEntity.this.field_6189.method_23966();
        }

        public void method_6269() {
            class_243 vec3d = this.getRandomLocation();
            if (vec3d != null) {
                CreeperBeeEntity.this.field_6189.method_6334(CreeperBeeEntity.this.field_6189.method_6348(class_2338.method_49638((class_2374)vec3d), 1), 1.0);
            }
        }

        @Nullable
        private class_243 getRandomLocation() {
            class_243 vec3d2 = CreeperBeeEntity.this.method_5828(0.0f);
            int i = 8;
            class_243 vec3d3 = class_5533.method_31524((class_1314)CreeperBeeEntity.this, (int)8, (int)7, (double)vec3d2.field_1352, (double)vec3d2.field_1350, (float)1.5707964f, (int)3, (int)1);
            if (vec3d3 != null) {
                return vec3d3;
            }
            return class_5530.method_31504((class_1314)CreeperBeeEntity.this, (int)8, (int)4, (int)-2, (double)vec3d2.field_1352, (double)vec3d2.field_1350, (double)1.5707963705062866);
        }
    }

    abstract class NotAngryGoal
    extends class_1352 {
        NotAngryGoal() {
        }

        public abstract boolean canBeeStart();

        public abstract boolean canBeeContinue();

        public boolean method_6264() {
            return this.canBeeStart();
        }

        public boolean method_6266() {
            return this.canBeeContinue();
        }
    }
}

