/*
 * Decompiled with CFR 0.152.
 */
package net.almer.avm_mod.entity.custom;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.almer.avm_mod.entity.LivingBlocks;
import net.almer.avm_mod.entity.ModEntities;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1303;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1321;
import net.minecraft.class_1347;
import net.minecraft.class_1350;
import net.minecraft.class_1352;
import net.minecraft.class_1376;
import net.minecraft.class_1386;
import net.minecraft.class_1394;
import net.minecraft.class_155;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1863;
import net.minecraft.class_1874;
import net.minecraft.class_1890;
import net.minecraft.class_1924;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2609;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3489;
import net.minecraft.class_3532;
import net.minecraft.class_3858;
import net.minecraft.class_3913;
import net.minecraft.class_3956;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5455;
import net.minecraft.class_5712;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_8786;
import org.jetbrains.annotations.Nullable;

public class LivingFurnaceEntity
extends class_1321
implements LivingBlocks {
    List playerList;
    double distance = 5.0;
    @Nullable
    private class_2960 lootTableId;
    private long lootSeed;
    protected class_1277 items;
    protected static final int INPUT_SLOT_INDEX = 0;
    protected static final int FUEL_SLOT_INDEX = 1;
    protected static final int OUTPUT_SLOT_INDEX = 2;
    public static final int BURN_TIME_PROPERTY_INDEX = 0;
    private static final int[] TOP_SLOTS = new int[]{0};
    private static final int[] BOTTOM_SLOTS = new int[]{2, 1};
    private static final int[] SIDE_SLOTS = new int[]{1};
    public static final int FUEL_TIME_PROPERTY_INDEX = 1;
    public static final int COOK_TIME_PROPERTY_INDEX = 2;
    public static final int COOK_TIME_TOTAL_PROPERTY_INDEX = 3;
    public static final int PROPERTY_COUNT = 4;
    public static final int DEFAULT_COOK_TIME = 200;
    public static final int field_31295 = 2;
    protected class_2371<class_1799> inventory = class_2371.method_10213((int)3, (Object)class_1799.field_8037);
    int burnTime;
    int fuelTime;
    int cookTime;
    int cookTimeTotal;
    private final Object2IntOpenHashMap<class_2960> recipesUsed = new Object2IntOpenHashMap();
    private final class_1863.class_7266<class_1263, ? extends class_1874> matchGetter;
    private final class_1937 world;
    protected final class_3913 propertyDelegate = new class_3913(){

        public int method_17390(int index) {
            switch (index) {
                case 0: {
                    return LivingFurnaceEntity.this.burnTime;
                }
                case 1: {
                    return LivingFurnaceEntity.this.fuelTime;
                }
                case 2: {
                    return LivingFurnaceEntity.this.cookTime;
                }
                case 3: {
                    return LivingFurnaceEntity.this.cookTimeTotal;
                }
            }
            return 0;
        }

        public void method_17391(int index, int value) {
            switch (index) {
                case 0: {
                    LivingFurnaceEntity.this.burnTime = value;
                    break;
                }
                case 1: {
                    LivingFurnaceEntity.this.fuelTime = value;
                    break;
                }
                case 2: {
                    LivingFurnaceEntity.this.cookTime = value;
                    break;
                }
                case 3: {
                    LivingFurnaceEntity.this.cookTimeTotal = value;
                }
            }
        }

        public int method_17389() {
            return 4;
        }
    };

    public LivingFurnaceEntity(class_1299<? extends class_1321> entityType, class_1937 world) {
        super(entityType, world);
        this.matchGetter = class_1863.method_42302((class_3956)class_3956.field_17546);
        this.world = world;
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new class_1386((class_1321)this));
        this.field_6201.method_6277(2, (class_1352)new class_1350((class_1321)this, 0.7, 2.0f, 40.0f, true));
        this.field_6201.method_6277(3, (class_1352)new class_1394((class_1314)this, 0.5));
        this.field_6201.method_6277(4, (class_1352)new class_1376((class_1308)this));
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 15.0).method_26868(class_5134.field_23719, 0.5);
    }

    public class_1924 method_48926() {
        return this.method_37908();
    }

    @Override
    public class_1937 method_37908() {
        return this.world;
    }

    @Nullable
    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        return (class_1296)ModEntities.LIVING_FURNACE.method_5883((class_1937)world);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        if (player.method_5715()) {
            if (this.method_6181()) {
                if (!this.method_6171((class_1309)player)) return super.method_5992(player, hand);
                if (this.method_24345()) {
                    this.method_24346(false);
                    return class_1269.field_5812;
                }
                this.method_24346(true);
                this.field_6282 = false;
                this.field_6189.method_6340();
                return class_1269.field_5812;
            }
            this.method_6170(player);
            return class_1269.field_5812;
        }
        class_1269 actionResult = this.open(player);
        if (!actionResult.method_23665()) return actionResult;
        this.method_32875(class_5712.field_28725, (class_1297)player);
        return actionResult;
    }

    @Override
    @Nullable
    public class_2960 method_5991() {
        return this.lootTableId;
    }

    @Override
    public void setLootTableId(@Nullable class_2960 lootTableId) {
        this.lootTableId = lootTableId;
    }

    @Override
    public void setLootTableSeed(long lootTableSeed) {
        this.lootSeed = lootTableSeed;
    }

    @Override
    public class_2371<class_1799> getInventory() {
        return this.inventory;
    }

    @Override
    public void resetInventory() {
        this.inventory = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
    }

    public int method_5439() {
        return 4;
    }

    public static Map<class_1792, Integer> createFuelTimeMap() {
        LinkedHashMap map = Maps.newLinkedHashMap();
        LivingFurnaceEntity.addFuel((Map<class_1792, Integer>)map, (class_1935)class_1802.field_8187, 20000);
        LivingFurnaceEntity.addFuel((Map<class_1792, Integer>)map, (class_1935)class_2246.field_10381, 16000);
        LivingFurnaceEntity.addFuel((Map<class_1792, Integer>)map, (class_1935)class_1802.field_8894, 2400);
        LivingFurnaceEntity.addFuel((Map<class_1792, Integer>)map, (class_1935)class_1802.field_8713, 1600);
        LivingFurnaceEntity.addFuel((Map<class_1792, Integer>)map, (class_1935)class_1802.field_8665, 1600);
        LivingFurnaceEntity.addFuel((Map<class_1792, Integer>)map, (class_6862<class_1792>)class_3489.field_15539, 300);
        LivingFurnaceEntity.addFuel((Map<class_1792, Integer>)map, (class_6862<class_1792>)class_3489.field_40987, 300);
        LivingFurnaceEntity.addFuel((Map<class_1792, Integer>)map, (class_6862<class_1792>)class_3489.field_15537, 300);
        LivingFurnaceEntity.addFuel((Map<class_1792, Integer>)map, (class_1935)class_2246.field_40295, 300);
        LivingFurnaceEntity.addFuel((Map<class_1792, Integer>)map, (class_6862<class_1792>)class_3489.field_15557, 300);
        LivingFurnaceEntity.addFuel((Map<class_1792, Integer>)map, (class_1935)class_2246.field_40288, 300);
        LivingFurnaceEntity.addFuel((Map<class_1792, Integer>)map, (class_6862<class_1792>)class_3489.field_15534, 150);
        LivingFurnaceEntity.addFuel((Map<class_1792, Integer>)map, (class_1935)class_2246.field_40293, 150);
        LivingFurnaceEntity.addFuel((Map<class_1792, Integer>)map, (class_6862<class_1792>)class_3489.field_15550, 300);
        LivingFurnaceEntity.addFuel((Map<class_1792, Integer>)map, (class_6862<class_1792>)class_3489.field_15540, 300);
        LivingFurnaceEntity.addFuel((Map<class_1792, Integer>)map, (class_6862<class_1792>)class_3489.field_17620, 300);
        LivingFurnaceEntity.addFuel((Map<class_1792, Integer>)map, (class_6862<class_1792>)class_3489.field_40858, 300);
        LivingFurnaceEntity.addFuel((Map<class_1792, Integer>)map, (class_1935)class_2246.field_10179, 300);
        LivingFurnaceEntity.addFuel((Map<class_1792, Integer>)map, (class_1935)class_2246.field_10504, 300);
        LivingFurnaceEntity.addFuel((Map<class_1792, Integer>)map, (class_1935)class_2246.field_40276, 300);
        LivingFurnaceEntity.addFuel((Map<class_1792, Integer>)map, (class_1935)class_2246.field_16330, 300);
        LivingFurnaceEntity.addFuel((Map<class_1792, Integer>)map, (class_1935)class_2246.field_10223, 300);
        LivingFurnaceEntity.addFuel((Map<class_1792, Integer>)map, (class_1935)class_2246.field_10034, 300);
        LivingFurnaceEntity.addFuel((Map<class_1792, Integer>)map, (class_1935)class_2246.field_10380, 300);
        LivingFurnaceEntity.addFuel((Map<class_1792, Integer>)map, (class_1935)class_2246.field_9980, 300);
        LivingFurnaceEntity.addFuel((Map<class_1792, Integer>)map, (class_1935)class_2246.field_10429, 300);
        LivingFurnaceEntity.addFuel((Map<class_1792, Integer>)map, (class_6862<class_1792>)class_3489.field_15556, 300);
        LivingFurnaceEntity.addFuel((Map<class_1792, Integer>)map, (class_1935)class_1802.field_8102, 300);
        LivingFurnaceEntity.addFuel((Map<class_1792, Integer>)map, (class_1935)class_1802.field_8378, 300);
        LivingFurnaceEntity.addFuel((Map<class_1792, Integer>)map, (class_1935)class_2246.field_9983, 300);
        LivingFurnaceEntity.addFuel((Map<class_1792, Integer>)map, (class_6862<class_1792>)class_3489.field_15533, 200);
        LivingFurnaceEntity.addFuel((Map<class_1792, Integer>)map, (class_6862<class_1792>)class_3489.field_40108, 800);
        LivingFurnaceEntity.addFuel((Map<class_1792, Integer>)map, (class_1935)class_1802.field_8876, 200);
        LivingFurnaceEntity.addFuel((Map<class_1792, Integer>)map, (class_1935)class_1802.field_8091, 200);
        LivingFurnaceEntity.addFuel((Map<class_1792, Integer>)map, (class_1935)class_1802.field_8167, 200);
        LivingFurnaceEntity.addFuel((Map<class_1792, Integer>)map, (class_1935)class_1802.field_8406, 200);
        LivingFurnaceEntity.addFuel((Map<class_1792, Integer>)map, (class_1935)class_1802.field_8647, 200);
        LivingFurnaceEntity.addFuel((Map<class_1792, Integer>)map, (class_6862<class_1792>)class_3489.field_15552, 200);
        LivingFurnaceEntity.addFuel((Map<class_1792, Integer>)map, (class_6862<class_1792>)class_3489.field_15536, 1200);
        LivingFurnaceEntity.addFuel((Map<class_1792, Integer>)map, (class_6862<class_1792>)class_3489.field_15544, 100);
        LivingFurnaceEntity.addFuel((Map<class_1792, Integer>)map, (class_6862<class_1792>)class_3489.field_15555, 100);
        LivingFurnaceEntity.addFuel((Map<class_1792, Integer>)map, (class_1935)class_1802.field_8600, 100);
        LivingFurnaceEntity.addFuel((Map<class_1792, Integer>)map, (class_6862<class_1792>)class_3489.field_15528, 100);
        LivingFurnaceEntity.addFuel((Map<class_1792, Integer>)map, (class_1935)class_1802.field_8428, 100);
        LivingFurnaceEntity.addFuel((Map<class_1792, Integer>)map, (class_6862<class_1792>)class_3489.field_15542, 67);
        LivingFurnaceEntity.addFuel((Map<class_1792, Integer>)map, (class_1935)class_2246.field_10342, 4001);
        LivingFurnaceEntity.addFuel((Map<class_1792, Integer>)map, (class_1935)class_1802.field_8399, 300);
        LivingFurnaceEntity.addFuel((Map<class_1792, Integer>)map, (class_1935)class_2246.field_10211, 50);
        LivingFurnaceEntity.addFuel((Map<class_1792, Integer>)map, (class_1935)class_2246.field_10428, 100);
        LivingFurnaceEntity.addFuel((Map<class_1792, Integer>)map, (class_1935)class_2246.field_16492, 50);
        LivingFurnaceEntity.addFuel((Map<class_1792, Integer>)map, (class_1935)class_2246.field_10083, 300);
        LivingFurnaceEntity.addFuel((Map<class_1792, Integer>)map, (class_1935)class_2246.field_16328, 300);
        LivingFurnaceEntity.addFuel((Map<class_1792, Integer>)map, (class_1935)class_2246.field_16336, 300);
        LivingFurnaceEntity.addFuel((Map<class_1792, Integer>)map, (class_1935)class_2246.field_16331, 300);
        LivingFurnaceEntity.addFuel((Map<class_1792, Integer>)map, (class_1935)class_2246.field_16329, 300);
        LivingFurnaceEntity.addFuel((Map<class_1792, Integer>)map, (class_1935)class_2246.field_17563, 300);
        LivingFurnaceEntity.addFuel((Map<class_1792, Integer>)map, (class_1935)class_2246.field_28678, 100);
        LivingFurnaceEntity.addFuel((Map<class_1792, Integer>)map, (class_1935)class_2246.field_28679, 100);
        LivingFurnaceEntity.addFuel((Map<class_1792, Integer>)map, (class_1935)class_2246.field_37546, 300);
        return map;
    }

    private static boolean isNonFlammableWood(class_1792 item) {
        return item.method_40131().method_40220(class_3489.field_23211);
    }

    private static void addFuel(Map<class_1792, Integer> fuelTimes, class_6862<class_1792> tag, int fuelTime) {
        for (class_6880 registryEntry : class_7923.field_41178.method_40286(tag)) {
            if (LivingFurnaceEntity.isNonFlammableWood((class_1792)registryEntry.comp_349())) continue;
            fuelTimes.put((class_1792)registryEntry.comp_349(), fuelTime);
        }
    }

    private static void addFuel(Map<class_1792, Integer> fuelTimes, class_1935 item, int fuelTime) {
        class_1792 item2 = item.method_8389();
        if (LivingFurnaceEntity.isNonFlammableWood(item2)) {
            if (class_155.field_1125) {
                throw (IllegalStateException)class_156.method_22320((Throwable)new IllegalStateException("A developer tried to explicitly make fire resistant item " + item2.method_7864(null).getString() + " a furnace fuel. That will not work!"));
            }
            return;
        }
        fuelTimes.put(item2, fuelTime);
    }

    private boolean isBurning() {
        return this.burnTime > 0;
    }

    public class_1799 method_5438(int slot) {
        if (slot >= 0 && slot < this.inventory.size()) {
            return (class_1799)this.inventory.get(slot);
        }
        return class_1799.field_8037;
    }

    public class_1799 method_5434(int slot, int amount) {
        return class_1262.method_5430(this.inventory, (int)slot, (int)amount);
    }

    public class_1799 method_5441(int slot) {
        return class_1262.method_5428(this.inventory, (int)slot);
    }

    public void method_5431() {
    }

    public boolean method_5443(class_1657 player) {
        return true;
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        if (this.lootTableId == null || !player.method_7325()) {
            this.generateInventoryLoot(playerInventory.field_7546);
            return this.createScreenHandler(syncId, playerInventory);
        }
        return null;
    }

    public void method_5448() {
        this.clearInventory();
    }

    public void method_5432(class_1657 player) {
        this.method_37908().method_32888(class_5712.field_28177, this.method_19538(), class_5712.class_7397.method_43285((class_1297)player));
    }

    protected void method_16078() {
        super.method_16078();
        if (this.inventory == null) {
            return;
        }
        for (int i = 0; i < this.inventory.size(); ++i) {
            class_1799 itemStack = (class_1799)this.inventory.get(i);
            if (itemStack.method_7960() || class_1890.method_8221((class_1799)itemStack)) continue;
            this.method_5775(itemStack);
        }
        if (!this.method_37908().field_9236) {
            this.method_5706((class_1935)class_2246.field_10181);
        }
    }

    public void method_5773() {
        class_1937 world = this.method_37908();
        boolean bl = this.isBurning();
        boolean bl2 = false;
        if (this.isBurning()) {
            --this.burnTime;
        }
        class_1799 itemStack = (class_1799)this.inventory.get(1);
        boolean bl3 = !((class_1799)this.inventory.get(0)).method_7960();
        boolean bl4 = !itemStack.method_7960();
        boolean bl5 = bl4;
        if (this.isBurning() || bl4 && bl3) {
            class_8786 recipe = bl3 ? (class_8786)this.matchGetter.method_42303((class_1263)this, world).orElse(null) : null;
            int i = this.method_5444();
            if (!this.isBurning() && LivingFurnaceEntity.canAcceptRecipeOutput(world.method_30349(), recipe, this.inventory, i)) {
                this.fuelTime = this.burnTime = this.getFuelTime(itemStack);
                if (this.isBurning()) {
                    bl2 = true;
                    if (bl4) {
                        class_1792 item = itemStack.method_7909();
                        itemStack.method_7934(1);
                        if (itemStack.method_7960()) {
                            class_1792 item2 = item.method_7858();
                            this.inventory.set(1, (Object)(item2 == null ? class_1799.field_8037 : new class_1799((class_1935)item2)));
                        }
                    }
                }
            }
            if (this.isBurning() && LivingFurnaceEntity.canAcceptRecipeOutput(world.method_30349(), recipe, this.inventory, i)) {
                ++this.cookTime;
                if (this.cookTime == this.cookTimeTotal) {
                    this.cookTime = 0;
                    this.cookTimeTotal = LivingFurnaceEntity.getCookTime(world, this);
                    if (LivingFurnaceEntity.craftRecipe(world.method_30349(), recipe, this.inventory, i)) {
                        this.setLastRecipe(recipe);
                    }
                    bl2 = true;
                }
            } else {
                this.cookTime = 0;
            }
        } else if (!this.isBurning() && this.cookTime > 0) {
            this.cookTime = class_3532.method_15340((int)(this.cookTime - 2), (int)0, (int)this.cookTimeTotal);
        }
        super.method_5773();
    }

    private static boolean canAcceptRecipeOutput(class_5455 registryManager, @Nullable class_8786<?> recipe, class_2371<class_1799> slots, int count) {
        if (!((class_1799)slots.get(0)).method_7960() && recipe != null) {
            class_1799 itemStack = recipe.comp_1933().method_8110(registryManager);
            if (itemStack.method_7960()) {
                return false;
            }
            class_1799 itemStack2 = (class_1799)slots.get(2);
            if (itemStack2.method_7960()) {
                return true;
            }
            if (!class_1799.method_7984((class_1799)itemStack2, (class_1799)itemStack)) {
                return false;
            }
            if (itemStack2.method_7947() < count && itemStack2.method_7947() < itemStack2.method_7914()) {
                return true;
            }
            return itemStack2.method_7947() < itemStack.method_7914();
        }
        return false;
    }

    private static boolean craftRecipe(class_5455 registryManager, @Nullable class_8786<?> recipe, class_2371<class_1799> slots, int count) {
        if (recipe != null && LivingFurnaceEntity.canAcceptRecipeOutput(registryManager, recipe, slots, count)) {
            class_1799 itemStack = (class_1799)slots.get(0);
            class_1799 itemStack2 = recipe.comp_1933().method_8110(registryManager);
            class_1799 itemStack3 = (class_1799)slots.get(2);
            if (itemStack3.method_7960()) {
                slots.set(2, (Object)itemStack2.method_7972());
            } else if (itemStack3.method_31574(itemStack2.method_7909())) {
                itemStack3.method_7933(1);
            }
            if (itemStack.method_31574(class_2246.field_10562.method_8389()) && !((class_1799)slots.get(1)).method_7960() && ((class_1799)slots.get(1)).method_31574(class_1802.field_8550)) {
                slots.set(1, (Object)new class_1799((class_1935)class_1802.field_8705));
            }
            itemStack.method_7934(1);
            return true;
        }
        return false;
    }

    protected int getFuelTime(class_1799 fuel) {
        if (fuel.method_7960()) {
            return 0;
        }
        class_1792 item = fuel.method_7909();
        return class_2609.method_11196().getOrDefault(item, 0);
    }

    private static int getCookTime(class_1937 world, LivingFurnaceEntity furnace) {
        return furnace.matchGetter.method_42303((class_1263)furnace, world).map(recipe -> ((class_1874)recipe.comp_1933()).method_8167()).orElse(200);
    }

    public static boolean canUseAsFuel(class_1799 stack) {
        return class_2609.method_11196().containsKey(stack.method_7909());
    }

    public void setLastRecipe(@Nullable class_8786<?> recipe) {
        if (recipe != null) {
            class_2960 identifier = recipe.comp_1932();
            this.recipesUsed.addTo((Object)identifier, 1);
        }
    }

    public void dropExperienceForRecipesUsed(class_3222 player) {
        List<class_8786<?>> list = this.getRecipesUsedAndDropExperience(player.method_51469(), player.method_19538());
        player.method_7254(list);
        for (class_8786<?> recipeEntry : list) {
            if (recipeEntry == null) continue;
            player.method_51283(recipeEntry, this.inventory);
        }
        this.recipesUsed.clear();
    }

    public List<class_8786<?>> getRecipesUsedAndDropExperience(class_3218 world, class_243 pos) {
        ArrayList list = Lists.newArrayList();
        for (Object2IntMap.Entry entry : this.recipesUsed.object2IntEntrySet()) {
            world.method_8433().method_8130((class_2960)entry.getKey()).ifPresent(recipe -> {
                list.add(recipe);
                LivingFurnaceEntity.dropExperience(world, pos, entry.getIntValue(), ((class_1874)recipe.comp_1933()).method_8171());
            });
        }
        return list;
    }

    private static void dropExperience(class_3218 world, class_243 pos, int multiplier, float experience) {
        int i = class_3532.method_15375((float)((float)multiplier * experience));
        float f = class_3532.method_22450((float)((float)multiplier * experience));
        if (f != 0.0f && Math.random() < (double)f) {
            ++i;
        }
        class_1303.method_31493((class_3218)world, (class_243)pos, (int)i);
    }

    protected class_1703 createScreenHandler(int syncId, class_1661 playerInventory) {
        return new class_3858(syncId, playerInventory, (class_1263)this, this.propertyDelegate);
    }

    public void method_5447(int slot, class_1799 stack) {
        class_1799 itemStack = (class_1799)this.inventory.get(slot);
        boolean bl = !stack.method_7960() && class_1799.method_31577((class_1799)itemStack, (class_1799)stack);
        this.inventory.set(slot, (Object)stack);
        if (stack.method_7947() > this.method_5444()) {
            stack.method_7939(this.method_5444());
        }
        if (slot == 0 && !bl) {
            this.cookTimeTotal = LivingFurnaceEntity.getCookTime(this.method_37908(), this);
            this.cookTime = 0;
            this.method_5431();
        }
    }
}

