/*
 * Decompiled with CFR 0.152.
 */
package net.almer.avm_mod.entity.custom.dark;

import java.util.Collection;
import java.util.EnumSet;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1295;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1321;
import net.minecraft.class_1338;
import net.minecraft.class_1347;
import net.minecraft.class_1350;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1403;
import net.minecraft.class_1406;
import net.minecraft.class_1451;
import net.minecraft.class_1538;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1924;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3489;
import net.minecraft.class_3532;
import net.minecraft.class_3701;
import net.minecraft.class_4582;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5712;
import net.minecraft.class_6053;
import org.jetbrains.annotations.Nullable;

public class DarkCreeperEntity
extends class_1321
implements class_4582 {
    private static final class_2940<Integer> FUSE_SPEED = class_2945.method_12791(DarkCreeperEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> CHARGED = class_2945.method_12791(DarkCreeperEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> IGNITED = class_2945.method_12791(DarkCreeperEntity.class, (class_2941)class_2943.field_13323);
    private int lastFuseTime;
    private int currentFuseTime;
    private int fuseTime = 30;
    private int explosionRadius = 3;
    private int headsDropped;

    public DarkCreeperEntity(class_1299<? extends DarkCreeperEntity> entityType, class_1937 world) {
        super(entityType, world);
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(2, (class_1352)new ModCreeperIgnite(this));
        this.field_6201.method_6277(3, (class_1352)new class_1338((class_1314)this, class_3701.class, 6.0f, 1.0, 1.2));
        this.field_6201.method_6277(3, (class_1352)new class_1338((class_1314)this, class_1451.class, 6.0f, 1.0, 1.2));
        this.field_6201.method_6277(4, (class_1352)new class_1366((class_1314)this, 1.0, false));
        this.field_6201.method_6277(4, (class_1352)new class_1350((class_1321)this, 1.0, 10.0f, 2.0f, false));
        this.field_6201.method_6277(5, (class_1352)new class_1394((class_1314)this, 0.8));
        this.field_6201.method_6277(6, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(6, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new class_1403((class_1321)this));
        this.field_6185.method_6277(2, (class_1352)new class_1406((class_1321)this));
        this.field_6185.method_6277(3, (class_1352)new class_1399((class_1314)this, new Class[0]));
    }

    public static class_5132.class_5133 createCreeperAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23719, 0.25);
    }

    public int method_5850() {
        if (this.method_5968() == null) {
            return 3;
        }
        return 3 + (int)(this.method_6032() - 1.0f);
    }

    public boolean method_5747(float fallDistance, float damageMultiplier, class_1282 damageSource) {
        boolean bl = super.method_5747(fallDistance, damageMultiplier, damageSource);
        this.currentFuseTime += (int)(fallDistance * 1.5f);
        if (this.currentFuseTime > this.fuseTime - 5) {
            this.currentFuseTime = this.fuseTime - 5;
        }
        return bl;
    }

    @Nullable
    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        return null;
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(FUSE_SPEED, (Object)-1);
        this.field_6011.method_12784(CHARGED, (Object)false);
        this.field_6011.method_12784(IGNITED, (Object)false);
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        if (((Boolean)this.field_6011.method_12789(CHARGED)).booleanValue()) {
            nbt.method_10556("powered", true);
        }
        nbt.method_10575("Fuse", (short)this.fuseTime);
        nbt.method_10567("ExplosionRadius", (byte)this.explosionRadius);
        nbt.method_10556("ignited", this.isIgnited());
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.field_6011.method_12778(CHARGED, (Object)nbt.method_10577("powered"));
        if (nbt.method_10573("Fuse", 99)) {
            this.fuseTime = nbt.method_10568("Fuse");
        }
        if (nbt.method_10573("ExplosionRadius", 99)) {
            this.explosionRadius = nbt.method_10571("ExplosionRadius");
        }
        if (nbt.method_10577("ignited")) {
            this.ignite();
        }
    }

    public void method_5773() {
        if (this.method_5805()) {
            int i;
            this.lastFuseTime = this.currentFuseTime;
            if (this.isIgnited()) {
                this.setFuseSpeed(1);
            }
            if ((i = this.getFuseSpeed()) > 0 && this.currentFuseTime == 0) {
                this.method_5783(class_3417.field_15057, 1.0f, 0.5f);
                this.method_32876(class_5712.field_28727);
            }
            this.currentFuseTime += i;
            if (this.currentFuseTime < 0) {
                this.currentFuseTime = 0;
            }
            if (this.currentFuseTime >= this.fuseTime) {
                this.currentFuseTime = this.fuseTime;
                this.explode();
            }
        }
        super.method_5773();
    }

    public void method_5980(@Nullable class_1309 target) {
        if (target instanceof class_6053) {
            return;
        }
        super.method_5980(target);
    }

    protected class_3414 method_6011(class_1282 source) {
        return class_3417.field_15192;
    }

    protected class_3414 method_6002() {
        return class_3417.field_14907;
    }

    public boolean method_6121(class_1297 target) {
        return true;
    }

    public boolean method_6872() {
        return (Boolean)this.field_6011.method_12789(CHARGED);
    }

    public float getClientFuseTime(float timeDelta) {
        return class_3532.method_16439((float)timeDelta, (float)this.lastFuseTime, (float)this.currentFuseTime) / (float)(this.fuseTime - 2);
    }

    public int getFuseSpeed() {
        return (Integer)this.field_6011.method_12789(FUSE_SPEED);
    }

    public void setFuseSpeed(int fuseSpeed) {
        this.field_6011.method_12778(FUSE_SPEED, (Object)fuseSpeed);
    }

    public void method_5800(class_3218 world, class_1538 lightning) {
        super.method_5800(world, lightning);
        this.field_6011.method_12778(CHARGED, (Object)true);
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        if (itemStack.method_31573(class_3489.field_41662)) {
            class_3414 soundEvent = itemStack.method_31574(class_1802.field_8814) ? class_3417.field_15013 : class_3417.field_15145;
            this.method_37908().method_43128(player, this.method_23317(), this.method_23318(), this.method_23321(), soundEvent, this.method_5634(), 1.0f, this.field_5974.method_43057() * 0.4f + 0.8f);
            if (!this.method_37908().field_9236) {
                this.ignite();
                if (!itemStack.method_7963()) {
                    itemStack.method_7934(1);
                } else {
                    itemStack.method_7956(1, (class_1309)player, playerx -> playerx.method_20236(hand));
                }
            }
            return class_1269.method_29236((boolean)this.method_37908().field_9236);
        }
        return super.method_5992(player, hand);
    }

    private void explode() {
        if (!this.method_37908().field_9236) {
            float f = this.method_6872() ? 2.0f : 1.0f;
            this.field_6272 = true;
            this.method_37908().method_8437((class_1297)this, this.method_23317(), this.method_23318(), this.method_23321(), (float)this.explosionRadius * f, class_1937.class_7867.field_40890);
            this.method_31472();
            this.spawnEffectsCloud();
        }
    }

    private void spawnEffectsCloud() {
        Collection collection = this.method_6026();
        if (!collection.isEmpty()) {
            class_1295 areaEffectCloudEntity = new class_1295(this.method_37908(), this.method_23317(), this.method_23318(), this.method_23321());
            areaEffectCloudEntity.method_5603(2.5f);
            areaEffectCloudEntity.method_5609(-0.5f);
            areaEffectCloudEntity.method_5595(10);
            areaEffectCloudEntity.method_5604(areaEffectCloudEntity.method_5605() / 2);
            areaEffectCloudEntity.method_5596(-areaEffectCloudEntity.method_5599() / (float)areaEffectCloudEntity.method_5605());
            for (class_1293 statusEffectInstance : collection) {
                areaEffectCloudEntity.method_5610(new class_1293(statusEffectInstance));
            }
            this.method_37908().method_8649((class_1297)areaEffectCloudEntity);
        }
    }

    public boolean isIgnited() {
        return (Boolean)this.field_6011.method_12789(IGNITED);
    }

    public void ignite() {
        this.field_6011.method_12778(IGNITED, (Object)true);
    }

    public class_1924 method_48926() {
        return this.method_37908();
    }

    class ModCreeperIgnite
    extends class_1352 {
        private final DarkCreeperEntity creeper;
        @Nullable
        private class_1309 target;

        public ModCreeperIgnite(DarkCreeperEntity creeper) {
            this.creeper = creeper;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            class_1309 livingEntity = this.creeper.method_5968();
            return this.creeper.getFuseSpeed() > 0 || livingEntity != null && this.creeper.method_5858((class_1297)livingEntity) < 9.0;
        }

        public void method_6269() {
            this.creeper.method_5942().method_6340();
            this.target = this.creeper.method_5968();
        }

        public void method_6270() {
            this.target = null;
        }

        public boolean method_38846() {
            return true;
        }

        public void method_6268() {
            if (this.target == null) {
                this.creeper.setFuseSpeed(-1);
                return;
            }
            if (this.creeper.method_5858((class_1297)this.target) > 49.0) {
                this.creeper.setFuseSpeed(-1);
                return;
            }
            if (!this.creeper.method_5985().method_6369((class_1297)this.target)) {
                this.creeper.setFuseSpeed(-1);
                return;
            }
            this.creeper.setFuseSpeed(1);
        }
    }
}

