/*
 * Decompiled with CFR 0.152.
 */
package net.almer.avm_mod.item.custom;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Stream;
import net.almer.avm_mod.AvMModClient;
import net.almer.avm_mod.client.screen.PowerfulStaffScreen;
import net.almer.avm_mod.entity.ModEntities;
import net.almer.avm_mod.entity.custom.dark.DarkCreeperEntity;
import net.almer.avm_mod.entity.custom.dark.DarkEndermanEntity;
import net.almer.avm_mod.entity.custom.dark.DarkPhantomEntity;
import net.almer.avm_mod.entity.custom.dark.DarkSkeletonEntity;
import net.almer.avm_mod.entity.custom.dark.DarkSpiderEntity;
import net.almer.avm_mod.entity.custom.dark.DarkZombieEntity;
import net.almer.avm_mod.item.ModItem;
import net.almer.avm_mod.network.packet.AddCommandsC2SPacket;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1321;
import net.minecraft.class_1322;
import net.minecraft.class_1541;
import net.minecraft.class_1548;
import net.minecraft.class_1560;
import net.minecraft.class_1593;
import net.minecraft.class_1613;
import net.minecraft.class_1628;
import net.minecraft.class_1642;
import net.minecraft.class_1657;
import net.minecraft.class_1674;
import net.minecraft.class_1686;
import net.minecraft.class_1735;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1831;
import net.minecraft.class_1832;
import net.minecraft.class_1838;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2222;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2256;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_4538;
import net.minecraft.class_5134;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import net.minecraft.class_5631;
import net.minecraft.class_5632;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_6908;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class PowerfulStaffItem
extends class_1831 {
    public static final String ITEMS_KEY = "Block";
    public static final String BLOCKED_KEY = "Blocked";
    private static final String currentCommandKey = "gui.avm_mod.current_text";
    private static final int zombieIndex = 1;
    private static final int skeletonIndex = 2;
    private static final int creeperIndex = 3;
    private static final int spiderIndex = 4;
    private static final int endermanIndex = 5;
    private static final int phantomIndex = 6;
    private float attackDamage;
    private float attackSpeed;
    private Multimap<class_1320, class_1322> attributeModifiers;
    private class_1799 staff;
    public String currentCommand = "";
    private static int currentMode = 1;
    private ArrayList<String> bufferedCommands;
    private class_2499 commandList;
    private class_2499 entityList;
    private List absorpedEntities;
    private int remains = 10;
    private int index = 0;

    public PowerfulStaffItem(class_1832 toolMaterial, int attackDamage, float attackSpeed, class_1792.class_1793 settings) {
        super(toolMaterial, settings);
        this.attackDamage = attackDamage;
        this.attackSpeed = attackSpeed;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)class_5134.field_23721, (Object)new class_1322(field_8006, "Weapon modifier", (double)this.attackDamage, class_1322.class_1323.field_6328));
        builder.put((Object)class_5134.field_23723, (Object)new class_1322(field_8001, "Weapon modifier", (double)this.attackSpeed, class_1322.class_1323.field_6328));
        this.attributeModifiers = builder.build();
        this.index = 0;
    }

    public static int getCurrentMode() {
        return currentMode;
    }

    public float getAttackDamage() {
        return this.attackDamage;
    }

    public static class_1657 getPlayer() {
        class_746 player = class_310.method_1551().field_1724;
        return player;
    }

    public Multimap<class_1320, class_1322> method_7844(class_1304 slot) {
        if (slot == class_1304.field_6173) {
            return this.attributeModifiers;
        }
        return super.method_7844(slot);
    }

    public boolean method_31565(class_1799 stack, class_1735 slot, class_5536 clickType, class_1657 player) {
        if (clickType != class_5536.field_27014) {
            return false;
        }
        class_1799 itemStack = slot.method_7677();
        if (itemStack.method_7960()) {
            this.playRemoveOneSound((class_1297)player);
            this.removeFirstStack(stack).ifPresent(removedStack -> this.addToBundle(stack, slot.method_32756(removedStack)));
            return true;
        }
        if (itemStack.method_7909().method_31568()) {
            int i = (1 - this.getBundleOccupancy(stack)) / this.getItemOccupancy(itemStack);
            if (itemStack.method_7909() instanceof class_1747 || itemStack.method_31574(ModItem.GAME_ICON)) {
                this.setBlocked(stack, true);
                this.staff = stack;
                int j = this.addToBundle(stack, slot.method_32753(itemStack.method_7947(), i, player));
                if (j > 0) {
                    this.playInsertSound((class_1297)player);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public void setAttackDamage(float attackDamage) {
        this.attackDamage = attackDamage;
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        class_1657 player;
        this.staff = stack;
        this.setAttackDamage(6 + this.muliplicate(stack));
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)class_5134.field_23721, (Object)new class_1322(field_8006, "Weapon modifier", (double)this.attackDamage, class_1322.class_1323.field_6328));
        builder.put((Object)class_5134.field_23723, (Object)new class_1322(field_8001, "Weapon modifier", (double)this.attackSpeed, class_1322.class_1323.field_6328));
        this.attributeModifiers = builder.build();
        if (this.hasBlocks(stack, class_1802.field_8866) && entity.method_31747()) {
            player = (class_1657)entity;
            AddCommandsC2SPacket.getCommands1();
            if (AvMModClient.POWERFUL_STAFF_USE.method_1434() && player.method_7338() && this.commandList != null) {
                if (AvMModClient.POWERFUL_STAFF_USE_1.method_1434()) {
                    this.currentCommand = this.commandList.method_10602(0).method_10558("Command0");
                    player.method_7353((class_2561)class_2561.method_43471((String)currentCommandKey).method_27693(this.currentCommand), true);
                } else if (AvMModClient.POWERFUL_STAFF_USE_2.method_1434()) {
                    this.currentCommand = this.commandList.method_10602(1).method_10558("Command1");
                    player.method_7353((class_2561)class_2561.method_43471((String)currentCommandKey).method_27693(this.currentCommand), true);
                } else if (AvMModClient.POWERFUL_STAFF_USE_3.method_1434()) {
                    this.currentCommand = this.commandList.method_10602(2).method_10558("Command2");
                    player.method_7353((class_2561)class_2561.method_43471((String)currentCommandKey).method_27693(this.currentCommand), true);
                } else if (AvMModClient.POWERFUL_STAFF_USE_4.method_1434()) {
                    this.currentCommand = this.commandList.method_10602(3).method_10558("Command3");
                    player.method_7353((class_2561)class_2561.method_43471((String)currentCommandKey).method_27693(this.currentCommand), true);
                } else if (AvMModClient.POWERFUL_STAFF_USE_5.method_1434()) {
                    this.currentCommand = this.commandList.method_10602(4).method_10558("Command4");
                    player.method_7353((class_2561)class_2561.method_43471((String)currentCommandKey).method_27693(this.currentCommand), true);
                } else if (AvMModClient.POWERFUL_STAFF_USE_6.method_1434()) {
                    this.currentCommand = this.commandList.method_10602(5).method_10558("Command5");
                    player.method_7353((class_2561)class_2561.method_43471((String)currentCommandKey).method_27693(this.currentCommand), true);
                }
            }
        }
        if (this.hasBlocks(stack, ModItem.GAME_ICON) && entity.method_31747()) {
            player = (class_1657)entity;
            class_2487 nbtCompound = stack.method_7948();
            this.entityList = nbtCompound.method_10554("Absorbed", 10);
            if (!nbtCompound.method_10545("Absorbed") || nbtCompound.method_10545("Absorbed") && nbtCompound.method_10554("Absorbed", 10).isEmpty()) {
                if (nbtCompound.method_10545("Absorbed") && nbtCompound.method_10554("Absorbed", 10).isEmpty()) {
                    nbtCompound.method_10551("Absorbed");
                }
                nbtCompound.method_10566("Absorbed", (class_2520)new class_2499());
                this.entityList = new class_2499();
                this.index = 0;
                this.addPlaceholder(this.staff);
            }
            if (this.index >= 10) {
                this.index = 0;
            }
            if (!player.method_31549().field_7477) {
                if (player.method_6047().method_31574(ModItem.GAME_ICON) && currentMode == 1) {
                    player.method_31549().field_7478 = true;
                } else {
                    player.method_31549().field_7479 = false;
                    player.method_31549().field_7478 = false;
                }
            }
            if (AvMModClient.POWERFUL_STAFF_USE.method_1434()) {
                if (AvMModClient.POWERFUL_STAFF_USE_1.method_1434()) {
                    currentMode = 1;
                    player.method_7353((class_2561)class_2561.method_43471((String)"gui.avm_mod.game_icon_mode2"), true);
                } else if (AvMModClient.POWERFUL_STAFF_USE_2.method_1434()) {
                    currentMode = 2;
                    player.method_7353((class_2561)class_2561.method_43471((String)"gui.avm_mod.game_icon_mode3"), true);
                } else if (AvMModClient.POWERFUL_STAFF_USE_3.method_1434()) {
                    currentMode = 3;
                    player.method_7353((class_2561)class_2561.method_43471((String)"gui.avm_mod.game_icon_mode4"), true);
                }
            }
        }
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        if (!user.method_6079().method_31574(ModItem.POWERFUL_STAFF)) {
            if (this.hasBlocks(user.method_6047(), class_1802.field_8866) && user.method_7338()) {
                if (AvMModClient.POWERFUL_STAFF_USE.method_1434()) {
                    PowerfulStaffScreen screen = new PowerfulStaffScreen(this.staff);
                    class_310.method_1551().method_29970((class_437)screen);
                    screen.addPlayer(user);
                    PowerfulStaffScreen.addCommands(this.bufferedCommands);
                    class_2487 nbtCompound = this.staff.method_7948();
                    if (!nbtCompound.method_10545("Commands")) {
                        nbtCompound.method_10566("Commands", (class_2520)new class_2499());
                    }
                    this.commandList = nbtCompound.method_10554("Commands", 10);
                    class_1271.method_22427((Object)user.method_6047());
                } else if (this.currentCommand != "" && !AvMModClient.POWERFUL_STAFF_USE.method_1434()) {
                    if (this.currentCommand.startsWith("/")) {
                        String readyCommand = this.currentCommand.substring(1);
                        class_310.method_1551().field_1724.field_3944.method_45730(readyCommand);
                    } else {
                        class_310.method_1551().field_1724.field_3944.method_45730(this.currentCommand);
                    }
                }
            } else if (this.hasBlocks(user.method_6047(), ModItem.GAME_ICON)) {
                if (currentMode == 3) {
                    Random rand = new Random();
                    class_2487 nbtCompound = this.staff.method_7969();
                    if (nbtCompound.method_10554("Absorbed", 10) != null) {
                        class_2499 list = nbtCompound.method_10554("Absorbed", 10);
                        for (int i = 0; i < 10; ++i) {
                            int m = this.entityList.method_10602(i).method_10550("Absorb" + i);
                            if (m == 1 || m == 2 || m == 3 || m == 4 || m == 5 || m == 6 || m == 7) {
                                class_1321 entity;
                                if (m == 1) {
                                    entity = new DarkZombieEntity(ModEntities.DARK_ZOMBIE, world);
                                    entity.method_23327(user.method_23317() + (double)rand.nextFloat(-3.0f, 3.0f), user.method_23318() + 1.0, user.method_23321() + (double)rand.nextFloat(-3.0f, 3.0f));
                                    world.method_8649((class_1297)entity);
                                    entity.method_6170(user);
                                }
                                if (m == 2) {
                                    entity = new DarkSkeletonEntity(ModEntities.DARK_SKELETON, world);
                                    entity.method_23327(user.method_23317() + (double)rand.nextFloat(-3.0f, 3.0f), user.method_23318() + 1.0, user.method_23321() + (double)rand.nextFloat(-3.0f, 3.0f));
                                    world.method_8649((class_1297)entity);
                                    entity.method_6122(entity.method_6058(), class_1802.field_8102.method_7854());
                                    entity.method_6170(user);
                                }
                                if (m == 3) {
                                    entity = new DarkCreeperEntity(ModEntities.DARK_CREEPER, world);
                                    entity.method_23327(user.method_23317() + (double)rand.nextFloat(-3.0f, 3.0f), user.method_23318() + 1.0, user.method_23321() + (double)rand.nextFloat(-3.0f, 3.0f));
                                    world.method_8649((class_1297)entity);
                                    entity.method_6170(user);
                                }
                                if (m == 4) {
                                    entity = new DarkSpiderEntity(ModEntities.DARK_SPIDER, world);
                                    entity.method_23327(user.method_23317() + (double)rand.nextFloat(-3.0f, 3.0f), user.method_23318() + 1.0, user.method_23321() + (double)rand.nextFloat(-3.0f, 3.0f));
                                    world.method_8649((class_1297)entity);
                                    entity.method_6170(user);
                                }
                                if (m == 5) {
                                    entity = new DarkEndermanEntity(ModEntities.DARK_ENDERMAN, world);
                                    entity.method_23327(user.method_23317() + (double)rand.nextFloat(-3.0f, 3.0f), user.method_23318() + 1.0, user.method_23321() + (double)rand.nextFloat(-3.0f, 3.0f));
                                    world.method_8649((class_1297)entity);
                                    entity.method_6170(user);
                                }
                                if (m == 6) {
                                    entity = new DarkPhantomEntity(ModEntities.DARK_PHANTOM, world);
                                    entity.method_23327(user.method_23317() + (double)rand.nextFloat(-3.0f, 3.0f), user.method_23318() + 1.0, user.method_23321() + (double)rand.nextFloat(-3.0f, 3.0f));
                                    world.method_8649((class_1297)entity);
                                    entity.method_6170(user);
                                }
                                class_2487 placeholder = new class_2487();
                                placeholder.method_10569("Absorb" + i, 0);
                                list.method_10606(i, (class_2520)placeholder);
                                this.remains = 10;
                                this.index = 0;
                                continue;
                            }
                            user.method_7353((class_2561)class_2561.method_43471((String)"gui.avm_mod.fail_summon_empty"), true);
                        }
                    }
                }
            } else if (this.hasBlocks(user.method_6047(), class_1802.field_8732)) {
                int count = user.method_6079().method_7947();
                if (user.method_6079().method_31574(class_1802.field_8504)) {
                    user.method_6122(class_1268.field_5810, class_1802.field_8752.method_7854());
                } else if (user.method_6079().method_31574(class_1802.field_8748)) {
                    user.method_6122(class_1268.field_5810, class_1802.field_8347.method_7854());
                } else if (user.method_6079().method_31574(class_1802.field_8209)) {
                    user.method_6122(class_1268.field_5810, class_1802.field_8509.method_7854());
                } else if (user.method_6079().method_31574(class_1802.field_8429)) {
                    user.method_6122(class_1268.field_5810, class_1802.field_8373.method_7854());
                } else if (user.method_6079().method_31574(class_1802.field_8726)) {
                    user.method_6122(class_1268.field_5810, class_1802.field_8544.method_7854());
                } else if (user.method_6079().method_31574(class_1802.field_8389)) {
                    user.method_6122(class_1268.field_5810, class_1802.field_8261.method_7854());
                } else if (user.method_6079().method_31574(class_1802.field_8046)) {
                    user.method_6122(class_1268.field_5810, class_1802.field_8176.method_7854());
                } else if (user.method_6079().method_31574(class_1802.field_8476)) {
                    user.method_6122(class_1268.field_5810, class_1802.field_8713.method_7854());
                } else if (user.method_6079().method_31574(class_1802.field_27018)) {
                    user.method_6122(class_1268.field_5810, class_1802.field_27022.method_7854());
                } else if (user.method_6079().method_31574(class_1802.field_8599)) {
                    user.method_6122(class_1268.field_5810, class_1802.field_8620.method_7854());
                } else if (user.method_6079().method_31574(class_1802.field_8775)) {
                    user.method_6122(class_1268.field_5810, class_1802.field_8695.method_7854());
                } else if (user.method_6079().method_31574(class_1802.field_8787)) {
                    user.method_6122(class_1268.field_5810, class_1802.field_8477.method_7854());
                } else if (user.method_6079().method_31574(class_1802.field_8837)) {
                    user.method_6122(class_1268.field_5810, class_1802.field_8687.method_7854());
                } else if (user.method_6079().method_31574(class_1802.field_8809)) {
                    user.method_6122(class_1268.field_5810, class_1802.field_8759.method_7854());
                }
                user.method_6079().method_7939(count);
            } else if (this.hasBlocks(user.method_6047(), class_1802.field_8740)) {
                Random rand = new Random();
                int p = rand.nextInt(16);
                class_1842 potion = this.potionChoose(p);
                class_1686 potionEntity = new class_1686(world, (class_1309)user);
                potionEntity.method_16940(class_1844.method_8061((class_1799)new class_1799((class_1935)class_1802.field_8436), (class_1842)potion));
                potionEntity.method_24919((class_1297)user, user.method_36455(), user.method_36454(), -20.0f, 0.5f, 1.0f);
                world.method_8649((class_1297)potionEntity);
            } else if (this.hasBlocks(user.method_6047(), class_1802.field_8354)) {
                class_1674 fireball = new class_1674(world, (class_1309)user, 0.0, 0.0, 0.0, 1);
                fireball.method_24919((class_1297)user, user.method_36455(), user.method_36454(), -20.0f, 2.5f, 0.0f);
                world.method_8649((class_1297)fireball);
            } else if (this.hasBlocks(user.method_6047(), class_1802.field_8626)) {
                class_1541 tnt = new class_1541(class_1299.field_6063, world);
                float f = -class_3532.method_15374((float)(user.method_36454() * ((float)Math.PI / 180))) * class_3532.method_15362((float)(user.method_36455() * ((float)Math.PI / 180)));
                float g = -class_3532.method_15374((float)((user.method_36455() + -20.0f) * ((float)Math.PI / 180)));
                float h = class_3532.method_15362((float)(user.method_36454() * ((float)Math.PI / 180))) * class_3532.method_15362((float)(user.method_36455() * ((float)Math.PI / 180)));
                class_243 vec3d = new class_243((double)f, (double)g, (double)h).method_1029().method_1031(user.method_6051().method_43385(0.0, 0.0172275), user.method_6051().method_43385(0.0, 0.0172275), user.method_6051().method_43385(0.0, 0.0172275)).method_1021(0.5);
                tnt.method_18799(vec3d);
                double d = vec3d.method_37267();
                tnt.method_36456((float)(class_3532.method_15349((double)vec3d.field_1352, (double)vec3d.field_1350) * 57.2957763671875));
                tnt.method_36457((float)(class_3532.method_15349((double)vec3d.field_1351, (double)d) * 57.2957763671875));
                tnt.field_5982 = tnt.method_36454();
                tnt.field_6004 = tnt.method_36455();
                class_243 vec3d1 = user.method_18798();
                tnt.method_18799(tnt.method_18798().method_1031(vec3d1.field_1352, user.method_24828() ? 0.0 : vec3d1.field_1351, vec3d1.field_1350));
                tnt.method_23327(user.method_23317(), user.method_23318() + 1.0, user.method_23321());
                world.method_8649((class_1297)tnt);
            } else if (this.hasBlocks(user.method_6047(), class_1802.field_8249)) {
                class_243 vec3d = user.method_18798();
                user.method_18800(vec3d.field_1352, 1.5, vec3d.field_1350);
            } else if (this.hasBlocks(user.method_6047(), class_1802.field_8849)) {
                Random rand = new Random();
                int i = rand.nextInt(125);
                class_1297 mob = ((class_1299)class_7923.field_41177.method_10200(i)).method_5883(world);
                if (i >= 121) {
                    mob = ModEntities.CREEPER_BEE.method_5883(world);
                }
                while (!(mob instanceof class_1309)) {
                    mob = ((class_1299)class_7923.field_41177.method_10200(rand.nextInt(120))).method_5883(world);
                }
                mob.method_23327(user.method_23317() + (double)rand.nextFloat(-1.0f, 1.0f), user.method_23318() + 1.0, user.method_23321() + (double)rand.nextFloat(-1.0f, 1.0f));
                world.method_8649(mob);
            } else if (!this.getBlocks(user.method_6047()).stream().allMatch(s -> s.method_31574(class_2246.field_10124.method_8389())) && this.getBlocks(user.method_6047()).get(0).method_7909() instanceof class_1747) {
                class_1747 item = (class_1747)this.getBlocks(user.method_6047()).get(0).method_7909();
                class_2248 block = item.method_7711();
                for (int x = -3; x < 3; ++x) {
                    for (int y = -3; y < 3; ++y) {
                        for (int z = -3; z < 3; ++z) {
                            if (world.method_8320(class_2338.method_49637((double)(user.method_23317() + (double)x), (double)(user.method_23318() + (double)y), (double)(user.method_23321() + (double)z))).method_27852(class_2246.field_10124)) continue;
                            world.method_8501(class_2338.method_49637((double)(user.method_23317() + (double)x), (double)(user.method_23318() + (double)y), (double)(user.method_23321() + (double)z)), block.method_9564());
                        }
                    }
                }
            }
            user.method_7357().method_7906((class_1792)this, this.getUseDuration(user.method_5998(hand)));
        }
        return user.method_6047().method_31574(ModItem.POWERFUL_STAFF) ? class_1271.method_22430((Object)user.method_6047()) : class_1271.method_22430((Object)user.method_6079());
    }

    public class_1269 method_7884(class_1838 context) {
        class_1937 world = context.method_8045();
        class_2338 blockPos = context.method_8037();
        class_2338 blockPos2 = blockPos.method_10093(context.method_8038());
        if (this.hasBlocks(context.method_8041(), class_1802.field_8242)) {
            if (this.useOnFertilizable(context.method_8041(), world, blockPos)) {
                if (!world.field_9236) {
                    world.method_20290(1505, blockPos, 0);
                }
                return class_1269.method_29236((boolean)world.field_9236);
            }
            class_2680 blockState = world.method_8320(blockPos);
            boolean bl = blockState.method_26206((class_1922)world, blockPos, context.method_8038());
            if (bl && this.useOnGround(context.method_8041(), world, blockPos2, context.method_8038())) {
                if (!world.field_9236) {
                    world.method_20290(1505, blockPos2, 0);
                }
                return class_1269.method_29236((boolean)world.field_9236);
            }
        }
        context.method_8036().method_7357().method_7906((class_1792)this, this.getUseDuration(context.method_8041()));
        return class_1269.field_5811;
    }

    public boolean useOnFertilizable(class_1799 stack, class_1937 world, class_2338 pos) {
        class_2256 fertilizable;
        class_2680 blockState = world.method_8320(pos);
        class_2248 var5 = blockState.method_26204();
        if (var5 instanceof class_2256 && (fertilizable = (class_2256)var5).method_9651((class_4538)world, pos, blockState)) {
            if (world instanceof class_3218 && fertilizable.method_9650(world, world.field_9229, pos, blockState)) {
                fertilizable.method_9652((class_3218)world, world.field_9229, pos, blockState);
            }
            return true;
        }
        return false;
    }

    public boolean useOnGround(class_1799 stack, class_1937 world, class_2338 blockPos, @Nullable class_2350 facing) {
        if (!world.method_8320(blockPos).method_27852(class_2246.field_10382) || world.method_8316(blockPos).method_15761() != 8) {
            return false;
        }
        if (!(world instanceof class_3218)) {
            return true;
        }
        class_5819 random = world.method_8409();
        block0: for (int i = 0; i < 128; ++i) {
            class_2338 blockPos2 = blockPos;
            class_2680 blockState = class_2246.field_10376.method_9564();
            for (int j = 0; j < i / 16; ++j) {
                if (world.method_8320(blockPos2 = blockPos2.method_10069(random.method_43048(3) - 1, (random.method_43048(3) - 1) * random.method_43048(3) / 2, random.method_43048(3) - 1)).method_26234((class_1922)world, blockPos2)) continue block0;
            }
            class_6880 registryEntry = world.method_23753(blockPos2);
            if (registryEntry.method_40220(class_6908.field_37380)) {
                if (i == 0 && facing != null && facing.method_10166().method_10179()) {
                    blockState = class_7923.field_41175.method_40266(class_3481.field_15476).flatMap(blocks -> blocks.method_40243(world.field_9229)).map(blockEntry -> ((class_2248)blockEntry.comp_349()).method_9564()).orElse(blockState);
                    if (blockState.method_28498((class_2769)class_2222.field_9933)) {
                        blockState = (class_2680)blockState.method_11657((class_2769)class_2222.field_9933, (Comparable)facing);
                    }
                } else if (random.method_43048(4) == 0) {
                    blockState = class_7923.field_41175.method_40266(class_3481.field_15496).flatMap(blocks -> blocks.method_40243(world.field_9229)).map(blockEntry -> ((class_2248)blockEntry.comp_349()).method_9564()).orElse(blockState);
                }
            }
            if (blockState.method_27851(class_3481.field_15476, state -> state.method_28498((class_2769)class_2222.field_9933))) {
                for (int k = 0; !blockState.method_26184((class_4538)world, blockPos2) && k < 4; ++k) {
                    blockState = (class_2680)blockState.method_11657((class_2769)class_2222.field_9933, (Comparable)class_2350.class_2353.field_11062.method_10183(random));
                }
            }
            if (!blockState.method_26184((class_4538)world, blockPos2)) continue;
            class_2680 blockState2 = world.method_8320(blockPos2);
            if (blockState2.method_27852(class_2246.field_10382) && world.method_8316(blockPos2).method_15761() == 8) {
                world.method_8652(blockPos2, blockState, 3);
                continue;
            }
            if (!blockState2.method_27852(class_2246.field_10376) || random.method_43048(10) != 0) continue;
            ((class_2256)class_2246.field_10376).method_9652((class_3218)world, random, blockPos2, blockState2);
        }
        return true;
    }

    public class_1842 potionChoose(int p) {
        if (p == 0) {
            return class_1847.field_8987;
        }
        if (p == 1) {
            return class_1847.field_8997;
        }
        if (p == 2) {
            return class_1847.field_8979;
        }
        if (p == 3) {
            return class_1847.field_9004;
        }
        if (p == 4) {
            return class_1847.field_8995;
        }
        if (p == 5) {
            return class_1847.field_8967;
        }
        if (p == 6) {
            return class_1847.field_8968;
        }
        if (p == 7) {
            return class_1847.field_8982;
        }
        if (p == 8) {
            return class_1847.field_8986;
        }
        if (p == 9) {
            return class_1847.field_8974;
        }
        if (p == 10) {
            return class_1847.field_8996;
        }
        if (p == 11) {
            return class_1847.field_8978;
        }
        if (p == 12) {
            return class_1847.field_9005;
        }
        if (p == 13) {
            return class_1847.field_8985;
        }
        if (p == 14) {
            return class_1847.field_8990;
        }
        if (p == 15) {
            return class_1847.field_8994;
        }
        if (p == 16) {
            return class_1847.field_8975;
        }
        return null;
    }

    public int getUseDuration(class_1799 itemStack) {
        return 30;
    }

    public class_1269 method_7847(class_1799 stack, class_1657 user, class_1309 entity, class_1268 hand) {
        if (this.hasBlocks(stack, ModItem.GAME_ICON) && currentMode == 2) {
            class_2487 nbtCompound = this.staff.method_7948();
            this.entityList = nbtCompound.method_10554("Absorbed", 10);
            if (this.remains > 0) {
                --this.remains;
                class_2499 list = nbtCompound.method_10554("Absorbed", 10);
                this.absorpedEntities = new ArrayList();
                if (entity instanceof class_1642) {
                    this.absorpedEntities.add(1);
                    this.addMob(this.staff, 1, user);
                    entity.method_31472();
                    user.method_7353((class_2561)class_2561.method_43471((String)"gui.avm_mod.absorped").method_10852(entity.method_5476()).method_10852((class_2561)class_2561.method_43471((String)"gui.avm_mod.remain").method_27693(String.valueOf(this.remains))), true);
                } else if (entity instanceof class_1613) {
                    this.absorpedEntities.add(2);
                    this.addMob(this.staff, 2, user);
                    entity.method_31472();
                    user.method_7353((class_2561)class_2561.method_43471((String)"gui.avm_mod.absorped").method_10852(entity.method_5476()).method_10852((class_2561)class_2561.method_43471((String)"gui.avm_mod.remain").method_27693(String.valueOf(this.remains))), true);
                } else if (entity instanceof class_1548) {
                    this.absorpedEntities.add(3);
                    this.addMob(this.staff, 3, user);
                    entity.method_31472();
                    user.method_7353((class_2561)class_2561.method_43471((String)"gui.avm_mod.absorped").method_10852(entity.method_5476()).method_10852((class_2561)class_2561.method_43471((String)"gui.avm_mod.remain").method_27693(String.valueOf(this.remains))), true);
                } else if (entity instanceof class_1593) {
                    this.absorpedEntities.add(6);
                    this.addMob(this.staff, 6, user);
                    entity.method_31472();
                    user.method_7353((class_2561)class_2561.method_43471((String)"gui.avm_mod.absorped").method_10852(entity.method_5476()).method_10852((class_2561)class_2561.method_43471((String)"gui.avm_mod.remain").method_27693(String.valueOf(this.remains))), true);
                } else if (entity instanceof class_1628) {
                    this.absorpedEntities.add(4);
                    this.addMob(this.staff, 4, user);
                    entity.method_31472();
                    user.method_7353((class_2561)class_2561.method_43471((String)"gui.avm_mod.absorped").method_10852(entity.method_5476()).method_10852((class_2561)class_2561.method_43471((String)"gui.avm_mod.remain").method_27693(String.valueOf(this.remains))), true);
                } else if (entity instanceof class_1560) {
                    this.absorpedEntities.add(5);
                    this.addMob(this.staff, 5, user);
                    entity.method_31472();
                    user.method_7353((class_2561)class_2561.method_43471((String)"gui.avm_mod.absorped").method_10852(entity.method_5476()).method_10852((class_2561)class_2561.method_43471((String)"gui.avm_mod.remain").method_27693(String.valueOf(this.remains))), true);
                } else {
                    ++this.remains;
                    --this.index;
                    user.method_7353((class_2561)class_2561.method_43471((String)"gui.avm_mod.cant_absorp"), true);
                    return class_1269.field_5814;
                }
            }
        }
        user.method_7357().method_7906((class_1792)this, this.getUseDuration(user.method_5998(hand)));
        return class_1269.field_5814;
    }

    private ParseResults<class_2168> parse(String command, class_1657 player) {
        MinecraftServer server = player.method_5682();
        CommandDispatcher commandDispatcher = server.method_3734().method_9235();
        return commandDispatcher.parse(command, (Object)player.method_5671());
    }

    private Optional<class_1799> removeFirstStack(class_1799 stack) {
        class_2487 nbtCompound = stack.method_7948();
        if (!nbtCompound.method_10545(ITEMS_KEY)) {
            return Optional.empty();
        }
        this.setBlocked(stack, false);
        class_2499 nbtList = nbtCompound.method_10554(ITEMS_KEY, 10);
        if (nbtList.isEmpty()) {
            return Optional.empty();
        }
        boolean i = false;
        class_2487 nbtCompound2 = nbtList.method_10602(0);
        class_1799 itemStack = class_1799.method_7915((class_2487)nbtCompound2);
        nbtList.method_10536(0);
        if (nbtList.isEmpty()) {
            stack.method_7983(ITEMS_KEY);
        }
        return Optional.of(itemStack);
    }

    private Optional<class_1799> createCommands(class_1799 stack) {
        class_2487 nbtCompound = stack.method_7948();
        class_2487 placeholder = new class_2487();
        placeholder.method_10582("", "");
        class_2499 list = nbtCompound.method_10554("Commands", 10);
        class_2487 nbtCompound2 = list.method_10602(0);
        class_1799 itemStack = class_1799.method_7915((class_2487)nbtCompound2);
        for (int i = 0; i < 6; ++i) {
            String command = this.bufferedCommands.get(i);
            if (command == null) continue;
            class_2487 nbtCompound3 = new class_2487();
            nbtCompound3.method_10582("Command" + i, command);
            this.commandList.add((Object)placeholder);
            this.commandList.method_10606(i, (class_2520)nbtCompound3);
            if (this.commandList.size() <= 6) continue;
            for (int j = 6; j < this.commandList.size(); ++j) {
                this.commandList.method_10536(j);
            }
        }
        return Optional.of(itemStack);
    }

    private Optional<class_1799> addMob(class_1799 stack, int mobIndex, class_1657 player) {
        class_2487 nbtCompound = stack.method_7948();
        class_2499 list = nbtCompound.method_10554("Absorbed", 10);
        class_2487 nbtCompound2 = list.method_10602(0);
        class_1799 itemStack = class_1799.method_7915((class_2487)nbtCompound2);
        if (list.size() <= 10 && this.index < 10 && this.index >= 0) {
            class_2487 nbtCompound3 = new class_2487();
            nbtCompound3.method_10569("Absorb" + this.index, mobIndex);
            list.method_10606(this.index, (class_2520)nbtCompound3);
            this.entityList = list;
            ++this.index;
        } else {
            player.method_7353((class_2561)class_2561.method_43471((String)"gui.avm_mod.limit"), true);
        }
        return Optional.of(itemStack);
    }

    private Optional<class_1799> addPlaceholder(class_1799 stack) {
        class_2487 nbtCompound = stack.method_7948();
        class_2499 list = nbtCompound.method_10554("Absorbed", 10);
        class_2487 nbtCompound2 = list.method_10602(0);
        class_1799 itemStack = class_1799.method_7915((class_2487)nbtCompound2);
        for (int i = 0; i < 10; ++i) {
            class_2487 placeholder = new class_2487();
            placeholder.method_10569("Absorb" + i, 0);
            list.add((Object)placeholder);
            if (list.size() > 10) {
                for (int j = 10; j < list.size(); ++j) {
                    list.method_10536(j);
                }
            }
            this.entityList = list;
        }
        return Optional.of(itemStack);
    }

    public void commands(String command1, String command2, String command3, String command4, String command5, String command6) {
        this.bufferedCommands = new ArrayList();
        this.bufferedCommands.add(0, command1);
        this.bufferedCommands.add(1, command2);
        this.bufferedCommands.add(2, command3);
        this.bufferedCommands.add(3, command4);
        this.bufferedCommands.add(4, command5);
        this.bufferedCommands.add(5, command6);
        this.createCommands(this.staff);
    }

    public boolean method_31566(class_1799 stack, class_1799 otherStack, class_1735 slot, class_5536 clickType, class_1657 player, class_5630 cursorStackReference) {
        if (clickType != class_5536.field_27014 || !slot.method_32754(player)) {
            return false;
        }
        if (otherStack.method_7960()) {
            this.removeFirstStack(stack).ifPresent(itemStack -> {
                this.playRemoveOneSound((class_1297)player);
                cursorStackReference.method_32332(itemStack);
            });
        } else {
            int i = this.addToBundle(stack, otherStack);
            if (i > 0) {
                this.playInsertSound((class_1297)player);
                otherStack.method_7934(i);
            }
        }
        return true;
    }

    private int addToBundle(class_1799 bundle, class_1799 stack) {
        if (stack.method_7960() || !stack.method_7909().method_31568()) {
            return 0;
        }
        class_2487 nbtCompound = bundle.method_7948();
        if (!nbtCompound.method_10545(ITEMS_KEY)) {
            nbtCompound.method_10566(ITEMS_KEY, (class_2520)new class_2499());
        }
        int i = this.getBundleOccupancy(bundle);
        int j = this.getItemOccupancy(stack);
        int k = Math.min(stack.method_7947(), (1 - i) / j);
        if (k == 0) {
            return 0;
        }
        class_2499 nbtList = nbtCompound.method_10554(ITEMS_KEY, 10);
        Optional<class_2487> optional = this.canMergeStack(stack, nbtList);
        if (optional.isPresent()) {
            class_2487 nbtCompound2 = optional.get();
            class_1799 itemStack = class_1799.method_7915((class_2487)nbtCompound2);
            itemStack.method_7933(k);
            itemStack.method_7953(nbtCompound2);
            nbtList.remove((Object)nbtCompound2);
            nbtList.method_10531(0, (class_2520)nbtCompound2);
        } else {
            class_1799 itemStack2 = stack.method_46651(k);
            class_2487 nbtCompound3 = new class_2487();
            itemStack2.method_7953(nbtCompound3);
            nbtList.method_10531(0, (class_2520)nbtCompound3);
        }
        return k;
    }

    private int getItemOccupancy(class_1799 stack) {
        class_2487 nbtCompound;
        if (stack.method_31574(class_1802.field_27023)) {
            return 4 + this.getBundleOccupancy(stack);
        }
        if ((stack.method_31574(class_1802.field_20416) || stack.method_31574(class_1802.field_20415)) && stack.method_7985() && (nbtCompound = class_1747.method_38072((class_1799)stack)) != null && !nbtCompound.method_10554("Bees", 10).isEmpty()) {
            return 1;
        }
        return 64 / stack.method_7914();
    }

    public Optional<class_5632> method_32346(class_1799 stack) {
        class_2371 defaultedList = class_2371.method_10211();
        this.getBundledStacks(stack).forEach(arg_0 -> defaultedList.add(arg_0));
        return Optional.of(new class_5631(defaultedList, this.getBundleOccupancy(stack)));
    }

    private Optional<class_2487> canMergeStack(class_1799 stack, class_2499 items) {
        if (stack.method_31574(class_1802.field_27023)) {
            return Optional.empty();
        }
        return items.stream().filter(class_2487.class::isInstance).map(class_2487.class::cast).filter(item -> class_1799.method_31577((class_1799)class_1799.method_7915((class_2487)item), (class_1799)stack)).findFirst();
    }

    private int getBundleOccupancy(class_1799 stack) {
        return this.getBundledStacks(stack).mapToInt(itemStack -> this.getItemOccupancy((class_1799)itemStack) * itemStack.method_7947()).sum();
    }

    public Stream<class_1799> getBundledStacks(class_1799 stack) {
        class_2487 nbtCompound = stack.method_7969();
        if (nbtCompound == null) {
            return Stream.empty();
        }
        class_2499 nbtList = nbtCompound.method_10554(ITEMS_KEY, 10);
        return nbtList.stream().map(class_2487.class::cast).map(class_1799::method_7915);
    }

    private void playRemoveOneSound(class_1297 entity) {
        entity.method_5783(class_3417.field_34377, 0.8f, 0.8f + entity.method_37908().method_8409().method_43057() * 0.4f);
    }

    private void playInsertSound(class_1297 entity) {
        entity.method_5783(class_3417.field_34376, 0.8f, 0.8f + entity.method_37908().method_8409().method_43057() * 0.4f);
    }

    private List<class_1799> getBlocks(class_1799 staff) {
        class_2499 nbtList;
        ArrayList list = Lists.newArrayList();
        class_2487 nbtCompound = staff.method_7969();
        if (nbtCompound != null && nbtCompound.method_10573(ITEMS_KEY, 9) && (nbtList = nbtCompound.method_10554(ITEMS_KEY, 10)) != null) {
            for (int i = 0; i < nbtList.size(); ++i) {
                class_2487 nbtCompound2 = nbtList.method_10602(i);
                list.add(class_1799.method_7915((class_2487)nbtCompound2));
            }
        }
        return list;
    }

    private boolean hasBlocks(class_1799 staff, class_1792 block) {
        return this.getBlocks(staff).stream().anyMatch(s -> s.method_31574(block));
    }

    public void setBlocked(class_1799 stack, boolean blocked) {
        class_2487 nbtCompound = stack.method_7948();
        nbtCompound.method_10556(BLOCKED_KEY, blocked);
        if (!nbtCompound.method_10577(BLOCKED_KEY)) {
            nbtCompound.method_10551(BLOCKED_KEY);
        }
    }

    private int muliplicate(class_1799 stack) {
        if (this.hasBlocks(stack, class_1802.field_27071)) {
            return 1;
        }
        if (this.hasBlocks(stack, class_1802.field_8773)) {
            return 2;
        }
        if (this.hasBlocks(stack, class_1802.field_8494)) {
            return 3;
        }
        if (this.hasBlocks(stack, class_1802.field_8733)) {
            return 4;
        }
        if (this.hasBlocks(stack, class_1802.field_8603)) {
            return 5;
        }
        if (this.hasBlocks(stack, class_1802.field_22018)) {
            return 7;
        }
        if (this.hasBlocks(stack, class_1802.field_8866)) {
            return 11;
        }
        if (this.hasBlocks(stack, ModItem.GAME_ICON)) {
            return 13;
        }
        return 0;
    }
}

