/*
 * Decompiled with CFR 0.152.
 */
package net.almer.avm_mod;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import net.almer.avm_mod.block.ModBlock;
import net.almer.avm_mod.effect.ModEffect;
import net.almer.avm_mod.entity.ModEntities;
import net.almer.avm_mod.entity.custom.LivingBrewingStandEntity;
import net.almer.avm_mod.entity.custom.LivingChestEntity;
import net.almer.avm_mod.entity.custom.LivingFurnaceEntity;
import net.almer.avm_mod.entity.custom.SuperPigEntity;
import net.almer.avm_mod.entity.custom.TitanRavagerEntity;
import net.almer.avm_mod.entity.custom.dark.DarkCreeperEntity;
import net.almer.avm_mod.entity.custom.dark.DarkEndermanEntity;
import net.almer.avm_mod.entity.custom.dark.DarkPhantomEntity;
import net.almer.avm_mod.entity.custom.dark.DarkSkeletonEntity;
import net.almer.avm_mod.entity.custom.dark.DarkSpiderEntity;
import net.almer.avm_mod.entity.custom.dark.DarkZombieEntity;
import net.almer.avm_mod.item.ModItem;
import net.almer.avm_mod.item.ModItemGroup;
import net.almer.avm_mod.item.potion.ModPotion;
import net.almer.avm_mod.network.ModMessages;
import net.almer.avm_mod.sound.ModSound;
import net.almer.avm_mod.util.ModBoostrap;
import net.almer.avm_mod.util.ModifyLootTable;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1329;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5132;
import net.minecraft.class_7923;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvMMod
implements ModInitializer {
    public static final String MOD_ID = "avm_mod";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"avm_mod");
    public static final class_1322 singleRangeAttributeModifier = new class_1322(UUID.fromString("7f7dbdb2-0d0d-458a-aa40-ac7633691f66"), "Range modifier", 10.0, class_1322.class_1323.field_6328);
    public static final Supplier<Multimap<class_1320, class_1322>> rangeModifier = Suppliers.memoize(() -> ImmutableMultimap.of((Object)REACH, (Object)singleRangeAttributeModifier));
    public static final class_1320 REACH = AvMMod.make("reach", 0.0, -1024.0, 1024.0);
    public static final class_1320 ATTACK_RANGE = AvMMod.make("attack_range", 0.0, -1024.0, 1024.0);

    public static double getReachDistance(class_1309 entity, double baseReachDistance) {
        class_1324 reachDistance = entity.method_5996(REACH);
        return reachDistance != null ? baseReachDistance + reachDistance.method_6194() : baseReachDistance;
    }

    public static double getSquaredReachDistance(class_1309 entity, double sqBaseReachDistance) {
        double reachDistance = AvMMod.getReachDistance(entity, Math.sqrt(sqBaseReachDistance));
        return reachDistance * reachDistance;
    }

    public static double getAttackRange(class_1309 entity, double baseAttackRange) {
        class_1324 attackRange = entity.method_5996(ATTACK_RANGE);
        return attackRange != null ? baseAttackRange + attackRange.method_6194() : baseAttackRange;
    }

    public static double getSquaredAttackRange(class_1309 entity, double sqBaseAttackRange) {
        double attackRange = AvMMod.getAttackRange(entity, Math.sqrt(sqBaseAttackRange));
        return attackRange * attackRange;
    }

    public static List<class_1657> getPlayersWithinReach(class_1937 world, int x, int y, int z, double baseReachDistance) {
        return AvMMod.getPlayersWithinReach(player -> true, world, x, y, z, baseReachDistance);
    }

    public static List<class_1657> getPlayersWithinReach(Predicate<class_1657> viewerPredicate, class_1937 world, int x, int y, int z, double baseReachDistance) {
        ArrayList<class_1657> playersWithinReach = new ArrayList<class_1657>(0);
        for (class_1657 player : world.method_18456()) {
            double dz;
            double dy;
            if (!viewerPredicate.test(player)) continue;
            double reach = AvMMod.getReachDistance((class_1309)player, baseReachDistance);
            double dx = (double)x + 0.5 - player.method_23317();
            if (!(dx * dx + (dy = (double)y + 0.5 - player.method_23320()) * dy + (dz = (double)z + 0.5 - player.method_23321()) * dz <= reach * reach)) continue;
            playersWithinReach.add(player);
        }
        return playersWithinReach;
    }

    public static boolean isWithinAttackRange(class_1657 player, class_1297 entity) {
        return player.method_5858(entity) <= AvMMod.getSquaredAttackRange((class_1309)player, 64.0);
    }

    private static class_1320 make(String name, double base, double min, double max) {
        return new class_1329("attribute.name.generic.avm_mod." + name, base, min, max).method_26829(true);
    }

    public void onInitialize() {
        ModItem.registerItems();
        ModBlock.registerBlocks();
        ModItemGroup.registerGroups();
        ModEntities.register();
        FabricDefaultAttributeRegistry.register(ModEntities.LIVING_CHEST, (class_5132.class_5133)LivingChestEntity.createAttributes());
        FabricDefaultAttributeRegistry.register(ModEntities.LIVING_BREWING_STAND, (class_5132.class_5133)LivingBrewingStandEntity.createAttributes());
        FabricDefaultAttributeRegistry.register(ModEntities.LIVING_FURNACE, (class_5132.class_5133)LivingFurnaceEntity.createAttributes());
        FabricDefaultAttributeRegistry.register(ModEntities.TITAN_RAVAGER, (class_5132.class_5133)TitanRavagerEntity.createRavagerAttributes());
        FabricDefaultAttributeRegistry.register(ModEntities.SUPER_PIG, (class_5132)SuperPigEntity.createAttributes());
        FabricDefaultAttributeRegistry.register(ModEntities.DARK_ZOMBIE, (class_5132.class_5133)DarkZombieEntity.createZombieAttributes());
        FabricDefaultAttributeRegistry.register(ModEntities.DARK_SKELETON, (class_5132.class_5133)DarkSkeletonEntity.createAbstractSkeletonAttributes());
        FabricDefaultAttributeRegistry.register(ModEntities.DARK_CREEPER, (class_5132.class_5133)DarkCreeperEntity.createCreeperAttributes());
        FabricDefaultAttributeRegistry.register(ModEntities.DARK_SPIDER, (class_5132.class_5133)DarkSpiderEntity.createSpiderAttributes());
        FabricDefaultAttributeRegistry.register(ModEntities.DARK_ENDERMAN, (class_5132.class_5133)DarkEndermanEntity.createEndermanAttributes());
        FabricDefaultAttributeRegistry.register(ModEntities.DARK_PHANTOM, (class_5132.class_5133)DarkPhantomEntity.createPhantomAttributes());
        ModifyLootTable.modifyLootTables();
        class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)ModSound.FLUTE_MUSIC, (Object)ModSound.FLUTE_MUSIC_EVENT);
        class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)ModSound.ELECTRIC_GUITAR, (Object)ModSound.ELECTRIC_GUITAR_EVENT);
        class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)ModSound.GREEN_JAM, (Object)ModSound.GREEN_JAM_EVENT);
        class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)ModSound.JAZZY_NOTE_BLOCKS, (Object)ModSound.JAZZY_NOTE_BLOCKS_EVENT);
        ModEffect.registerEffects();
        ModPotion.registerPotionsRecipes();
        ModBoostrap.initialize();
        ModMessages.registerC2SPackets();
        class_2378.method_10230((class_2378)class_7923.field_41190, (class_2960)new class_2960(MOD_ID, "reach"), (Object)REACH);
        class_2378.method_10230((class_2378)class_7923.field_41190, (class_2960)new class_2960(MOD_ID, "attack_range"), (Object)ATTACK_RANGE);
    }
}

