/*
 * Decompiled with CFR 0.152.
 */
package net.almer.avm_mod.block.custom;

import java.util.List;
import java.util.function.Predicate;
import net.almer.avm_mod.block.ModBlock;
import net.almer.avm_mod.item.ModItem;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1538;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2586;
import net.minecraft.class_2631;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2694;
import net.minecraft.class_2697;
import net.minecraft.class_2700;
import net.minecraft.class_2715;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2758;
import net.minecraft.class_2766;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3489;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class ChargedNoteBlock
extends class_2248 {
    public static final class_2754<class_2766> INSTRUMENT = class_2741.field_12499;
    public static final class_2746 POWERED = class_2741.field_12484;
    public static final class_2758 NOTE = class_2741.field_12524;
    public static final int field_41678 = 3;
    @Nullable
    private class_2700 guitarDispenserPattern;
    @Nullable
    private class_2700 guitarPattern;
    private static final Predicate<class_2680> IS_GOLEM_HEAD_PREDICATE = state -> state != null && state.method_27852(ModBlock.CHARGED_NOTE_BLOCK);

    public ChargedNoteBlock(class_4970.class_2251 settings) {
        super(settings);
    }

    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean notify) {
        if (!oldState.method_27852(state.method_26204())) {
            class_238 box = new class_238(pos).method_1014(1.5);
            List lightnings = world.method_8390(class_1538.class, box, e -> e.method_5805());
            if (!lightnings.isEmpty()) {
                for (int i = 0; i < lightnings.size(); ++i) {
                    ((class_1538)lightnings.get(i)).method_31472();
                }
            }
            this.trySpawnEntity(world, pos);
        }
    }

    private void trySpawnEntity(class_1937 world, class_2338 pos) {
        class_1542 itemEntity;
        class_2700.class_2702 result = this.getGuitarPattern().method_11708((class_4538)world, pos);
        if (result != null && (itemEntity = new class_1542(world, (double)pos.method_10263(), (double)(pos.method_10264() - 1), (double)pos.method_10260(), ModItem.GUITAR.method_7854())) != null) {
            ChargedNoteBlock.spawnEntity(world, result, (class_1297)itemEntity, result.method_11717(0, 2, 0).method_11683());
        }
    }

    private class_2700 getGuitarDispenserPattern() {
        if (this.guitarDispenserPattern == null) {
            this.guitarDispenserPattern = class_2697.method_11701().method_11702(new String[]{" ##", "%~~"}).method_11700('#', class_2694.method_11678((Predicate)class_2715.method_11758((class_2248)class_2246.field_10269))).method_11700('%', class_2694.method_11678((Predicate)class_2715.method_11758((class_2248)class_2246.field_10028))).method_11700('~', pos -> pos.method_11681().method_26215()).method_11704();
        }
        return this.guitarDispenserPattern;
    }

    private class_2700 getGuitarPattern() {
        if (this.guitarPattern == null) {
            this.guitarPattern = class_2697.method_11701().method_11702(new String[]{"^##", "%~~"}).method_11700('^', class_2694.method_11678(IS_GOLEM_HEAD_PREDICATE)).method_11700('#', class_2694.method_11678((Predicate)class_2715.method_11758((class_2248)class_2246.field_10269))).method_11700('%', class_2694.method_11678((Predicate)class_2715.method_11758((class_2248)class_2246.field_10028))).method_11700('~', pos -> pos.method_11681().method_26215()).method_11704();
        }
        return this.guitarPattern;
    }

    private static void spawnEntity(class_1937 world, class_2700.class_2702 patternResult, class_1297 entity, class_2338 pos) {
        ChargedNoteBlock.breakPatternBlocks(world, patternResult);
        entity.method_5808((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.05, (double)pos.method_10260() + 0.5, 0.0f, 0.0f);
        world.method_8649(entity);
        for (class_3222 serverPlayerEntity : world.method_18467(class_3222.class, entity.method_5829().method_1014(5.0))) {
            class_174.field_1182.method_9124(serverPlayerEntity, entity);
        }
        ChargedNoteBlock.updatePatternBlocks(world, patternResult);
    }

    public static void breakPatternBlocks(class_1937 world, class_2700.class_2702 patternResult) {
        for (int i = 0; i < patternResult.method_35302(); ++i) {
            for (int j = 0; j < patternResult.method_35303(); ++j) {
                class_2694 cachedBlockPosition = patternResult.method_11717(i, j, 0);
                world.method_8652(cachedBlockPosition.method_11683(), class_2246.field_10124.method_9564(), 2);
                world.method_20290(2001, cachedBlockPosition.method_11683(), class_2248.method_9507((class_2680)cachedBlockPosition.method_11681()));
            }
        }
    }

    public static void updatePatternBlocks(class_1937 world, class_2700.class_2702 patternResult) {
        for (int i = 0; i < patternResult.method_35302(); ++i) {
            for (int j = 0; j < patternResult.method_35303(); ++j) {
                class_2694 cachedBlockPosition = patternResult.method_11717(i, j, 0);
                world.method_8408(cachedBlockPosition.method_11683(), class_2246.field_10124);
            }
        }
    }

    private class_2680 getStateWithInstrument(class_1936 world, class_2338 pos, class_2680 state) {
        class_2766 instrument = world.method_8320(pos.method_10084()).method_51364();
        if (instrument.method_51372()) {
            return (class_2680)state.method_11657(INSTRUMENT, (Comparable)instrument);
        }
        class_2766 instrument2 = world.method_8320(pos.method_10074()).method_51364();
        class_2766 instrument3 = instrument2.method_51372() ? class_2766.field_12648 : instrument2;
        return (class_2680)state.method_11657(INSTRUMENT, (Comparable)instrument3);
    }

    public class_2680 method_9605(class_1750 ctx) {
        return this.getStateWithInstrument((class_1936)ctx.method_8045(), ctx.method_8037(), this.method_9564());
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        boolean bl = direction.method_10166() == class_2350.class_2351.field_11052;
        return bl ? this.getStateWithInstrument(world, pos, state) : super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, class_2338 sourcePos, boolean notify) {
        boolean bl = world.method_49803(pos);
        if (bl != (Boolean)state.method_11654((class_2769)POWERED)) {
            if (bl) {
                this.playNote(null, state, world, pos);
            }
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(bl)), 3);
        }
    }

    private void playNote(@Nullable class_1297 entity, class_2680 state, class_1937 world, class_2338 pos) {
        if (((class_2766)state.method_11654(INSTRUMENT)).method_51372() || world.method_8320(pos.method_10084()).method_26215()) {
            world.method_8427(pos, (class_2248)this, 0, 0);
            world.method_33596(entity, class_5712.field_38425, pos);
        }
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_1799 itemStack = player.method_5998(hand);
        if (itemStack.method_31573(class_3489.field_41757) && hit.method_17780() == class_2350.field_11036) {
            return class_1269.field_5811;
        }
        if (world.field_9236) {
            return class_1269.field_5812;
        }
        state = (class_2680)state.method_28493((class_2769)NOTE);
        world.method_8652(pos, state, 3);
        this.playNote((class_1297)player, state, world, pos);
        player.method_7281(class_3468.field_15393);
        return class_1269.field_21466;
    }

    public void method_9606(class_2680 state, class_1937 world, class_2338 pos, class_1657 player) {
        if (!world.field_9236) {
            this.playNote((class_1297)player, state, world, pos);
            player.method_7281(class_3468.field_15385);
        }
    }

    public static float getNotePitch(int note) {
        return (float)Math.pow(2.0, (double)(note - 12) / 12.0);
    }

    public boolean method_9592(class_2680 state, class_1937 world, class_2338 pos, int type, int data) {
        class_6880 registryEntry;
        float f;
        class_2766 instrument = (class_2766)state.method_11654(INSTRUMENT);
        if (instrument.method_47889()) {
            int i = (Integer)state.method_11654((class_2769)NOTE);
            f = ChargedNoteBlock.getNotePitch(i);
            world.method_8406((class_2394)class_2398.field_11224, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 1.2, (double)pos.method_10260() + 0.5, (double)i / 24.0, 0.0, 0.0);
        } else {
            f = 1.0f;
        }
        if (instrument.method_47890()) {
            class_2960 identifier = this.getCustomSound(world, pos);
            if (identifier == null) {
                return false;
            }
            registryEntry = class_6880.method_40223((Object)class_3414.method_47908((class_2960)identifier));
        } else {
            registryEntry = instrument.method_11886();
        }
        world.method_8465((class_1657)null, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, registryEntry, class_3419.field_15247, 3.0f, f, world.field_9229.method_43055());
        return true;
    }

    @Nullable
    private class_2960 getCustomSound(class_1937 world, class_2338 pos) {
        class_2586 var4 = world.method_8321(pos.method_10084());
        if (var4 instanceof class_2631) {
            class_2631 skullBlockEntity = (class_2631)var4;
            return skullBlockEntity.method_47888();
        }
        return null;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{INSTRUMENT, POWERED, NOTE});
    }
}

