/*
 * Decompiled with CFR 0.152.
 */
package net.almer.avm_mod.item.custom;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Stream;
import net.almer.avm_mod.AvMModClient;
import net.almer.avm_mod.client.screen.PowerfulStaffScreen;
import net.almer.avm_mod.entity.ModEntities;
import net.almer.avm_mod.entity.custom.dark.DarkCreeperEntity;
import net.almer.avm_mod.entity.custom.dark.DarkEndermanEntity;
import net.almer.avm_mod.entity.custom.dark.DarkPhantomEntity;
import net.almer.avm_mod.entity.custom.dark.DarkSkeletonEntity;
import net.almer.avm_mod.entity.custom.dark.DarkSpiderEntity;
import net.almer.avm_mod.entity.custom.dark.DarkZombieEntity;
import net.almer.avm_mod.item.ModItem;
import net.almer.avm_mod.network.packet.AddCommandsC2SPacket;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1321;
import net.minecraft.class_1322;
import net.minecraft.class_1548;
import net.minecraft.class_1560;
import net.minecraft.class_1593;
import net.minecraft.class_1613;
import net.minecraft.class_1628;
import net.minecraft.class_1642;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1831;
import net.minecraft.class_1832;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2246;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_437;
import net.minecraft.class_5134;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import net.minecraft.class_5631;
import net.minecraft.class_5632;
import net.minecraft.class_746;
import net.minecraft.server.MinecraftServer;

public class PowerfulStaffItem
extends class_1831 {
    private static final String ITEMS_KEY = "Block";
    private static final String BLOCKED_KEY = "Blocked";
    private static final String currentCommandKey = "gui.avm_mod.current_text";
    private static final int zombieIndex = 1;
    private static final int skeletonIndex = 2;
    private static final int creeperIndex = 3;
    private static final int spiderIndex = 4;
    private static final int endermanIndex = 5;
    private static final int phantomIndex = 6;
    private float attackDamage;
    private float attackSpeed;
    private Multimap<class_1320, class_1322> attributeModifiers;
    private class_1799 staff;
    public static String currentCommand = "";
    public static int currentMode = 1;
    public static List<String> bufferedCommands;
    class_2499 commandList;
    class_2499 entityList;
    public static List absorpedEntities;
    private int remains = 10;
    private int index = 0;
    private static MinecraftServer server;

    public PowerfulStaffItem(class_1832 toolMaterial, int attackDamage, float attackSpeed, class_1792.class_1793 settings) {
        super(toolMaterial, settings);
        this.attackDamage = attackDamage;
        this.attackSpeed = attackSpeed;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)class_5134.field_23721, (Object)new class_1322(field_8006, "Weapon modifier", (double)this.attackDamage, class_1322.class_1323.field_6328));
        builder.put((Object)class_5134.field_23723, (Object)new class_1322(field_8001, "Weapon modifier", (double)this.attackSpeed, class_1322.class_1323.field_6328));
        this.attributeModifiers = builder.build();
        this.index = 0;
    }

    public float getAttackDamage() {
        return this.attackDamage;
    }

    public static class_1657 getPlayer() {
        class_746 player = class_310.method_1551().field_1724;
        return player;
    }

    public Multimap<class_1320, class_1322> method_7844(class_1304 slot) {
        if (slot == class_1304.field_6173) {
            return this.attributeModifiers;
        }
        return super.method_7844(slot);
    }

    public boolean method_31565(class_1799 stack, class_1735 slot, class_5536 clickType, class_1657 player) {
        if (clickType != class_5536.field_27014) {
            return false;
        }
        class_1799 itemStack = slot.method_7677();
        if (itemStack.method_7960()) {
            this.playRemoveOneSound((class_1297)player);
            PowerfulStaffItem.removeFirstStack(stack).ifPresent(removedStack -> PowerfulStaffItem.addToBundle(stack, slot.method_32756(removedStack)));
        } else if (itemStack.method_7909().method_31568()) {
            int i = (1 - PowerfulStaffItem.getBundleOccupancy(stack)) / PowerfulStaffItem.getItemOccupancy(itemStack);
            if (itemStack.method_31574(class_2246.field_10205.method_8389()) || itemStack.method_31574(class_2246.field_10201.method_8389()) || itemStack.method_31574(class_2246.field_22108.method_8389()) || itemStack.method_31574(class_2246.field_10085.method_8389()) || itemStack.method_31574(class_2246.field_27119.method_8389()) || itemStack.method_31574(class_2246.field_10234.method_8389()) || itemStack.method_31574(class_2246.field_10525.method_8389()) || itemStack.method_31574(ModItem.GAME_ICON)) {
                PowerfulStaffItem.setBlocked(stack, true);
                this.staff = stack;
                int j = PowerfulStaffItem.addToBundle(stack, slot.method_32753(itemStack.method_7947(), i, player));
                if (j > 0) {
                    this.playInsertSound((class_1297)player);
                }
            }
        }
        return true;
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        class_1657 player;
        this.staff = stack;
        this.attackDamage = 6 + PowerfulStaffItem.muliplicate(stack);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)class_5134.field_23721, (Object)new class_1322(field_8006, "Weapon modifier", (double)this.attackDamage, class_1322.class_1323.field_6328));
        builder.put((Object)class_5134.field_23723, (Object)new class_1322(field_8001, "Weapon modifier", (double)this.attackSpeed, class_1322.class_1323.field_6328));
        this.attributeModifiers = builder.build();
        if (PowerfulStaffItem.hasBlocks(stack, class_1802.field_8866) && entity.method_31747()) {
            player = (class_1657)entity;
            AddCommandsC2SPacket.getCommands1();
            if (AvMModClient.POWERFUL_STAFF_USE.method_1434() && player.method_7338() && this.commandList != null) {
                if (AvMModClient.POWERFUL_STAFF_USE_1.method_1434()) {
                    currentCommand = this.commandList.method_10602(0).method_10558("Command0");
                    player.method_7353((class_2561)class_2561.method_43471((String)currentCommandKey).method_27693(currentCommand), true);
                } else if (AvMModClient.POWERFUL_STAFF_USE_2.method_1434()) {
                    currentCommand = this.commandList.method_10602(1).method_10558("Command1");
                    player.method_7353((class_2561)class_2561.method_43471((String)currentCommandKey).method_27693(currentCommand), true);
                } else if (AvMModClient.POWERFUL_STAFF_USE_3.method_1434()) {
                    currentCommand = this.commandList.method_10602(2).method_10558("Command2");
                    player.method_7353((class_2561)class_2561.method_43471((String)currentCommandKey).method_27693(currentCommand), true);
                } else if (AvMModClient.POWERFUL_STAFF_USE_4.method_1434()) {
                    currentCommand = this.commandList.method_10602(3).method_10558("Command3");
                    player.method_7353((class_2561)class_2561.method_43471((String)currentCommandKey).method_27693(currentCommand), true);
                } else if (AvMModClient.POWERFUL_STAFF_USE_5.method_1434()) {
                    currentCommand = this.commandList.method_10602(4).method_10558("Command4");
                    player.method_7353((class_2561)class_2561.method_43471((String)currentCommandKey).method_27693(currentCommand), true);
                } else if (AvMModClient.POWERFUL_STAFF_USE_6.method_1434()) {
                    currentCommand = this.commandList.method_10602(5).method_10558("Command5");
                    player.method_7353((class_2561)class_2561.method_43471((String)currentCommandKey).method_27693(currentCommand), true);
                }
            }
        }
        if (PowerfulStaffItem.hasBlocks(stack, ModItem.GAME_ICON) && entity.method_31747()) {
            player = (class_1657)entity;
            class_2487 nbtCompound = stack.method_7948();
            this.entityList = nbtCompound.method_10554("Absorbed", 10);
            if (!nbtCompound.method_10545("Absorbed") || nbtCompound.method_10545("Absorbed") && nbtCompound.method_10554("Absorbed", 10).isEmpty()) {
                if (nbtCompound.method_10545("Absorbed") && nbtCompound.method_10554("Absorbed", 10).isEmpty()) {
                    nbtCompound.method_10551("Absorbed");
                }
                nbtCompound.method_10566("Absorbed", (class_2520)new class_2499());
                this.entityList = new class_2499();
                this.index = 0;
                this.addPlaceholder(this.staff);
            }
            if (this.index >= 10) {
                this.index = 0;
            }
            if (!player.method_31549().field_7477) {
                if (player.method_6047().method_31574(ModItem.GAME_ICON) && currentMode == 1) {
                    player.method_31549().field_7478 = true;
                } else {
                    player.method_31549().field_7479 = false;
                    player.method_31549().field_7478 = false;
                }
            }
            if (AvMModClient.POWERFUL_STAFF_USE.method_1434()) {
                if (AvMModClient.POWERFUL_STAFF_USE_1.method_1434()) {
                    currentMode = 1;
                    player.method_7353((class_2561)class_2561.method_43471((String)"gui.avm_mod.game_icon_mode2"), true);
                } else if (AvMModClient.POWERFUL_STAFF_USE_2.method_1434()) {
                    currentMode = 2;
                    player.method_7353((class_2561)class_2561.method_43471((String)"gui.avm_mod.game_icon_mode3"), true);
                } else if (AvMModClient.POWERFUL_STAFF_USE_3.method_1434()) {
                    currentMode = 3;
                    player.method_7353((class_2561)class_2561.method_43471((String)"gui.avm_mod.game_icon_mode4"), true);
                }
            }
        }
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_2487 nbtCompound;
        if (PowerfulStaffItem.hasBlocks(user.method_6047(), class_1802.field_8866) && user.method_7338()) {
            if (AvMModClient.POWERFUL_STAFF_USE.method_1434()) {
                PowerfulStaffScreen screen = new PowerfulStaffScreen(this.staff);
                class_310.method_1551().method_29970((class_437)screen);
                screen.addPlayer(user);
                PowerfulStaffScreen.addCommands(bufferedCommands);
                nbtCompound = this.staff.method_7948();
                if (!nbtCompound.method_10545("Commands")) {
                    nbtCompound.method_10566("Commands", (class_2520)new class_2499());
                }
                this.commandList = nbtCompound.method_10554("Commands", 10);
                class_1271.method_22427((Object)user.method_6047());
            } else if (currentCommand != "" && !AvMModClient.POWERFUL_STAFF_USE.method_1434()) {
                if (currentCommand.startsWith("/")) {
                    String readyCommand = currentCommand.substring(1);
                    class_310.method_1551().field_1724.field_3944.method_45730(readyCommand);
                } else {
                    class_310.method_1551().field_1724.field_3944.method_45730(currentCommand);
                }
            }
        }
        if (PowerfulStaffItem.hasBlocks(user.method_6047(), ModItem.GAME_ICON) && currentMode == 3) {
            Random rand = new Random();
            nbtCompound = this.staff.method_7969();
            if (nbtCompound.method_10554("Absorbed", 10) != null) {
                class_2499 list = nbtCompound.method_10554("Absorbed", 10);
                for (int i = 0; i < 10; ++i) {
                    int m = this.entityList.method_10602(i).method_10550("Absorb" + i);
                    if (m == 1 || m == 2 || m == 3 || m == 4 || m == 5 || m == 6 || m == 7) {
                        class_1321 entity;
                        if (m == 1) {
                            entity = new DarkZombieEntity(ModEntities.DARK_ZOMBIE, world);
                            entity.method_23327(user.method_23317() + (double)rand.nextFloat(-3.0f, 3.0f), user.method_23318() + 1.0, user.method_23321() + (double)rand.nextFloat(-3.0f, 3.0f));
                            world.method_8649((class_1297)entity);
                            entity.method_6170(user);
                        }
                        if (m == 2) {
                            entity = new DarkSkeletonEntity(ModEntities.DARK_SKELETON, world);
                            entity.method_23327(user.method_23317() + (double)rand.nextFloat(-3.0f, 3.0f), user.method_23318() + 1.0, user.method_23321() + (double)rand.nextFloat(-3.0f, 3.0f));
                            world.method_8649((class_1297)entity);
                            entity.method_6122(entity.method_6058(), class_1802.field_8102.method_7854());
                            entity.method_6170(user);
                        }
                        if (m == 3) {
                            entity = new DarkCreeperEntity(ModEntities.DARK_CREEPER, world);
                            entity.method_23327(user.method_23317() + (double)rand.nextFloat(-3.0f, 3.0f), user.method_23318() + 1.0, user.method_23321() + (double)rand.nextFloat(-3.0f, 3.0f));
                            world.method_8649((class_1297)entity);
                            entity.method_6170(user);
                        }
                        if (m == 4) {
                            entity = new DarkSpiderEntity(ModEntities.DARK_SPIDER, world);
                            entity.method_23327(user.method_23317() + (double)rand.nextFloat(-3.0f, 3.0f), user.method_23318() + 1.0, user.method_23321() + (double)rand.nextFloat(-3.0f, 3.0f));
                            world.method_8649((class_1297)entity);
                            entity.method_6170(user);
                        }
                        if (m == 5) {
                            entity = new DarkEndermanEntity(ModEntities.DARK_ENDERMAN, world);
                            entity.method_23327(user.method_23317() + (double)rand.nextFloat(-3.0f, 3.0f), user.method_23318() + 1.0, user.method_23321() + (double)rand.nextFloat(-3.0f, 3.0f));
                            world.method_8649((class_1297)entity);
                            entity.method_6170(user);
                        }
                        if (m == 6) {
                            entity = new DarkPhantomEntity(ModEntities.DARK_PHANTOM, world);
                            entity.method_23327(user.method_23317() + (double)rand.nextFloat(-3.0f, 3.0f), user.method_23318() + 1.0, user.method_23321() + (double)rand.nextFloat(-3.0f, 3.0f));
                            world.method_8649((class_1297)entity);
                            entity.method_6170(user);
                        }
                        class_2487 placeholder = new class_2487();
                        placeholder.method_10569("Absorb" + i, 0);
                        list.method_10606(i, (class_2520)placeholder);
                        this.remains = 10;
                        this.index = 0;
                        continue;
                    }
                    user.method_7353((class_2561)class_2561.method_43471((String)"gui.avm_mod.fail_summon_empty"), true);
                }
            }
        }
        user.method_7357().method_7906((class_1792)this, this.getUseDuration(user.method_5998(hand)));
        return class_1271.method_22431((Object)user.method_6047());
    }

    public int getUseDuration(class_1799 itemStack) {
        return 30;
    }

    public class_1269 method_7847(class_1799 stack, class_1657 user, class_1309 entity, class_1268 hand) {
        if (PowerfulStaffItem.hasBlocks(stack, ModItem.GAME_ICON) && currentMode == 2) {
            class_2487 nbtCompound = this.staff.method_7948();
            this.entityList = nbtCompound.method_10554("Absorbed", 10);
            if (this.remains > 0) {
                --this.remains;
                class_2499 list = nbtCompound.method_10554("Absorbed", 10);
                absorpedEntities = new ArrayList();
                if (entity instanceof class_1642) {
                    absorpedEntities.add(1);
                    this.addMob(this.staff, 1, user);
                    entity.method_31472();
                    user.method_7353((class_2561)class_2561.method_43471((String)"gui.avm_mod.absorped").method_10852(entity.method_5476()).method_10852((class_2561)class_2561.method_43471((String)"gui.avm_mod.remain").method_27693(String.valueOf(this.remains))), true);
                } else if (entity instanceof class_1613) {
                    absorpedEntities.add(2);
                    this.addMob(this.staff, 2, user);
                    entity.method_31472();
                    user.method_7353((class_2561)class_2561.method_43471((String)"gui.avm_mod.absorped").method_10852(entity.method_5476()).method_10852((class_2561)class_2561.method_43471((String)"gui.avm_mod.remain").method_27693(String.valueOf(this.remains))), true);
                } else if (entity instanceof class_1548) {
                    absorpedEntities.add(3);
                    this.addMob(this.staff, 3, user);
                    entity.method_31472();
                    user.method_7353((class_2561)class_2561.method_43471((String)"gui.avm_mod.absorped").method_10852(entity.method_5476()).method_10852((class_2561)class_2561.method_43471((String)"gui.avm_mod.remain").method_27693(String.valueOf(this.remains))), true);
                } else if (entity instanceof class_1593) {
                    absorpedEntities.add(6);
                    this.addMob(this.staff, 6, user);
                    entity.method_31472();
                    user.method_7353((class_2561)class_2561.method_43471((String)"gui.avm_mod.absorped").method_10852(entity.method_5476()).method_10852((class_2561)class_2561.method_43471((String)"gui.avm_mod.remain").method_27693(String.valueOf(this.remains))), true);
                } else if (entity instanceof class_1628) {
                    absorpedEntities.add(4);
                    this.addMob(this.staff, 4, user);
                    entity.method_31472();
                    user.method_7353((class_2561)class_2561.method_43471((String)"gui.avm_mod.absorped").method_10852(entity.method_5476()).method_10852((class_2561)class_2561.method_43471((String)"gui.avm_mod.remain").method_27693(String.valueOf(this.remains))), true);
                } else if (entity instanceof class_1560) {
                    absorpedEntities.add(5);
                    this.addMob(this.staff, 5, user);
                    entity.method_31472();
                    user.method_7353((class_2561)class_2561.method_43471((String)"gui.avm_mod.absorped").method_10852(entity.method_5476()).method_10852((class_2561)class_2561.method_43471((String)"gui.avm_mod.remain").method_27693(String.valueOf(this.remains))), true);
                } else {
                    ++this.remains;
                    --this.index;
                    user.method_7353((class_2561)class_2561.method_43471((String)"gui.avm_mod.cant_absorp"), true);
                    return class_1269.field_5814;
                }
            }
        }
        user.method_7357().method_7906((class_1792)this, this.getUseDuration(user.method_5998(hand)));
        return class_1269.field_5814;
    }

    private ParseResults<class_2168> parse(String command, class_1657 player) {
        MinecraftServer server = player.method_5682();
        CommandDispatcher commandDispatcher = server.method_3734().method_9235();
        return commandDispatcher.parse(command, (Object)player.method_5671());
    }

    private static Optional<class_1799> removeFirstStack(class_1799 stack) {
        class_2487 nbtCompound = stack.method_7948();
        if (!nbtCompound.method_10545(ITEMS_KEY)) {
            return Optional.empty();
        }
        PowerfulStaffItem.setBlocked(stack, false);
        class_2499 nbtList = nbtCompound.method_10554(ITEMS_KEY, 10);
        if (nbtList.isEmpty()) {
            return Optional.empty();
        }
        boolean i = false;
        class_2487 nbtCompound2 = nbtList.method_10602(0);
        class_1799 itemStack = class_1799.method_7915((class_2487)nbtCompound2);
        nbtList.method_10536(0);
        if (nbtList.isEmpty()) {
            stack.method_7983(ITEMS_KEY);
        }
        return Optional.of(itemStack);
    }

    private Optional<class_1799> createCommands(class_1799 stack) {
        class_2487 nbtCompound = stack.method_7948();
        class_2487 placeholder = new class_2487();
        placeholder.method_10582("", "");
        class_2499 list = nbtCompound.method_10554("Commands", 10);
        class_2487 nbtCompound2 = list.method_10602(0);
        class_1799 itemStack = class_1799.method_7915((class_2487)nbtCompound2);
        for (int i = 0; i < 6; ++i) {
            String command = bufferedCommands.get(i);
            if (command == null) continue;
            class_2487 nbtCompound3 = new class_2487();
            nbtCompound3.method_10582("Command" + i, command);
            this.commandList.add((Object)placeholder);
            this.commandList.method_10606(i, (class_2520)nbtCompound3);
            if (this.commandList.size() <= 6) continue;
            for (int j = 6; j < this.commandList.size(); ++j) {
                this.commandList.method_10536(j);
            }
        }
        return Optional.of(itemStack);
    }

    private Optional<class_1799> addMob(class_1799 stack, int mobIndex, class_1657 player) {
        class_2487 nbtCompound = stack.method_7948();
        class_2499 list = nbtCompound.method_10554("Absorbed", 10);
        class_2487 nbtCompound2 = list.method_10602(0);
        class_1799 itemStack = class_1799.method_7915((class_2487)nbtCompound2);
        if (list.size() <= 10 && this.index < 10 && this.index >= 0) {
            class_2487 nbtCompound3 = new class_2487();
            nbtCompound3.method_10569("Absorb" + this.index, mobIndex);
            list.method_10606(this.index, (class_2520)nbtCompound3);
            this.entityList = list;
            ++this.index;
        } else {
            player.method_7353((class_2561)class_2561.method_43471((String)"gui.avm_mod.limit"), true);
        }
        return Optional.of(itemStack);
    }

    private Optional<class_1799> addPlaceholder(class_1799 stack) {
        class_2487 nbtCompound = stack.method_7948();
        class_2499 list = nbtCompound.method_10554("Absorbed", 10);
        class_2487 nbtCompound2 = list.method_10602(0);
        class_1799 itemStack = class_1799.method_7915((class_2487)nbtCompound2);
        for (int i = 0; i < 10; ++i) {
            class_2487 placeholder = new class_2487();
            placeholder.method_10569("Absorb" + i, 0);
            list.add((Object)placeholder);
            if (list.size() > 10) {
                for (int j = 10; j < list.size(); ++j) {
                    list.method_10536(j);
                }
            }
            this.entityList = list;
        }
        return Optional.of(itemStack);
    }

    public void commands(String command1, String command2, String command3, String command4, String command5, String command6) {
        bufferedCommands = new ArrayList<String>();
        bufferedCommands.add(0, command1);
        bufferedCommands.add(1, command2);
        bufferedCommands.add(2, command3);
        bufferedCommands.add(3, command4);
        bufferedCommands.add(4, command5);
        bufferedCommands.add(5, command6);
        this.createCommands(this.staff);
    }

    public boolean method_31566(class_1799 stack, class_1799 otherStack, class_1735 slot, class_5536 clickType, class_1657 player, class_5630 cursorStackReference) {
        if (clickType != class_5536.field_27014 || !slot.method_32754(player)) {
            return false;
        }
        if (otherStack.method_7960()) {
            PowerfulStaffItem.removeFirstStack(stack).ifPresent(itemStack -> {
                this.playRemoveOneSound((class_1297)player);
                cursorStackReference.method_32332(itemStack);
            });
        } else {
            int i = PowerfulStaffItem.addToBundle(stack, otherStack);
            if (i > 0) {
                this.playInsertSound((class_1297)player);
                otherStack.method_7934(i);
            }
        }
        return true;
    }

    private static int addToBundle(class_1799 bundle, class_1799 stack) {
        if (stack.method_7960() || !stack.method_7909().method_31568()) {
            return 0;
        }
        class_2487 nbtCompound = bundle.method_7948();
        if (!nbtCompound.method_10545(ITEMS_KEY)) {
            nbtCompound.method_10566(ITEMS_KEY, (class_2520)new class_2499());
        }
        int i = PowerfulStaffItem.getBundleOccupancy(bundle);
        int j = PowerfulStaffItem.getItemOccupancy(stack);
        int k = Math.min(stack.method_7947(), (1 - i) / j);
        if (k == 0) {
            return 0;
        }
        class_2499 nbtList = nbtCompound.method_10554(ITEMS_KEY, 10);
        Optional<class_2487> optional = PowerfulStaffItem.canMergeStack(stack, nbtList);
        if (optional.isPresent()) {
            class_2487 nbtCompound2 = optional.get();
            class_1799 itemStack = class_1799.method_7915((class_2487)nbtCompound2);
            itemStack.method_7933(k);
            itemStack.method_7953(nbtCompound2);
            nbtList.remove((Object)nbtCompound2);
            nbtList.method_10531(0, (class_2520)nbtCompound2);
        } else {
            class_1799 itemStack2 = stack.method_46651(k);
            class_2487 nbtCompound3 = new class_2487();
            itemStack2.method_7953(nbtCompound3);
            nbtList.method_10531(0, (class_2520)nbtCompound3);
        }
        return k;
    }

    private static int getItemOccupancy(class_1799 stack) {
        class_2487 nbtCompound;
        if (stack.method_31574(class_1802.field_27023)) {
            return 4 + PowerfulStaffItem.getBundleOccupancy(stack);
        }
        if ((stack.method_31574(class_1802.field_20416) || stack.method_31574(class_1802.field_20415)) && stack.method_7985() && (nbtCompound = class_1747.method_38072((class_1799)stack)) != null && !nbtCompound.method_10554("Bees", 10).isEmpty()) {
            return 1;
        }
        return 64 / stack.method_7914();
    }

    public Optional<class_5632> method_32346(class_1799 stack) {
        class_2371 defaultedList = class_2371.method_10211();
        PowerfulStaffItem.getBundledStacks(stack).forEach(arg_0 -> defaultedList.add(arg_0));
        return Optional.of(new class_5631(defaultedList, PowerfulStaffItem.getBundleOccupancy(stack)));
    }

    private static Optional<class_2487> canMergeStack(class_1799 stack, class_2499 items) {
        if (stack.method_31574(class_1802.field_27023)) {
            return Optional.empty();
        }
        return items.stream().filter(class_2487.class::isInstance).map(class_2487.class::cast).filter(item -> class_1799.method_31577((class_1799)class_1799.method_7915((class_2487)item), (class_1799)stack)).findFirst();
    }

    private static int getBundleOccupancy(class_1799 stack) {
        return PowerfulStaffItem.getBundledStacks(stack).mapToInt(itemStack -> PowerfulStaffItem.getItemOccupancy(itemStack) * itemStack.method_7947()).sum();
    }

    public static Stream<class_1799> getBundledStacks(class_1799 stack) {
        class_2487 nbtCompound = stack.method_7969();
        if (nbtCompound == null) {
            return Stream.empty();
        }
        class_2499 nbtList = nbtCompound.method_10554(ITEMS_KEY, 10);
        return nbtList.stream().map(class_2487.class::cast).map(class_1799::method_7915);
    }

    private void playRemoveOneSound(class_1297 entity) {
        entity.method_5783(class_3417.field_34377, 0.8f, 0.8f + entity.method_37908().method_8409().method_43057() * 0.4f);
    }

    private void playInsertSound(class_1297 entity) {
        entity.method_5783(class_3417.field_34376, 0.8f, 0.8f + entity.method_37908().method_8409().method_43057() * 0.4f);
    }

    private static List<class_1799> getBlocks(class_1799 staff) {
        class_2499 nbtList;
        ArrayList list = Lists.newArrayList();
        class_2487 nbtCompound = staff.method_7969();
        if (nbtCompound != null && nbtCompound.method_10573(ITEMS_KEY, 9) && (nbtList = nbtCompound.method_10554(ITEMS_KEY, 10)) != null) {
            for (int i = 0; i < nbtList.size(); ++i) {
                class_2487 nbtCompound2 = nbtList.method_10602(i);
                list.add(class_1799.method_7915((class_2487)nbtCompound2));
            }
        }
        return list;
    }

    public static boolean hasBlocks(class_1799 staff, class_1792 block) {
        return PowerfulStaffItem.getBlocks(staff).stream().anyMatch(s -> s.method_31574(block));
    }

    public static boolean isBlocked(class_1799 stack) {
        class_2487 nbtCompound = stack.method_7969();
        return nbtCompound != null && nbtCompound.method_10577(BLOCKED_KEY);
    }

    public static void setBlocked(class_1799 stack, boolean blocked) {
        class_2487 nbtCompound = stack.method_7948();
        nbtCompound.method_10556(BLOCKED_KEY, blocked);
        if (!nbtCompound.method_10577(BLOCKED_KEY)) {
            nbtCompound.method_10551(BLOCKED_KEY);
        }
    }

    public static int muliplicate(class_1799 stack) {
        if (PowerfulStaffItem.hasBlocks(stack, class_1802.field_27071)) {
            return 1;
        }
        if (PowerfulStaffItem.hasBlocks(stack, class_1802.field_8773)) {
            return 2;
        }
        if (PowerfulStaffItem.hasBlocks(stack, class_1802.field_8494)) {
            return 3;
        }
        if (PowerfulStaffItem.hasBlocks(stack, class_1802.field_8733)) {
            return 4;
        }
        if (PowerfulStaffItem.hasBlocks(stack, class_1802.field_8603)) {
            return 5;
        }
        if (PowerfulStaffItem.hasBlocks(stack, class_1802.field_22018)) {
            return 7;
        }
        if (PowerfulStaffItem.hasBlocks(stack, class_1802.field_8866)) {
            return 11;
        }
        if (PowerfulStaffItem.hasBlocks(stack, ModItem.GAME_ICON)) {
            return 13;
        }
        return 0;
    }
}

