/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.spelunkingsecrets.init;

import net.mcreator.spelunkingsecrets.entity.BabySpiderEntity;
import net.mcreator.spelunkingsecrets.entity.MinerZombieEntity;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.SpawnPlacementRegisterEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class SpelunkingSecretsModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"spelunking_secrets");
    public static final DeferredHolder<EntityType<?>, EntityType<BabySpiderEntity>> BABY_SPIDER = SpelunkingSecretsModEntities.register("baby_spider", EntityType.Builder.of(BabySpiderEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.5f, 0.4f));
    public static final DeferredHolder<EntityType<?>, EntityType<MinerZombieEntity>> MINER_ZOMBIE = SpelunkingSecretsModEntities.register("miner_zombie", EntityType.Builder.of(MinerZombieEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.8f));

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.build(registryname));
    }

    @SubscribeEvent
    public static void init(SpawnPlacementRegisterEvent event) {
        BabySpiderEntity.init(event);
        MinerZombieEntity.init(event);
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)BABY_SPIDER.get(), BabySpiderEntity.createAttributes().build());
        event.put((EntityType)MINER_ZOMBIE.get(), MinerZombieEntity.createAttributes().build());
    }
}

