/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.geore.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.shynieke.geore.config.GeOreConfig;
import com.shynieke.geore.item.GeoreSpyglassItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class SpyglassHandler {
    @SubscribeEvent
    public void onOverlayRender(RenderGuiOverlayEvent.Pre event) {
        Item item;
        if (!event.getOverlay().id().equals((Object)new ResourceLocation("spyglass"))) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        PoseStack poseStack = event.getPoseStack();
        if (player != null && minecraft.f_91066_.m_92176_().m_90612_() && player.m_6117_() && (item = player.m_21211_().m_41720_()) instanceof GeoreSpyglassItem) {
            GeoreSpyglassItem georeSpyglassItem = (GeoreSpyglassItem)item;
            int color = georeSpyglassItem.getOverlayHex();
            RenderSystem.m_69478_();
            this.fillGradient(poseStack, minecraft.m_91268_().m_85445_(), minecraft.m_91268_().m_85446_(), color, color);
            RenderSystem.m_69453_();
        }
    }

    protected void fillGradient(PoseStack poseStack, int width, int height, int color1, int color2) {
        SpyglassHandler.fillGradient(poseStack, width, height, color1, color2, ((Double)GeOreConfig.CLIENT.spyglassIntensity.get()).floatValue());
    }

    protected static void fillGradient(PoseStack poseStack, int width, int height, int color1, int color2, float intensity) {
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        SpyglassHandler.fillGradient(poseStack.m_85850_().m_85861_(), bufferbuilder, width, height, color1, color2, intensity);
        tesselator.m_85914_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected static void fillGradient(Matrix4f matrix4f, BufferBuilder builder, int width, int height, int color1, int color2, float intensity) {
        float f1 = (float)(color1 >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(color1 >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(color1 & 0xFF) / 255.0f;
        float f5 = (float)(color2 >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(color2 >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(color2 & 0xFF) / 255.0f;
        builder.m_85982_(matrix4f, (float)width, 0.0f, 0.0f).m_85950_(f1, f2, f3, intensity).m_5752_();
        builder.m_85982_(matrix4f, 0.0f, 0.0f, 0.0f).m_85950_(f1, f2, f3, intensity).m_5752_();
        builder.m_85982_(matrix4f, 0.0f, (float)height, 0.0f).m_85950_(f5, f6, f7, intensity).m_5752_();
        builder.m_85982_(matrix4f, (float)width, (float)height, 0.0f).m_85950_(f5, f6, f7, intensity).m_5752_();
    }
}

