/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.geore.config;

import com.shynieke.geore.GeOre;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.apache.commons.lang3.tuple.Pair;

public class GeOreConfig {
    public static final ForgeConfigSpec clientSpec;
    public static final Client CLIENT;
    public static final ForgeConfigSpec commonSpec;
    public static final Common COMMON;

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading configEvent) {
        GeOre.LOGGER.debug("Loaded GeOre's enabledConfig file {}", (Object)configEvent.getConfig().getFileName());
    }

    @SubscribeEvent
    public static void onFileChange(ModConfigEvent.Reloading configEvent) {
        GeOre.LOGGER.debug("GeOre's enabledConfig just got changed on the file system!");
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Client::new);
        clientSpec = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (Client)specPair.getLeft();
        specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        commonSpec = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Client {
        public final ForgeConfigSpec.DoubleValue spyglassIntensity;

        Client(ForgeConfigSpec.Builder builder) {
            builder.comment("Client settings").push("Client");
            this.spyglassIntensity = builder.comment("The intensity of the spyglass color overlay (0.5 = 50%) [Default: 0.5]").defineInRange("spyglassIntensity", 0.5, 0.01, 1.0);
            builder.pop();
        }
    }

    public static class Common {
        public final ForgeConfigSpec.BooleanValue generateCoalGeore;
        public final ForgeConfigSpec.BooleanValue generateCopperGeore;
        public final ForgeConfigSpec.BooleanValue generateDiamondGeore;
        public final ForgeConfigSpec.BooleanValue generateEmeraldGeore;
        public final ForgeConfigSpec.BooleanValue generateGoldGeore;
        public final ForgeConfigSpec.BooleanValue generateIronGeore;
        public final ForgeConfigSpec.BooleanValue generateLapisGeore;
        public final ForgeConfigSpec.BooleanValue generateQuartzGeore;
        public final ForgeConfigSpec.BooleanValue generateQuartzInNetherGeore;
        public final ForgeConfigSpec.BooleanValue generateRedstoneGeore;
        public final ForgeConfigSpec.BooleanValue generateRubyGeore;
        public final ForgeConfigSpec.BooleanValue generateSapphireGeore;
        public final ForgeConfigSpec.BooleanValue generateTopazGeore;
        public final ForgeConfigSpec.BooleanValue generateZincGeore;

        Common(ForgeConfigSpec.Builder builder) {
            builder.comment("General settings").push("General");
            this.generateCoalGeore = builder.comment("Generate Coal GeOre [Default: true]").define("generateCoalGeore", true);
            this.generateCopperGeore = builder.comment("Generate Copper GeOre [Default: true]").define("generateCopperGeore", true);
            this.generateDiamondGeore = builder.comment("Generate Diamond GeOre [Default: true]").define("generateDiamondGeore", true);
            this.generateEmeraldGeore = builder.comment("Generate Emerald GeOre [Default: true]").define("generateEmeraldGeore", true);
            this.generateGoldGeore = builder.comment("Generate Gold GeOre [Default: true]").define("generateGoldGeore", true);
            this.generateIronGeore = builder.comment("Generate Iron GeOre [Default: true]").define("generateIronGeore", true);
            this.generateLapisGeore = builder.comment("Generate Lapis GeOre [Default: true]").define("generateLapisGeore", true);
            this.generateQuartzGeore = builder.comment("Generate Quartz GeOre [Default: true]").define("generateQuartzGeore", true);
            this.generateQuartzInNetherGeore = builder.comment("Generate Quartz GeOre in the Nether [Default: true]").define("generateQuartzInNetherGeore", true);
            this.generateRedstoneGeore = builder.comment("Generate Redstone GeOre [Default: true]").define("generateRedstoneGeore", true);
            builder.pop();
            builder.comment("Modded Generation settings").push("ModdedGeneration");
            this.generateRubyGeore = builder.comment("Generate Ruby GeOre [Default: false]").define("generateRubyGeore", false);
            this.generateSapphireGeore = builder.comment("Generate Sapphire GeOre [Default: false]").define("generateSapphireGeore", false);
            this.generateTopazGeore = builder.comment("Generate Topaz GeOre [Default: false]").define("generateTopazGeore", false);
            this.generateZincGeore = builder.comment("Generate Zinc GeOre [Default: false]").define("generateZincGeore", false);
            builder.pop();
        }
    }
}

