/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.geore.features;

import com.shynieke.geore.config.GeOreConfig;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public enum ConfigFeature {
    FALSE("invalid", () -> false),
    COAL_GEORE("coal", (Supplier<Boolean>)GeOreConfig.COMMON.generateCoalGeore),
    COPPER_GEORE("copper", (Supplier<Boolean>)GeOreConfig.COMMON.generateCopperGeore),
    DIAMOND_GEORE("diamond", (Supplier<Boolean>)GeOreConfig.COMMON.generateDiamondGeore),
    EMERALD_GEORE("emerald", (Supplier<Boolean>)GeOreConfig.COMMON.generateEmeraldGeore),
    GOLD_GEORE("gold", (Supplier<Boolean>)GeOreConfig.COMMON.generateGoldGeore),
    IRON_GEORE("iron", (Supplier<Boolean>)GeOreConfig.COMMON.generateIronGeore),
    LAPIS_GEORE("lapis", (Supplier<Boolean>)GeOreConfig.COMMON.generateLapisGeore),
    QUARTZ_GEORE("quartz", (Supplier<Boolean>)GeOreConfig.COMMON.generateQuartzGeore),
    QUARTZ_NETHER_GEORE("quartz_nether", (Supplier<Boolean>)GeOreConfig.COMMON.generateQuartzInNetherGeore),
    REDSTONE_GEORE("redstone", (Supplier<Boolean>)GeOreConfig.COMMON.generateRedstoneGeore),
    RUBY_GEORE("ruby", (Supplier<Boolean>)GeOreConfig.COMMON.generateRubyGeore),
    SAPPHIRE_GEORE("sapphire", (Supplier<Boolean>)GeOreConfig.COMMON.generateSapphireGeore),
    TOPAZ_GEORE("topaz", (Supplier<Boolean>)GeOreConfig.COMMON.generateTopazGeore),
    ZINC_GEORE("zinc", (Supplier<Boolean>)GeOreConfig.COMMON.generateZincGeore);

    public final String name;
    public final Supplier<Boolean> configValue;

    private ConfigFeature(String name, Supplier<Boolean> configValue) {
        this.name = name;
        this.configValue = configValue;
    }

    public boolean getValue() {
        return this.configValue.get();
    }

    @Nullable
    public static ConfigFeature getByName(@Nullable String value) {
        for (ConfigFeature captcha : ConfigFeature.values()) {
            if (!captcha.name.equals(value)) continue;
            return captcha;
        }
        return FALSE;
    }
}

