/*
 * Decompiled with CFR 0.152.
 */
package com.alekiponi.alekiships.client;

import com.alekiponi.alekiships.common.entity.vehiclehelper.compartment.CompartmentCloneable;
import com.alekiponi.alekiships.network.PacketHandler;
import com.alekiponi.alekiships.network.ServerBoundPickCompartmentPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="alekiships", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public final class ClientEvents {
    @SubscribeEvent
    public static void onClickInput(InputEvent.InteractionKeyMappingTriggered event) {
        if (!event.isPickBlock()) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91077_ == null) {
            return;
        }
        if (minecraft.f_91074_ == null) {
            return;
        }
        if (minecraft.f_91072_ == null) {
            return;
        }
        if (!minecraft.f_91074_.m_150110_().f_35937_) {
            return;
        }
        if (!Screen.m_96637_()) {
            return;
        }
        if (minecraft.f_91077_.m_6662_() != HitResult.Type.ENTITY) {
            return;
        }
        Entity entity = ((EntityHitResult)minecraft.f_91077_).m_82443_();
        ItemStack pickResult = entity.getPickedResult(minecraft.f_91077_);
        if (pickResult.m_41619_()) {
            return;
        }
        if (!(entity instanceof CompartmentCloneable)) {
            return;
        }
        CompartmentCloneable compartment = (CompartmentCloneable)entity;
        ClientEvents.addNBTData(pickResult, compartment);
        Inventory inventory = minecraft.f_91074_.m_150109_();
        inventory.m_36012_(pickResult);
        PacketHandler.send(PacketDistributor.SERVER.noArg(), new ServerBoundPickCompartmentPacket(entity.m_19879_(), minecraft.f_91074_.m_21205_(), 36 + inventory.f_35977_));
        event.setCanceled(true);
    }

    private static void addNBTData(ItemStack itemStack, CompartmentCloneable compartment) {
        itemStack.m_41700_("BlockEntityTag", (Tag)compartment.saveForItemStack());
        CompoundTag compoundTag = new CompoundTag();
        ListTag listtag = new ListTag();
        listtag.add((Object)StringTag.m_129297_((String)"\"(+NBT)\""));
        compoundTag.m_128365_("Lore", (Tag)listtag);
        itemStack.m_41700_("display", (Tag)compoundTag);
    }
}

