/*
 * Decompiled with CFR 0.152.
 */
package com.alekiponi.alekiships.common.block;

import com.alekiponi.alekiships.common.block.AngledBoatFrameBlock;
import com.alekiponi.alekiships.common.block.AngledWoodenBoatFrameBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;

public abstract class AbstractHullSideBlock
extends HorizontalDirectionalBlock
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    protected AbstractHullSideBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public static boolean isSupportedByWatercraftFrame(LevelReader pLevel, BlockPos thispos) {
        if (!(pLevel.m_8055_(thispos.m_7495_()).m_60734_() instanceof AngledWoodenBoatFrameBlock) && !(pLevel.m_8055_(thispos.m_7495_()).m_60734_() instanceof AngledBoatFrameBlock)) {
            return false;
        }
        return AngledBoatFrameBlock.ConstantShape.getConstantShape(pLevel.m_8055_(thispos.m_7495_())) == AngledBoatFrameBlock.ConstantShape.INNER || AngledBoatFrameBlock.ConstantShape.getConstantShape(pLevel.m_8055_(thispos.m_7495_())) == AngledBoatFrameBlock.ConstantShape.STRAIGHT;
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        return AbstractHullSideBlock.isSupportedByWatercraftFrame(pLevel, pPos);
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        Direction direction = pContext.m_43719_();
        BlockPos blockpos = pContext.m_8083_();
        FluidState fluidstate = pContext.m_43725_().m_6425_(blockpos);
        Level level = pContext.m_43725_();
        BlockState blockstate = (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)pContext.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
        if (level.m_8055_(blockpos.m_7495_()).m_60734_() instanceof AngledWoodenBoatFrameBlock || level.m_8055_(blockpos.m_7495_()).m_60734_() instanceof AngledBoatFrameBlock) {
            Direction[] directions = AngledBoatFrameBlock.getSolid(level.m_8055_(blockpos.m_7495_()));
            if (directions.length == 0) {
                return blockstate;
            }
            for (Direction dir : directions) {
                if (dir == pContext.m_8125_().m_122424_()) {
                    return blockstate;
                }
                if (dir != pContext.m_8125_()) continue;
                return (BlockState)blockstate.m_61124_((Property)FACING, (Comparable)pContext.m_8125_());
            }
            blockstate = (BlockState)blockstate.m_61124_((Property)FACING, (Comparable)directions[0]);
        }
        return blockstate;
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{FACING, WATERLOGGED});
    }

    public FluidState m_5888_(BlockState blockState) {
        return (Boolean)blockState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(blockState);
    }

    public boolean m_7923_(BlockState pState) {
        return true;
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        return !pState.m_60710_((LevelReader)pLevel, pCurrentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }
}

