/*
 * Decompiled with CFR 0.152.
 */
package com.alekiponi.alekiships.common.entity;

import com.alekiponi.alekiships.common.entity.CannonballEntity;
import com.alekiponi.alekiships.common.item.AlekiShipsItems;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;

public class CannonEntity
extends Entity {
    public static final byte EVENT_LIGHT = 10;
    public static final String FUSE_KEY = "Fuse";
    public static final String CANNONBALL_KEY = "Cannonball";
    public static final String DAMAGE_KEY = "Damage";
    protected static final EntityDataAccessor<Float> DATA_ID_DAMAGE = SynchedEntityData.m_135353_(CannonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<ItemStack> DATA_ID_CANNONBALL_ITEM = SynchedEntityData.m_135353_(CannonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<Float> DATA_ID_X_ROT = SynchedEntityData.m_135353_(CannonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final ItemStack CANNONBALL = new ItemStack((ItemLike)AlekiShipsItems.CANNONBALL.get());
    private static final float DAMAGE_TO_BREAK = 8.0f;
    private static final float DAMAGE_RECOVERY = 0.5f;
    protected int lerpSteps;
    protected double lerpX;
    protected double lerpY;
    protected double lerpZ;
    protected double lerpYRot;
    protected double lerpXRot;
    private int recentlyFired;
    private int fuse = -1;
    @Nullable
    private LivingEntity igniter;

    public CannonEntity(EntityType<? extends CannonEntity> entityType, Level level) {
        super(entityType, level);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_ID_DAMAGE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_ID_CANNONBALL_ITEM, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(DATA_ID_X_ROT, (Object)Float.valueOf(0.0f));
    }

    protected void m_7378_(CompoundTag compoundTag) {
        this.fuse = compoundTag.m_128451_(FUSE_KEY);
        this.setCannonball(ItemStack.m_41712_((CompoundTag)compoundTag.m_128469_(CANNONBALL_KEY)));
        this.setDamage(compoundTag.m_128457_(DAMAGE_KEY));
    }

    protected void m_7380_(CompoundTag compoundTag) {
        compoundTag.m_128405_(FUSE_KEY, this.fuse);
        compoundTag.m_128365_(CANNONBALL_KEY, (Tag)this.getCannonball().m_41739_(new CompoundTag()));
        compoundTag.m_128350_(DAMAGE_KEY, this.getDamage());
    }

    public void m_8119_() {
        if (this.recentlyFired > 0) {
            --this.recentlyFired;
        }
        if (this.f_19797_ <= 1) {
            this.fuse = -1;
        }
        if (!this.m_20159_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.04, 0.0));
            if (this.m_20069_()) {
                this.m_20334_(0.0, -0.01, 0.0);
                if (!this.m_20096_()) {
                    this.m_146922_(this.m_146908_() + 0.4f);
                }
            }
            if (!this.m_20096_() || this.m_20184_().m_165925_() > (double)1.0E-5f || (this.f_19797_ + this.m_19879_()) % 4 == 0) {
                this.m_20101_();
                this.m_6478_(MoverType.SELF, this.m_20184_());
                float f1 = 0.8f;
                this.m_20256_(this.m_20184_().m_82542_((double)f1, 0.98, (double)f1));
                if (this.m_20096_()) {
                    Vec3 vec31 = this.m_20184_();
                    if (vec31.f_82480_ < 0.0) {
                        this.m_20256_(vec31.m_82542_(1.0, -0.5, 1.0));
                    }
                }
            }
            this.m_20073_();
        }
        this.tickLerp();
        if (this.getDamage() > 0.0f) {
            this.setDamage(this.getDamage() - 0.5f);
        }
        if (this.fuse > 0) {
            --this.fuse;
            Vec3 fuse = new Vec3((double)Mth.m_14031_((float)((float)((double)(-this.m_146908_()) * (Math.PI / 180)))) * 0.5, 0.8, (double)Mth.m_14089_((float)((float)((double)this.m_146908_() * (Math.PI / 180)))) * 0.5).m_82542_(-1.0, 1.0, -1.0).m_82549_(this.m_20318_(0.0f));
            Vec3 deltaMovement = this.m_20201_().m_20184_();
            this.m_9236_().m_7107_((ParticleOptions)ParticleTypes.f_123744_, fuse.f_82479_, fuse.f_82480_, fuse.f_82481_, deltaMovement.f_82479_, 0.01, deltaMovement.f_82481_);
            this.m_9236_().m_7107_((ParticleOptions)ParticleTypes.f_123744_, fuse.f_82479_, fuse.f_82480_, fuse.f_82481_, deltaMovement.f_82479_, 0.01, deltaMovement.f_82481_);
        } else if (this.fuse == 0) {
            this.fire();
            this.recentlyFired = 60;
        }
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        ItemStack heldItem = player.m_21120_(hand);
        InteractionResult insertResult = this.insertItem(heldItem);
        if (insertResult.m_19077_()) {
            return insertResult;
        }
        if (this.isLoaded() && heldItem.m_150930_(Items.f_42409_)) {
            if (this.isLit()) {
                return InteractionResult.FAIL;
            }
            this.light((LivingEntity)player);
            player.m_6674_(hand);
            heldItem.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
            return InteractionResult.SUCCESS;
        }
        if (heldItem.m_150930_(Items.f_42409_)) {
            return InteractionResult.FAIL;
        }
        if (player.m_36341_() && this.m_146909_() < 20.0f) {
            this.m_146926_(this.m_146909_() + 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (this.m_146909_() > -20.0f) {
            this.m_146926_(this.m_146909_() - 1.0f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    protected InteractionResult insertItem(ItemStack itemStack) {
        if (itemStack.m_150930_((Item)AlekiShipsItems.CANNONBALL.get())) {
            if (this.getCannonball().m_41619_()) {
                this.setCannonball(itemStack.m_41620_(1));
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public void light(@Nullable LivingEntity igniter) {
        if (this.m_20069_()) {
            return;
        }
        this.igniter = igniter;
        this.fuse = 40;
        if (!this.m_9236_().m_5776_()) {
            this.m_9236_().m_7605_((Entity)this, (byte)10);
            if (!this.m_20067_()) {
                this.m_5496_(SoundEvents.f_12512_, 1.5f, this.m_9236_().m_213780_().m_188501_() * 0.05f + 0.91f);
            }
        }
    }

    public void fire() {
        this.fuse = -1;
        this.setCannonball(ItemStack.f_41583_);
        this.m_5496_(SoundEvents.f_11913_, 1.5f, this.m_9236_().m_213780_().m_188501_() * 0.05f + 0.01f);
        CannonballEntity cannonball = new CannonballEntity(this);
        cannonball.m_146884_(this.m_20182_());
        this.m_9236_().m_7967_((Entity)cannonball);
        Vec3 movement = new Vec3((double)Mth.m_14031_((float)(-this.m_146908_() * ((float)Math.PI / 180))) * 0.04, this.m_20184_().f_82480_, (double)Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))) * 0.04).m_82542_(-1.0, 1.0, -1.0);
        this.m_20256_(this.m_20184_().m_82549_(movement));
    }

    /*
     * Unable to fully structure code
     */
    public boolean m_6469_(DamageSource damageSource, float amount) {
        if (this.m_6673_(damageSource)) {
            return false;
        }
        if (this.m_9236_().f_46443_ || this.m_213877_()) {
            return true;
        }
        this.setDamage(this.getDamage() + amount * 10.0f);
        this.m_5834_();
        this.m_146852_(GameEvent.f_223706_, damageSource.m_7639_());
        var5_3 = damageSource.m_7639_();
        if (!(var5_3 instanceof Player)) ** GOTO lbl-1000
        player = (Player)var5_3;
        if (player.m_150110_().f_35937_) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = instantKill = false;
        }
        if (instantKill) {
            this.m_6074_();
        } else if (this.getDamage() > 8.0f) {
            this.destroy(damageSource);
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
        return true;
    }

    public boolean m_6673_(DamageSource damageSource) {
        if (damageSource.m_269533_(DamageTypeTags.f_268415_)) {
            return true;
        }
        return super.m_6673_(damageSource);
    }

    protected void tickLerp() {
        if (this.m_6109_()) {
            this.lerpSteps = 0;
            this.m_217006_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        }
        if (this.lerpSteps > 0) {
            double d0 = this.m_20185_() + (this.lerpX - this.m_20185_()) / (double)this.lerpSteps;
            double d1 = this.m_20186_() + (this.lerpY - this.m_20186_()) / (double)this.lerpSteps;
            double d2 = this.m_20189_() + (this.lerpZ - this.m_20189_()) / (double)this.lerpSteps;
            double d3 = Mth.m_14175_((double)(this.lerpYRot - (double)this.m_146908_()));
            this.m_146922_(this.m_146908_() + (float)d3 / (float)this.lerpSteps);
            --this.lerpSteps;
            this.m_6034_(d0, d1, d2);
        }
    }

    public void m_6453_(double posX, double posY, double posZ, float yaw, float pitch, int pPosRotationIncrements, boolean teleport) {
        this.lerpX = posX;
        this.lerpY = posY;
        this.lerpZ = posZ;
        this.lerpYRot = yaw;
        this.lerpXRot = pitch;
        this.lerpSteps = 10;
    }

    protected void destroy(DamageSource damageSource) {
        this.m_5552_(this.getCannonball(), 1.0f);
        this.m_5552_(new ItemStack((ItemLike)this.getDropItem()), 1.0f);
    }

    public void m_7822_(byte eventID) {
        if (eventID == 10) {
            this.light(null);
        } else {
            super.m_7822_(eventID);
        }
    }

    public ItemStack getCannonball() {
        return (ItemStack)this.f_19804_.m_135370_(DATA_ID_CANNONBALL_ITEM);
    }

    protected void setCannonball(ItemStack itemStack) {
        this.f_19804_.m_135381_(DATA_ID_CANNONBALL_ITEM, (Object)itemStack.m_41777_());
    }

    public float getDamage() {
        return ((Float)this.f_19804_.m_135370_(DATA_ID_DAMAGE)).floatValue();
    }

    public void setDamage(float damageTaken) {
        this.f_19804_.m_135381_(DATA_ID_DAMAGE, (Object)Float.valueOf(damageTaken));
    }

    public int getFuseTime() {
        return this.fuse;
    }

    public boolean recentlyFired() {
        return this.recentlyFired > 0;
    }

    public Item getDropItem() {
        return (Item)AlekiShipsItems.CANNON.get();
    }

    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)this.getDropItem());
    }

    public boolean m_6087_() {
        return !this.m_213877_();
    }

    public boolean m_5829_() {
        return !this.m_20159_();
    }

    public boolean m_6094_() {
        return true;
    }

    public ItemStack nextRequiredItem() {
        return CANNONBALL;
    }

    public float m_146909_() {
        return ((Float)this.f_19804_.m_135370_(DATA_ID_X_ROT)).floatValue();
    }

    public void m_146926_(float xRot) {
        this.f_19804_.m_135381_(DATA_ID_X_ROT, (Object)Float.valueOf(xRot));
    }

    public boolean isLoaded() {
        return !this.getCannonball().m_41619_();
    }

    public boolean isLit() {
        return this.fuse > -1;
    }
}

