/*
 * Decompiled with CFR 0.152.
 */
package com.alekiponi.alekiships.common.entity.vehicle;

import com.alekiponi.alekiships.client.IngameOverlays;
import com.alekiponi.alekiships.common.entity.AlekiShipsEntities;
import com.alekiponi.alekiships.common.entity.IHaveIcons;
import com.alekiponi.alekiships.common.entity.vehicle.AbstractAlekiBoatEntity;
import com.alekiponi.alekiships.common.entity.vehiclecapability.IAllowFallDamage;
import com.alekiponi.alekiships.common.entity.vehiclecapability.IHaveColliders;
import com.alekiponi.alekiships.common.entity.vehiclecapability.IHaveCompartments;
import com.alekiponi.alekiships.common.entity.vehiclehelper.ColliderEntity;
import com.alekiponi.alekiships.common.entity.vehiclehelper.VehiclePart;
import com.alekiponi.alekiships.common.entity.vehiclehelper.compartment.AbstractCompartmentEntity;
import com.alekiponi.alekiships.common.entity.vehiclehelper.compartment.EmptyCompartmentEntity;
import com.alekiponi.alekiships.network.PacketHandler;
import com.alekiponi.alekiships.network.ServerBoundFlagVehicleForUpdatePacket;
import com.alekiponi.alekiships.util.ClientHelper;
import com.alekiponi.alekiships.util.CommonHelper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.WaterlilyBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractVehicle
extends Entity
implements IHaveIcons,
IHaveColliders,
IHaveCompartments {
    protected static final EntityDataAccessor<Integer> DATA_ID_HURT = SynchedEntityData.m_135353_(AbstractVehicle.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Integer> DATA_ID_HURTDIR = SynchedEntityData.m_135353_(AbstractVehicle.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Float> DATA_ID_DAMAGE = SynchedEntityData.m_135353_(AbstractVehicle.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Float> DATA_ID_DELTA_ROTATION = SynchedEntityData.m_135353_(AbstractVehicle.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Float> DATA_ID_ACCELERATION = SynchedEntityData.m_135353_(AbstractVehicle.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected AbstractCompartmentEntity.RidingPose[] ridingPoses;
    private final LinkedList<Double> speedOverTime;
    protected float invFriction;
    protected int lerpSteps;
    protected double lerpX;
    protected double lerpY;
    protected double lerpZ;
    protected double lerpYRot;
    protected double lerpXRot;
    protected double waterLevel;
    protected double lavaLevel;
    protected float landFriction;
    protected int blockLightLevel;
    @Nullable
    protected MediumStatus status;
    @Nullable
    protected MediumStatus oldStatus;
    protected double lastYd;
    private boolean hasAllParts = false;
    private boolean passengerUpdateFlag = false;

    public AbstractVehicle(EntityType entityType, Level level) {
        super(entityType, level);
        this.f_19850_ = true;
        this.speedOverTime = new LinkedList();
        for (int i = 0; i < 5; ++i) {
            this.speedOverTime.add(0.0);
        }
        this.ridingPoses = new AbstractCompartmentEntity.RidingPose[0];
    }

    public abstract int getMaxPassengers();

    public AbstractCompartmentEntity.RidingPose[] getRidingPoses() {
        if (this.ridingPoses.length == 0) {
            AbstractCompartmentEntity.RidingPose[] poses = new AbstractCompartmentEntity.RidingPose[this.getMaxPassengers()];
            for (int i = 0; i < this.getMaxPassengers(); ++i) {
                poses[i] = AbstractCompartmentEntity.RidingPose.STANDARD;
            }
            this.ridingPoses = poses;
        }
        return this.ridingPoses;
    }

    public abstract float renderSizeForCompartments();

    public boolean pilotCompartmentAcceptsNonPlayers() {
        return false;
    }

    public boolean renderCleatKnotSides() {
        return true;
    }

    public float[] getDefaultColliderDimensions() {
        return new float[]{1.0f, 1.0f};
    }

    public abstract float getPassengerSizeLimit();

    protected float m_6380_(Pose pose, EntityDimensions entityDimensions) {
        return entityDimensions.f_20378_;
    }

    public void m_8119_() {
        if (!this.isFunctional()) {
            this.hasAllParts = false;
        }
        if (!this.hasAllParts && this.m_20197_().size() < this.getMaxPassengers() && this.isFunctional()) {
            this.addVehicleParts();
        } else if (this.isFunctional()) {
            this.hasAllParts = true;
        }
        if (!this.hasAllParts()) {
            return;
        }
        if (this.everyNthTickUnique(40)) {
            this.checkIfNeedsPassengerUpdate();
        }
        if (this.everyNthTickUnique(2)) {
            int light = 0;
            for (AbstractCompartmentEntity compartment : this.getCompartments()) {
                light = Math.max(compartment.getCompartmentBlockLight(), light);
            }
            this.blockLightLevel = Math.max(0, light - 1);
        }
        super.m_8119_();
    }

    private void addVehicleParts() {
        VehiclePart newPart = (VehiclePart)((EntityType)AlekiShipsEntities.VEHICLE_PART.get()).m_20615_(this.m_9236_());
        newPart.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        this.m_9236_().m_7967_((Entity)newPart);
        newPart.m_20329_(this);
    }

    public boolean hasAllParts() {
        return this.hasAllParts;
    }

    public void checkIfNeedsPassengerUpdate() {
        Player player;
        if (this.m_9236_().m_5776_() && (player = this.m_9236_().m_45930_((Entity)this, 80.0)) != null && this.m_20270_((Entity)player) < 64.0f && !this.hasAllHelpers()) {
            PacketHandler.send(PacketDistributor.SERVER.noArg(), new ServerBoundFlagVehicleForUpdatePacket(true, this.m_19879_()));
        }
    }

    public void setFlaggedForPassengerUpdate(boolean flag) {
        this.passengerUpdateFlag = flag;
    }

    public boolean isFlaggedForPassengerUpdate() {
        return this.passengerUpdateFlag;
    }

    public boolean hasAllHelpers() {
        for (Entity passenger : this.m_20197_()) {
            if (passenger.m_20160_()) continue;
            return false;
        }
        return true;
    }

    public boolean isFunctional() {
        return this.getDamage() <= this.getDamageThreshold();
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.EVENTS;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_ID_HURT, (Object)0);
        this.f_19804_.m_135372_(DATA_ID_HURTDIR, (Object)1);
        this.f_19804_.m_135372_(DATA_ID_DAMAGE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_ID_DELTA_ROTATION, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_ID_ACCELERATION, (Object)Float.valueOf(0.0f));
    }

    public boolean m_7337_(Entity other) {
        return AbstractVehicle.canVehicleCollide(this, other);
    }

    public static boolean canVehicleCollide(Entity vehicle, Entity entity) {
        return (entity.m_5829_() || entity.m_6094_()) && !vehicle.m_20365_(entity);
    }

    public boolean m_5829_() {
        return true;
    }

    public boolean m_6094_() {
        return true;
    }

    protected Vec3 m_7643_(Direction.Axis axis, BlockUtil.FoundRectangle portal) {
        return LivingEntity.m_21289_((Vec3)super.m_7643_(axis, portal));
    }

    public boolean m_6052_() {
        return this.m_20151_();
    }

    public double m_6048_() {
        return 0.0;
    }

    public boolean m_6469_(DamageSource damageSource, float amount) {
        boolean instantKill;
        if (this.m_6673_(damageSource)) {
            return false;
        }
        if (this.m_9236_().f_46443_ || this.m_213877_()) {
            return true;
        }
        this.setHurtDir(-this.getHurtDir());
        this.setHurtTime(10);
        this.setDamage(this.getDamage() + amount);
        this.m_5834_();
        this.m_146852_(GameEvent.f_223706_, damageSource.m_7639_());
        boolean bl = instantKill = damageSource.m_7639_() instanceof Player && ((Player)damageSource.m_7639_()).m_150110_().f_35937_ && damageSource.m_276093_(DamageTypes.f_268464_);
        if (instantKill) {
            this.setDamage(this.getDamage() + this.getDeathDamageThreshold() / 4.0f);
        }
        if (this.getDamage() > this.getDamageThreshold()) {
            Level level;
            for (Entity entity : this.m_20197_()) {
                entity.m_6074_();
            }
            if (this.m_9236_().m_46469_().m_46207_(GameRules.f_46137_) && this.getDamage() > this.getDeathDamageThreshold() && (level = this.m_9236_()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                this.dropAllDestructionLoot(damageSource, serverLevel);
            }
        }
        return true;
    }

    public void m_7334_(Entity entity) {
        if (entity instanceof AbstractVehicle) {
            if (entity.m_20191_().f_82289_ < this.m_20191_().f_82292_) {
                super.m_7334_(entity);
            }
        } else if (entity.m_20191_().f_82289_ <= this.m_20191_().f_82289_) {
            super.m_7334_(entity);
        }
    }

    @Deprecated
    public Item getDropItem() {
        return Items.f_41852_;
    }

    public void m_6053_(float pYaw) {
        this.setHurtDir(-this.getHurtDir());
        this.setHurtTime(10);
        this.setDamage(this.getDamage() * 11.0f);
    }

    public boolean m_6087_() {
        return !this.m_213877_();
    }

    public void m_6453_(double posX, double posY, double posZ, float yaw, float pitch, int pPosRotationIncrements, boolean teleport) {
        this.lerpX = posX;
        this.lerpY = posY;
        this.lerpZ = posZ;
        this.lerpYRot = yaw;
        this.lerpXRot = pitch;
        this.lerpSteps = 10;
    }

    public Direction m_6374_() {
        return this.m_6350_().m_122427_();
    }

    protected void tickTakeEntitiesForARide() {
        List<Entity> entitiesToTakeWith;
        if (this.f_19797_ < 10) {
            return;
        }
        if (this instanceof AbstractAlekiBoatEntity && (this.status == MediumStatus.UNDER_WATER || this.status == MediumStatus.UNDER_FLOWING_WATER)) {
            return;
        }
        if (this.m_20184_().m_82553_() > 0.0 && !(entitiesToTakeWith = this.collectEntitesToTakeWith()).isEmpty()) {
            for (Entity entity : entitiesToTakeWith) {
                if (this.m_9236_().m_5776_()) {
                    ClientHelper.tickTakeClientPlayersForARide(this, entity);
                }
                if (entity instanceof AbstractVehicle || entity.m_20159_() || entity instanceof Player) continue;
                entity.m_20256_(entity.m_20184_().m_82549_(this.m_20184_().m_82542_(0.45, 0.0, 0.45)));
            }
        }
    }

    public List<Entity> collectEntitesToTakeWith() {
        List entities = this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82377_(0.0, -this.m_20191_().m_82376_() + 2.0, 0.0).m_82386_(0.0, this.m_20191_().m_82376_(), 0.0), EntitySelector.m_20421_((Entity)this));
        for (ColliderEntity collider : this.getColliders()) {
            entities.addAll(this.m_9236_().m_6249_((Entity)collider, collider.m_20191_().m_82377_(0.0, -collider.m_20191_().m_82376_() + 2.0, 0.0).m_82386_(0.0, collider.m_20191_().m_82376_(), 0.0), EntitySelector.m_20421_((Entity)this)));
        }
        entities = entities.stream().distinct().collect(Collectors.toList());
        ArrayList<Entity> entitiesToTakeWith = new ArrayList<Entity>();
        for (Entity entity : entities) {
            if (entity.m_20159_() || entity instanceof AbstractVehicle) continue;
            entitiesToTakeWith.add(entity);
        }
        return entitiesToTakeWith;
    }

    protected void tickLerp() {
        if (this.m_6109_()) {
            this.lerpSteps = 0;
            this.m_217006_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        }
        if (this.lerpSteps > 0) {
            double d0 = this.m_20185_() + (this.lerpX - this.m_20185_()) / (double)this.lerpSteps;
            double d1 = this.m_20186_() + (this.lerpY - this.m_20186_()) / (double)this.lerpSteps;
            double d2 = this.m_20189_() + (this.lerpZ - this.m_20189_()) / (double)this.lerpSteps;
            double d3 = Mth.m_14175_((double)(this.lerpYRot - (double)this.m_146908_()));
            this.m_146922_(this.m_146908_() + (float)d3 / (float)this.lerpSteps);
            this.m_146926_(this.m_146909_() + (float)(this.lerpXRot - (double)this.m_146909_()) / (float)this.lerpSteps);
            --this.lerpSteps;
            this.m_6034_(d0, d1, d2);
        }
    }

    public MediumStatus getStatus() {
        MediumStatus underwater = this.isUnderwater();
        if (underwater != null) {
            this.waterLevel = this.m_20191_().f_82292_;
            return underwater;
        }
        if (this.checkInWater()) {
            return MediumStatus.IN_WATER;
        }
        MediumStatus underlava = this.isUnderlava();
        if (underlava != null) {
            this.lavaLevel = this.m_20191_().f_82292_;
            return underlava;
        }
        if (this.checkInLava()) {
            return MediumStatus.IN_LAVA;
        }
        float groundFriction = this.getGroundFriction();
        if (0.0f < groundFriction) {
            this.landFriction = groundFriction;
            return MediumStatus.ON_LAND;
        }
        return MediumStatus.IN_AIR;
    }

    public float getWaterLevelAbove() {
        AABB boundingBox = this.m_20191_();
        int minX = Mth.m_14107_((double)boundingBox.f_82288_);
        int maxX = Mth.m_14165_((double)boundingBox.f_82291_);
        int maxY = Mth.m_14107_((double)boundingBox.f_82292_);
        int l = Mth.m_14165_((double)(boundingBox.f_82292_ - this.lastYd));
        int minZ = Mth.m_14107_((double)boundingBox.f_82290_);
        int maxZ = Mth.m_14165_((double)boundingBox.f_82293_);
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        block0: for (int k1 = maxY; k1 < l; ++k1) {
            float waterLevel = 0.0f;
            for (int l1 = minX; l1 < maxX; ++l1) {
                for (int i2 = minZ; i2 < maxZ; ++i2) {
                    mutableBlockPos.m_122178_(l1, k1, i2);
                    FluidState fluidstate = this.m_9236_().m_6425_((BlockPos)mutableBlockPos);
                    if (fluidstate.m_205070_(FluidTags.f_13131_)) {
                        waterLevel = Math.max(waterLevel, fluidstate.m_76155_((BlockGetter)this.m_9236_(), (BlockPos)mutableBlockPos));
                    }
                    if (1.0f <= waterLevel) continue block0;
                }
            }
            if (!(1.0f > waterLevel)) continue;
            return (float)mutableBlockPos.m_123342_() + waterLevel;
        }
        return l + 1;
    }

    public float getGroundFriction() {
        AABB aabb = this.m_20191_();
        AABB aabb1 = new AABB(aabb.f_82288_, aabb.f_82289_ - 0.001, aabb.f_82290_, aabb.f_82291_, aabb.f_82289_, aabb.f_82293_);
        int i = Mth.m_14107_((double)aabb1.f_82288_) - 1;
        int j = Mth.m_14165_((double)aabb1.f_82291_) + 1;
        int k = Mth.m_14107_((double)aabb1.f_82289_) - 1;
        int l = Mth.m_14165_((double)aabb1.f_82292_) + 1;
        int i1 = Mth.m_14107_((double)aabb1.f_82290_) - 1;
        int j1 = Mth.m_14165_((double)aabb1.f_82293_) + 1;
        VoxelShape voxelshape = Shapes.m_83064_((AABB)aabb1);
        float f = 0.0f;
        int k1 = 0;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int l1 = i; l1 < j; ++l1) {
            for (int i2 = i1; i2 < j1; ++i2) {
                int j2 = (l1 != i && l1 != j - 1 ? 0 : 1) + (i2 != i1 && i2 != j1 - 1 ? 0 : 1);
                if (j2 == 2) continue;
                for (int k2 = k; k2 < l; ++k2) {
                    if (j2 > 0 && (k2 == k || k2 == l - 1)) continue;
                    blockpos$mutableblockpos.m_122178_(l1, k2, i2);
                    BlockState blockstate = this.m_9236_().m_8055_((BlockPos)blockpos$mutableblockpos);
                    if (blockstate.m_60734_() instanceof WaterlilyBlock || !Shapes.m_83157_((VoxelShape)blockstate.m_60812_((BlockGetter)this.m_9236_(), (BlockPos)blockpos$mutableblockpos).m_83216_((double)l1, (double)k2, (double)i2), (VoxelShape)voxelshape, (BooleanOp)BooleanOp.f_82689_)) continue;
                    f += blockstate.getFriction((LevelReader)this.m_9236_(), (BlockPos)blockpos$mutableblockpos, (Entity)this);
                    ++k1;
                }
            }
        }
        return f / (float)k1;
    }

    protected boolean checkInWater() {
        AABB aabb = this.m_20191_();
        int i = Mth.m_14107_((double)aabb.f_82288_);
        int j = Mth.m_14165_((double)aabb.f_82291_);
        int k = Mth.m_14107_((double)aabb.f_82289_);
        int l = Mth.m_14165_((double)(aabb.f_82289_ + 0.001));
        int i1 = Mth.m_14107_((double)aabb.f_82290_);
        int j1 = Mth.m_14165_((double)aabb.f_82293_);
        boolean flag = false;
        this.waterLevel = -1.7976931348623157E308;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    blockpos$mutableblockpos.m_122178_(k1, l1, i2);
                    FluidState fluidstate = this.m_9236_().m_6425_((BlockPos)blockpos$mutableblockpos);
                    if (!fluidstate.m_205070_(FluidTags.f_13131_)) continue;
                    float f = (float)l1 + fluidstate.m_76155_((BlockGetter)this.m_9236_(), (BlockPos)blockpos$mutableblockpos);
                    this.waterLevel = Math.max((double)f, this.waterLevel);
                    flag |= aabb.f_82289_ < (double)f;
                }
            }
        }
        return flag;
    }

    protected boolean checkInLava() {
        AABB aabb = this.m_20191_();
        int i = Mth.m_14107_((double)aabb.f_82288_);
        int j = Mth.m_14165_((double)aabb.f_82291_);
        int k = Mth.m_14107_((double)aabb.f_82289_);
        int l = Mth.m_14165_((double)(aabb.f_82289_ + 0.001));
        int i1 = Mth.m_14107_((double)aabb.f_82290_);
        int j1 = Mth.m_14165_((double)aabb.f_82293_);
        boolean flag = false;
        this.lavaLevel = -1.7976931348623157E308;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    blockpos$mutableblockpos.m_122178_(k1, l1, i2);
                    FluidState fluidstate = this.m_9236_().m_6425_((BlockPos)blockpos$mutableblockpos);
                    if (!fluidstate.m_205070_(FluidTags.f_13132_)) continue;
                    float f = (float)l1 + fluidstate.m_76155_((BlockGetter)this.m_9236_(), (BlockPos)blockpos$mutableblockpos);
                    this.lavaLevel = Math.max((double)f, this.lavaLevel);
                    flag |= aabb.f_82289_ < (double)f;
                }
            }
        }
        return flag;
    }

    @Nullable
    protected MediumStatus isUnderlava() {
        AABB aabb = this.m_20191_();
        double d0 = aabb.f_82292_ + 0.001;
        int i = Mth.m_14107_((double)aabb.f_82288_);
        int j = Mth.m_14165_((double)aabb.f_82291_);
        int k = Mth.m_14107_((double)aabb.f_82292_);
        int l = Mth.m_14165_((double)d0);
        int i1 = Mth.m_14107_((double)aabb.f_82290_);
        int j1 = Mth.m_14165_((double)aabb.f_82293_);
        boolean isUnderLava = false;
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    mutableBlockPos.m_122178_(k1, l1, i2);
                    FluidState fluidstate = this.m_9236_().m_6425_((BlockPos)mutableBlockPos);
                    if (!fluidstate.m_205070_(FluidTags.f_13132_) || !(d0 < (double)((float)mutableBlockPos.m_123342_() + fluidstate.m_76155_((BlockGetter)this.m_9236_(), (BlockPos)mutableBlockPos)))) continue;
                    if (!fluidstate.m_76170_()) {
                        return MediumStatus.UNDER_FLOWING_LAVA;
                    }
                    isUnderLava = true;
                }
            }
        }
        return isUnderLava ? MediumStatus.UNDER_LAVA : null;
    }

    @Nullable
    protected MediumStatus isUnderwater() {
        AABB aabb = this.m_20191_();
        double d0 = aabb.f_82292_ + 0.001;
        int i = Mth.m_14107_((double)aabb.f_82288_);
        int j = Mth.m_14165_((double)aabb.f_82291_);
        int k = Mth.m_14107_((double)aabb.f_82292_);
        int l = Mth.m_14165_((double)d0);
        int i1 = Mth.m_14107_((double)aabb.f_82290_);
        int j1 = Mth.m_14165_((double)aabb.f_82293_);
        boolean isUnderwater = false;
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    mutableBlockPos.m_122178_(k1, l1, i2);
                    FluidState fluidstate = this.m_9236_().m_6425_((BlockPos)mutableBlockPos);
                    if (!fluidstate.m_205070_(FluidTags.f_13131_) || !(d0 < (double)((float)mutableBlockPos.m_123342_() + fluidstate.m_76155_((BlockGetter)this.m_9236_(), (BlockPos)mutableBlockPos)))) continue;
                    if (!fluidstate.m_76170_()) {
                        return MediumStatus.UNDER_FLOWING_WATER;
                    }
                    isUnderwater = true;
                }
            }
        }
        return isUnderwater ? MediumStatus.UNDER_WATER : null;
    }

    public final List<Entity> collectLivingPassengers() {
        ArrayList truePassengers = Lists.newArrayList();
        for (Entity vehiclePart : this.m_20197_()) {
            AbstractCompartmentEntity compartmentEntity;
            Entity entity;
            if (!vehiclePart.m_20160_() || !((entity = vehiclePart.m_146895_()) instanceof AbstractCompartmentEntity) || !(compartmentEntity = (AbstractCompartmentEntity)entity).m_20160_() || !(compartmentEntity.m_146895_() instanceof LivingEntity)) continue;
            truePassengers.add(compartmentEntity.m_146895_());
        }
        return truePassengers;
    }

    public final List<Player> collectPlayerPassengers() {
        List<Entity> truePassengers = this.collectLivingPassengers();
        ArrayList<Player> players = new ArrayList<Player>();
        for (Entity entity : truePassengers) {
            if (!(entity instanceof Player)) continue;
            Player player = (Player)entity;
            players.add(player);
        }
        return players;
    }

    public final List<Player> collectPlayersToTakeWith() {
        List<Entity> truePassengers = this.collectEntitesToTakeWith();
        ArrayList<Player> players = new ArrayList<Player>();
        for (Entity entity : truePassengers) {
            if (!(entity instanceof Player)) continue;
            Player player = (Player)entity;
            players.add(player);
        }
        return players;
    }

    public final List<AbstractCompartmentEntity> collectCompartments() {
        ArrayList compartments = Lists.newArrayList();
        for (Entity vehiclePart : this.m_20197_()) {
            Entity entity;
            if (!vehiclePart.m_20160_() || !((entity = vehiclePart.m_146895_()) instanceof AbstractCompartmentEntity)) continue;
            AbstractCompartmentEntity compartmentEntity = (AbstractCompartmentEntity)entity;
            compartments.add(compartmentEntity);
        }
        return compartments;
    }

    public final List<VehiclePart> collectVehicleParts() {
        ArrayList vehicleParts = Lists.newArrayList();
        for (Entity vehiclePart : this.m_20197_()) {
            vehicleParts.add((VehiclePart)vehiclePart);
        }
        return vehicleParts;
    }

    public final List<Entity> collectVehicleHelpers() {
        ArrayList helpers = Lists.newArrayList();
        for (VehiclePart part : this.collectVehicleParts()) {
            if (!part.m_20160_()) continue;
            helpers.add(part.m_146895_());
        }
        return helpers;
    }

    public final int countVehicleHelpers() {
        int count = 0;
        for (VehiclePart part : this.collectVehicleParts()) {
            if (!part.m_20160_()) continue;
            ++count;
        }
        return count;
    }

    protected void m_19956_(Entity passenger, Entity.MoveFunction moveFunction) {
        if (this.m_20363_(passenger)) {
            if (!(passenger instanceof VehiclePart)) {
                passenger.m_8127_();
            }
            Vec3 position = this.positionRiderByIndex(this.m_20197_().indexOf(passenger));
            Vec3 vec3 = this.positionLocally(position);
            moveFunction.m_20372_(passenger, this.m_20185_() + vec3.f_82479_, this.m_20186_() + vec3.f_82480_, this.m_20189_() + vec3.f_82481_);
            passenger.m_6034_(this.m_20185_() + vec3.f_82479_, this.m_20186_() + vec3.f_82480_, this.m_20189_() + vec3.f_82481_);
            passenger.m_146922_(this.m_146908_());
        }
    }

    protected Vec3 positionRiderByIndex(int index) {
        float localX = 0.0f;
        float localZ = 0.0f;
        float localY = (float)(this.m_213877_() ? (double)0.01f : this.m_6048_());
        switch (index) {
            case 0: {
                localX = 0.3f;
                localZ = 0.0f;
                localY += 0.0f;
                break;
            }
            case 1: {
                localX = -0.7f;
                localZ = 0.0f;
                localY += 0.0f;
            }
        }
        return new Vec3((double)localX, (double)localY, (double)localZ);
    }

    protected Vec3 positionLocally(float localX, float localY, float localZ) {
        return new Vec3((double)localX, (double)localY, (double)localZ).m_82524_(-this.m_146908_() * ((float)Math.PI / 180) - 1.5707964f);
    }

    protected Vec3 positionLocally(Vec3 vec) {
        return this.positionLocally((float)vec.f_82479_, (float)vec.f_82480_, (float)vec.f_82481_);
    }

    protected void clampRotation(Entity entity) {
        entity.m_5618_(this.m_146908_());
        float f = Mth.m_14177_((float)(entity.m_146908_() - this.m_146908_()));
        float f1 = Mth.m_14036_((float)f, (float)-105.0f, (float)105.0f);
        entity.f_19859_ += f1 - f;
        entity.m_146922_(entity.m_146908_() + f1 - f);
        entity.m_5616_(entity.m_146908_());
    }

    protected void m_7840_(double fallDistance, boolean onGround, BlockState blockState, BlockPos blockPos) {
        if (this instanceof IAllowFallDamage) {
            this.lastYd = this.m_20184_().f_82480_;
            if (this.m_20159_()) {
                return;
            }
            if (!onGround) {
                if (!this.m_9236_().m_6425_(this.m_20183_().m_7495_()).m_205070_(FluidTags.f_13131_) && fallDistance < 0.0) {
                    this.f_19789_ -= (float)fallDistance;
                }
                return;
            }
            if (this.f_19789_ > 3.0f) {
                if (this.status != MediumStatus.ON_LAND) {
                    this.m_183634_();
                    return;
                }
                this.m_142535_(this.f_19789_, 1.0f, this.m_269291_().m_268989_());
                if (!this.m_9236_().f_46443_ && !this.m_213877_()) {
                    Level level;
                    for (Entity passenger : this.collectLivingPassengers()) {
                        passenger.m_142535_(this.f_19789_, 1.0f, this.m_269291_().m_268989_());
                    }
                    for (Entity passenger : this.m_20197_()) {
                        if (!passenger.m_20160_()) continue;
                        passenger.m_146895_().m_6074_();
                    }
                    this.m_6074_();
                    if (this.m_9236_().m_46469_().m_46207_(GameRules.f_46137_) && (level = this.m_9236_()) instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        this.dropAllDestructionLoot(this.m_269291_().m_268989_(), serverLevel);
                    }
                }
            }
            this.m_183634_();
        }
    }

    public float getDamage() {
        return ((Float)this.f_19804_.m_135370_(DATA_ID_DAMAGE)).floatValue();
    }

    public void setDamage(float damage) {
        this.f_19804_.m_135381_(DATA_ID_DAMAGE, (Object)Float.valueOf(damage));
    }

    public int getHurtTime() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_HURT);
    }

    public void setHurtTime(int hurtTime) {
        this.f_19804_.m_135381_(DATA_ID_HURT, (Object)hurtTime);
    }

    public int getHurtDir() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_HURTDIR);
    }

    public void setHurtDir(int hurtDirection) {
        this.f_19804_.m_135381_(DATA_ID_HURTDIR, (Object)hurtDirection);
    }

    public abstract float getDamageThreshold();

    public abstract float getDeathDamageThreshold();

    public abstract float getDamageRecovery();

    public void setDeltaRotation(float deltaRotation) {
        this.f_19804_.m_135381_(DATA_ID_DELTA_ROTATION, (Object)Float.valueOf(deltaRotation));
    }

    public float getDeltaRotation() {
        return ((Float)this.f_19804_.m_135370_(DATA_ID_DELTA_ROTATION)).floatValue();
    }

    public void setAcceleration(float acceleration) {
        this.f_19804_.m_135381_(DATA_ID_ACCELERATION, (Object)Float.valueOf(Mth.m_14036_((float)acceleration, (float)-1.0f, (float)1.0f)));
    }

    public float getAcceleration() {
        return ((Float)this.f_19804_.m_135370_(DATA_ID_ACCELERATION)).floatValue();
    }

    protected void m_7378_(CompoundTag pCompound) {
        this.setDeltaRotation(pCompound.m_128457_("deltaRotation"));
        this.setHurtDir(pCompound.m_128451_("hurtDir"));
        this.setDamage(pCompound.m_128457_("damage"));
        this.setHurtTime(pCompound.m_128451_("hurtTime"));
    }

    protected void m_7380_(CompoundTag pCompound) {
        pCompound.m_128350_("deltaRotation", this.getDeltaRotation());
        pCompound.m_128405_("hurtDir", this.getHurtDir());
        pCompound.m_128350_("damage", this.getDamage());
        pCompound.m_128405_("hurtTime", this.getHurtTime());
    }

    protected boolean m_7310_(Entity passenger) {
        if (this.getDamage() > this.getDamageThreshold()) {
            return false;
        }
        return this.m_20197_().size() < this.getMaxPassengers() && !this.m_213877_() && passenger instanceof VehiclePart;
    }

    @Nullable
    public LivingEntity m_6688_() {
        LivingEntity livingentity;
        VehiclePart vehiclePart;
        Entity entity = this.getPilotVehiclePartAsEntity();
        if (entity instanceof VehiclePart && (entity = (vehiclePart = (VehiclePart)entity).m_146895_()) instanceof EmptyCompartmentEntity) {
            EmptyCompartmentEntity emptyCompartmentEntity = (EmptyCompartmentEntity)entity;
            entity = emptyCompartmentEntity.m_6688_();
        }
        LivingEntity livingentity1 = entity instanceof LivingEntity ? (livingentity = (LivingEntity)entity) : null;
        return livingentity1;
    }

    @Nullable
    public EmptyCompartmentEntity getPilotCompartment() {
        Entity vehiclePart = this.getPilotVehiclePartAsEntity();
        if (!(vehiclePart instanceof VehiclePart) || !vehiclePart.m_20160_()) {
            return null;
        }
        Entity entity = vehiclePart.m_146895_();
        if (!(entity instanceof EmptyCompartmentEntity)) {
            return null;
        }
        EmptyCompartmentEntity emptyCompartmentEntity = (EmptyCompartmentEntity)entity;
        return emptyCompartmentEntity;
    }

    @Nullable
    public Entity getPilotVehiclePartAsEntity() {
        if (this.m_20160_() && this.m_20197_().size() == this.getMaxPassengers()) {
            return (Entity)this.m_20197_().get(0);
        }
        return null;
    }

    public boolean m_5842_() {
        return this.status == MediumStatus.UNDER_WATER || this.status == MediumStatus.UNDER_FLOWING_WATER;
    }

    public double getSmoothSpeedMS() {
        if (this.everyNthTickUnique(3)) {
            double speed = this.m_20184_().m_82553_() * 20.0;
            this.speedOverTime.poll();
            this.speedOverTime.offer(speed);
        }
        double average = 0.0;
        Iterator iterator = this.speedOverTime.iterator();
        while (iterator.hasNext()) {
            double d = (Double)iterator.next();
            average += d;
        }
        return average /= (double)this.speedOverTime.size();
    }

    public boolean everyNthTickUnique(int n) {
        return CommonHelper.everyNthTickUnique(this.m_19879_(), this.f_19797_, n);
    }

    protected void m_20348_(Entity passenger) {
        if (passenger instanceof VehiclePart) {
            super.m_20348_(passenger);
        }
    }

    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)this.getDropItem());
    }

    protected void dropAllDestructionLoot(DamageSource damageSource, ServerLevel serverLevel) {
        this.dropFromLootTable(serverLevel, damageSource);
        this.dropCustomDestructionLoot(damageSource);
    }

    protected void dropCustomDestructionLoot(DamageSource damageSource) {
    }

    protected void dropFromLootTable(ServerLevel serverLevel, DamageSource damageSource) {
        ResourceLocation resourcelocation = this.getLootTable();
        LootTable loottable = serverLevel.m_7654_().m_278653_().m_278676_(resourcelocation);
        LootParams.Builder lootBuilder = new LootParams.Builder(serverLevel).m_287286_(LootContextParams.f_81455_, (Object)this).m_287286_(LootContextParams.f_81460_, (Object)this.m_20182_()).m_287286_(LootContextParams.f_81457_, (Object)damageSource).m_287289_(LootContextParams.f_81458_, (Object)damageSource.m_7639_()).m_287289_(LootContextParams.f_81459_, (Object)damageSource.m_7640_());
        LootParams lootparams = lootBuilder.m_287235_(LootContextParamSets.f_81415_);
        loottable.m_287276_(lootparams, this.getLootTableSeed(), arg_0 -> ((AbstractVehicle)this).m_19983_(arg_0));
    }

    public AABB m_6921_() {
        float bbRadius = this.m_20205_() * 3.0f + 1.0f;
        Vec3 startingPoint = new Vec3(this.m_20185_() - (double)bbRadius, this.m_20186_() - (double)bbRadius, this.m_20189_() - (double)bbRadius);
        Vec3 endingPoint = new Vec3(this.m_20185_() + (double)bbRadius, this.m_20186_() + (double)bbRadius, this.m_20189_() + (double)bbRadius);
        return new AABB(startingPoint, endingPoint);
    }

    @NotNull
    protected Vec3 m_20272_(Vec3 pVec) {
        Vec3 originalCollision = super.m_20272_(pVec);
        return originalCollision;
    }

    public int getCompartmentBlockLight() {
        return this.blockLightLevel;
    }

    @Override
    public ArrayList<IngameOverlays.IconState> getIconStates(Player player) {
        return new ArrayList<IngameOverlays.IconState>();
    }

    public void m_6845_(boolean pDownwards) {
    }

    public void m_20321_(boolean pDownwards) {
    }

    public ResourceLocation getLootTable() {
        return this.m_6095_().m_20677_();
    }

    public long getLootTableSeed() {
        return 0L;
    }

    public static enum MediumStatus {
        IN_WATER,
        UNDER_WATER,
        UNDER_FLOWING_WATER,
        ON_LAND,
        IN_AIR,
        IN_LAVA,
        UNDER_LAVA,
        UNDER_FLOWING_LAVA;

    }
}

