/*
 * Decompiled with CFR 0.152.
 */
package com.alekiponi.alekiships.common.entity.vehicle;

import com.alekiponi.alekiships.client.IngameOverlays;
import com.alekiponi.alekiships.common.entity.vehicle.AbstractAlekiBoatEntity;
import com.alekiponi.alekiships.common.entity.vehicle.AbstractVehicle;
import com.alekiponi.alekiships.common.entity.vehiclecapability.IBreakIce;
import com.alekiponi.alekiships.common.entity.vehiclecapability.ICannonable;
import com.alekiponi.alekiships.common.entity.vehiclecapability.IDestroyPlants;
import com.alekiponi.alekiships.common.entity.vehiclecapability.IHaveAnchorWindlass;
import com.alekiponi.alekiships.common.entity.vehiclecapability.IHaveBlockOnlyCompartments;
import com.alekiponi.alekiships.common.entity.vehiclecapability.IHaveMasts;
import com.alekiponi.alekiships.common.entity.vehiclecapability.IHaveMultipleCleats;
import com.alekiponi.alekiships.common.entity.vehiclecapability.IHaveSailSwitches;
import com.alekiponi.alekiships.common.entity.vehiclecapability.IPaintable;
import com.alekiponi.alekiships.common.entity.vehiclehelper.SailSwitchEntity;
import com.alekiponi.alekiships.common.entity.vehiclehelper.VehiclePart;
import com.alekiponi.alekiships.common.entity.vehiclehelper.compartment.EmptyCompartmentEntity;
import com.alekiponi.alekiships.events.config.AlekishipsConfig;
import com.alekiponi.alekiships.events.config.ClientConfig;
import com.alekiponi.alekiships.network.AlekiShipsEntityDataSerializers;
import com.alekiponi.alekiships.network.PacketHandler;
import com.alekiponi.alekiships.network.ServerBoundSloopPacket;
import com.alekiponi.alekiships.util.AlekiShipsTags;
import com.alekiponi.alekiships.util.BoatMaterial;
import com.alekiponi.alekiships.util.CommonHelper;
import com.alekiponi.alekiships.util.advancements.AlekiShipsAdvancements;
import java.util.ArrayList;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.PacketDistributor;

public class SloopEntity
extends AbstractAlekiBoatEntity
implements IBreakIce,
IPaintable,
IHaveAnchorWindlass,
IHaveSailSwitches,
IHaveMasts,
ICannonable,
IHaveBlockOnlyCompartments,
IDestroyPlants,
IHaveMultipleCleats {
    public final int PASSENGER_NUMBER = 25;
    public final int[] CLEATS = new int[]{18, 19, 20, 21};
    public final int[] COLLIDERS = new int[]{14, 15, 16};
    public final int[] SAIL_SWITCHES = new int[]{17, 24};
    public final int[] WINDLASSES = new int[]{22};
    public final int[] MASTS = new int[]{23};
    public final int[] CAN_ADD_CANNONS = new int[]{7, 8, 9, 10, 11, 12};
    public final int[] CAN_ADD_ONLY_BLOCKS = new int[]{1, 2, 3, 4, 5, 6};
    public final int[] COMPARTMENTS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13};
    public final int NO_INPUT_THRESHOLD = 200;
    float boom_rotation = 0.0f;
    float mainsheet_length = 0.0f;
    float rudder_rotation = 0.0f;
    int ticks_no_input;
    protected static final EntityDataAccessor<Float> DATA_ID_MAIN_BOOM_ROTATION = SynchedEntityData.m_135353_(SloopEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Float> DATA_ID_MAINSHEET_LENGTH = SynchedEntityData.m_135353_(SloopEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Float> DATA_ID_RUDDER_ROTATION = SynchedEntityData.m_135353_(SloopEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Boolean> DATA_ID_MAINSAIL_ACTIVE = SynchedEntityData.m_135353_(SloopEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Boolean> DATA_ID_ICEBREAKER = SynchedEntityData.m_135353_(SloopEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Boolean> DATA_ID_JIBSAIL_ACTIVE = SynchedEntityData.m_135353_(SloopEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Integer> DATA_ID_TICKS_NO_RIDERS = SynchedEntityData.m_135353_(SloopEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<DyeColor> DATA_ID_MAINSAIL_DYE = SynchedEntityData.m_135353_(SloopEntity.class, (EntityDataSerializer)((EntityDataSerializer)AlekiShipsEntityDataSerializers.DYE_COLOR.get()));
    private static final EntityDataAccessor<DyeColor> DATA_ID_JIBSAIL_DYE = SynchedEntityData.m_135353_(SloopEntity.class, (EntityDataSerializer)((EntityDataSerializer)AlekiShipsEntityDataSerializers.DYE_COLOR.get()));
    private static final EntityDataAccessor<Optional<DyeColor>> DATA_ID_PAINT_COLOR = SynchedEntityData.m_135353_(SloopEntity.class, (EntityDataSerializer)((EntityDataSerializer)AlekiShipsEntityDataSerializers.OPTIONAL_DYE_COLOR.get()));
    public final int[][] COMPARTMENT_ROTATIONS = new int[][]{{7, 85}, {8, 85}, {9, 85}, {10, -85}, {11, -85}, {12, -85}};
    protected final float PASSENGER_SIZE_LIMIT = 1.4f;
    protected final int SAIL_TOGGLE_TICKS = 20;
    protected final float DAMAGE_THRESHOLD = 512.0f;
    protected final float DAMAGE_RECOVERY = 5.333f;

    public SloopEntity(EntityType<? extends SloopEntity> entityType, Level level, BoatMaterial boatMaterial) {
        super(entityType, level, boatMaterial);
    }

    @Override
    public float getPassengerSizeLimit() {
        return 1.4f;
    }

    @Override
    public int getMaxPassengers() {
        return this.PASSENGER_NUMBER;
    }

    @Override
    public int[] getCleatIndices() {
        return this.CLEATS;
    }

    @Override
    public int[] getSailSwitchIndices() {
        return this.SAIL_SWITCHES;
    }

    @Override
    public int[] getMastIndices() {
        return this.MASTS;
    }

    @Override
    public int[] getCompartmentIndices() {
        return this.COMPARTMENTS;
    }

    @Override
    public int[] getCanAddCannonsIndices() {
        return this.CAN_ADD_CANNONS;
    }

    @Override
    public int broadsideCount() {
        return 3;
    }

    @Override
    public int[] getColliderIndices() {
        return this.COLLIDERS;
    }

    @Override
    public int[] getCanAddOnlyBlocksIndices() {
        return this.CAN_ADD_ONLY_BLOCKS;
    }

    @Override
    public int getCompartmentRotation(int i) {
        return this.COMPARTMENT_ROTATIONS[i][0];
    }

    @Override
    public int[][] getCompartmentRotationsArray() {
        return this.COMPARTMENT_ROTATIONS;
    }

    @Override
    public float[] getDefaultColliderDimensions() {
        return new float[]{1.5f, 0.75f};
    }

    @Override
    protected Vec3 positionRiderByIndex(int index) {
        float localX = 0.0f;
        float localZ = 0.0f;
        float localY = (float)(this.m_213877_() ? (double)0.01f : this.m_6048_());
        float holdLevel = -0.05f;
        float deckLevel = 0.625f;
        switch (index) {
            case 0: {
                localZ = 0.6f;
                localX = -2.3f;
                localY += deckLevel;
                break;
            }
            case 1: {
                localZ = -0.4075f;
                localX = -0.61950004f;
                localY += holdLevel;
                break;
            }
            case 2: {
                localZ = 0.4075f;
                localX = -0.61950004f;
                localY += holdLevel;
                break;
            }
            case 3: {
                localZ = -0.4075f;
                localX = 0.31799996f;
                localY += holdLevel;
                break;
            }
            case 4: {
                localZ = 0.4075f;
                localX = 0.31799996f;
                localY += holdLevel;
                break;
            }
            case 5: {
                localZ = -0.4075f;
                localX = 1.2555f;
                localY += holdLevel;
                break;
            }
            case 6: {
                localZ = 0.4075f;
                localX = 1.2555f;
                localY += holdLevel;
                break;
            }
            case 7: {
                localX = 0.3f;
                localZ = -1.4f;
                localY += deckLevel;
                break;
            }
            case 8: {
                localX = -0.5f;
                localZ = -1.33f;
                localY += deckLevel;
                break;
            }
            case 9: {
                localX = -1.3f;
                localZ = -1.26f;
                localY += deckLevel;
                break;
            }
            case 10: {
                localX = 0.3f;
                localZ = 1.4f;
                localY += deckLevel;
                break;
            }
            case 11: {
                localX = -0.5f;
                localZ = 1.33f;
                localY += deckLevel;
                break;
            }
            case 12: {
                localX = -1.3f;
                localZ = 1.26f;
                localY += deckLevel;
                break;
            }
            case 13: {
                localZ = -0.6f;
                localX = -2.3f;
                localY += deckLevel;
                break;
            }
            case 14: {
                localZ = 0.6f;
                localX = -2.0f;
                localY += -0.0f;
                break;
            }
            case 15: {
                localZ = -0.6f;
                localX = -2.0f;
                localY += -0.0f;
                break;
            }
            case 16: {
                localZ = 0.0f;
                localX = 2.0f;
                localY += -0.0f;
                break;
            }
            case 17: {
                localZ = 0.0f;
                localX = 1.8f;
                localY += 2.625f;
                break;
            }
            case 18: {
                localZ = -1.75f;
                localX = 1.33f;
                localY += 1.124f;
                break;
            }
            case 19: {
                localZ = 1.75f;
                localX = 1.33f;
                localY += 1.124f;
                break;
            }
            case 20: {
                localZ = -1.75f;
                localX = -2.405f;
                localY += 1.1875f;
                break;
            }
            case 21: {
                localZ = 1.75f;
                localX = -2.405f;
                localY += 1.1875f;
                break;
            }
            case 22: {
                localZ = -1.34f;
                localX = 2.52f;
                localY += 1.0f;
                break;
            }
            case 23: {
                localZ = 0.0f;
                localX = 2.1f;
                localY += 2.9f;
                break;
            }
            case 24: {
                localZ = 0.0f;
                localX = 3.1f;
                localY += 1.0f;
            }
        }
        return new Vec3((double)localX, (double)localY, (double)localZ);
    }

    @Override
    public float getDamageThreshold() {
        return 512.0f;
    }

    @Override
    public float getDamageRecovery() {
        return 5.333f;
    }

    @Override
    public void m_8119_() {
        if (this.everyNthTickUnique(2)) {
            this.tickBreakIce();
            this.tickDestroyPlants();
            if (!this.m_9236_().m_5776_()) {
                int ind = 0;
                for (SailSwitchEntity switchEntity : this.getSailSwitches()) {
                    if (ind == 0) {
                        this.setMainsailActive(switchEntity.getSwitched() && !this.m_5842_());
                    }
                    if (ind == 1) {
                        this.setJibsailActive(switchEntity.getSwitched() && !this.m_5842_());
                    }
                    ++ind;
                }
                if (this.collectPlayersToTakeWith().isEmpty() && this.collectPlayerPassengers().isEmpty()) {
                    this.setTicksNoRiders(this.getTicksNoRiders() + 2);
                    if (this.getTicksNoRiders() >= 20) {
                        for (SailSwitchEntity switchEntity : this.getSailSwitches()) {
                            switchEntity.setSwitched(false);
                        }
                        this.setJibsailActive(false);
                        this.setMainsailActive(false);
                    }
                } else {
                    this.setTicksNoRiders(0);
                }
                if (!this.getMainsailActive() && !this.getJibsailActive()) {
                    this.setMainsheetLength(0.0f);
                }
            }
        }
        if (this.everyNthTickUnique(10)) {
            this.checkIfRecentlyFiredBroadside();
        }
        super.m_8119_();
        this.tickDynamicControls();
        if (this.m_9236_().m_5776_() && this.m_6688_() != null && this.m_6109_()) {
            PacketHandler.send(PacketDistributor.SERVER.noArg(), new ServerBoundSloopPacket(this.getMainsheetLength(), this.getMainBoomRotation(), this.getRudderRotation(), this.m_19879_()));
        }
    }

    protected void tickDynamicControls() {
        if (this.status == AbstractVehicle.MediumStatus.IN_WATER) {
            this.setDeltaRotation((float)((double)(-1.0f * this.getRudderRotation() * 0.25f) * Mth.m_14008_((double)this.m_20184_().m_82553_(), (double)0.05f, (double)1.0)));
            this.setDeltaRotation(Mth.m_14036_((float)this.getDeltaRotation(), (float)-1.0f, (float)1.0f));
            if (this.status == AbstractVehicle.MediumStatus.IN_AIR || this.status == AbstractVehicle.MediumStatus.IN_WATER) {
                float rotationImpact = 0.0f;
                float windDifference = Mth.m_14118_((float)this.getMainsailWindAngleAndForce()[0], (float)Mth.m_14177_((float)this.m_146908_()));
                if (windDifference > 4.0f) {
                    rotationImpact = 1.0f;
                } else if (windDifference < -4.0f) {
                    rotationImpact = -1.0f;
                }
                rotationImpact = Mth.m_14036_((float)((float)((double)rotationImpact * this.m_20184_().m_82553_())), (float)0.0f, (float)0.5f);
                this.setDeltaRotation(this.getDeltaRotation() + rotationImpact);
            }
        }
        if (!this.m_6109_() && this.m_6688_() instanceof Player) {
            return;
        }
        if ((this.status == AbstractVehicle.MediumStatus.IN_WATER || this.status == AbstractVehicle.MediumStatus.IN_AIR) && (this.getMainsailActive() || this.getJibsailActive())) {
            float boomWindDifference = Mth.m_14118_((float)this.getLocalWindAngle(), (float)Mth.m_14177_((float)this.getSailWorldRotation()));
            float sheet = this.getMainsheetLength();
            float boom = this.getMainBoomRotation();
            if (boomWindDifference < -171.0f) {
                boomWindDifference = Mth.m_14177_((float)(boomWindDifference - 180.0f));
            }
            if (boomWindDifference > 5.0f) {
                boom += 2.0f;
            }
            if (boomWindDifference < -5.0f) {
                boom -= 2.0f;
            }
            if (sheet > Math.abs(boom)) {
                if (boom < 2.0f) {
                    boom -= 1.0f;
                } else if (boom > 2.0f) {
                    boom += 1.0f;
                }
            }
            this.setMainBoomRotation(boom);
        }
    }

    @Override
    protected void tickControlBoat() {
        ++this.ticks_no_input;
        boolean inputUp = false;
        boolean inputDown = false;
        boolean inputLeft = false;
        boolean inputRight = false;
        if (this.getPilotCompartment() != null) {
            inputUp = this.getPilotCompartment().getInputUp();
            inputDown = this.getPilotCompartment().getInputDown();
            inputLeft = this.getPilotCompartment().getInputLeft();
            inputRight = this.getPilotCompartment().getInputRight();
            if (inputDown || inputUp || inputLeft || inputRight) {
                this.ticks_no_input = 0;
            }
        }
        if (this.getPilotCompartment() != null && (this.m_6109_() || !(this.m_6688_() instanceof Player))) {
            float rudder = this.getRudderRotation();
            if (inputLeft && rudder < 45.0f) {
                rudder = rudder < 0.0f ? (rudder += 2.0f) : (rudder += 1.0f);
            }
            if (inputRight && rudder > -45.0f) {
                rudder = rudder > 0.0f ? (rudder -= 2.0f) : (rudder -= 1.0f);
            }
            if (!inputRight && !inputLeft) {
                if (this.m_6109_() && FMLEnvironment.dist == Dist.CLIENT && AlekishipsConfig.CLIENT.rudderControlScheme.get() == ClientConfig.RudderSchemes.RETURN_TO_CENTER) {
                    if (rudder > 0.0f) {
                        rudder -= 0.3f;
                    }
                    if (rudder < 0.0f) {
                        rudder += 0.3f;
                    }
                    if (Math.abs(rudder) < 1.0f) {
                        rudder = 0.0f;
                    }
                }
                if (!(this.m_6688_() instanceof Player)) {
                    if (rudder > 0.0f) {
                        rudder -= 0.3f;
                    }
                    if (rudder < 0.0f) {
                        rudder += 0.3f;
                    }
                    if (Math.abs(rudder) < 1.0f) {
                        rudder = 0.0f;
                    }
                }
            }
            this.setRudderRotation(rudder);
            this.tickSailBoat();
        }
    }

    protected void tickSailBoat() {
        if (this.getPilotCompartment() != null) {
            boolean inputUp = this.getPilotCompartment().getInputUp();
            boolean inputDown = this.getPilotCompartment().getInputDown();
            boolean inputLeft = this.getPilotCompartment().getInputLeft();
            boolean inputRight = this.getPilotCompartment().getInputRight();
            float sheet = this.getMainsheetLength();
            if (inputUp && sheet < 45.0f) {
                sheet += 1.0f;
            }
            if (inputDown && sheet > 0.0f) {
                sheet -= 1.0f;
            }
            this.setMainsheetLength(sheet);
        }
    }

    @Override
    public void tickCleatInput() {
        if (this.getJibsailActive() || this.getMainsailActive()) {
            return;
        }
        IHaveMultipleCleats.super.tickCleatInput();
    }

    public boolean m_6109_() {
        return super.m_6109_() && this.ticks_no_input <= 200;
    }

    @Override
    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        InteractionResult result = this.interactPaint(player, hand);
        ItemStack heldItem = player.m_21120_(hand);
        if (heldItem.m_204117_(AlekiShipsTags.Items.ICEBREAKER_UPGRADES) && !this.breaksIce()) {
            this.setIceBreaker(true);
            if (!player.m_150110_().f_35937_) {
                heldItem.m_41774_(1);
            }
            this.m_9236_().m_6269_(null, (Entity)this, SoundEvents.f_12065_, SoundSource.BLOCKS, 1.5f, this.m_9236_().m_213780_().m_188501_() * 0.1f + 0.9f);
            return InteractionResult.SUCCESS;
        }
        if (heldItem.m_150930_(Items.f_42656_)) {
            if (heldItem.m_41788_() && !this.m_7755_().equals(heldItem.m_41786_())) {
                if (!this.m_9236_().m_5776_() && this.m_6084_() && this.isFunctional()) {
                    this.m_6593_(heldItem.m_41786_());
                    if (!player.m_150110_().f_35937_) {
                        heldItem.m_41774_(1);
                    }
                    AlekiShipsAdvancements.checkDyeShipBlack(player, this);
                }
                return InteractionResult.m_19078_((boolean)player.m_9236_().f_46443_);
            }
            return InteractionResult.PASS;
        }
        return result == null ? super.m_6096_(player, hand) : result;
    }

    @Override
    public float getCleatMovementMultiplier() {
        return 5.0f;
    }

    @Override
    protected void tickTurnSpeedFactor() {
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ID_MAIN_BOOM_ROTATION, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_ID_RUDDER_ROTATION, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_ID_MAINSAIL_ACTIVE, (Object)false);
        this.f_19804_.m_135372_(DATA_ID_JIBSAIL_ACTIVE, (Object)false);
        this.f_19804_.m_135372_(DATA_ID_TICKS_NO_RIDERS, (Object)0);
        this.f_19804_.m_135372_(DATA_ID_MAINSHEET_LENGTH, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_ID_JIBSAIL_DYE, (Object)DyeColor.WHITE);
        this.f_19804_.m_135372_(DATA_ID_MAINSAIL_DYE, (Object)DyeColor.WHITE);
        this.f_19804_.m_135372_(DATA_ID_PAINT_COLOR, Optional.empty());
        this.f_19804_.m_135372_(DATA_ID_ICEBREAKER, (Object)false);
    }

    @Override
    public int[] getWindlassIndices() {
        return this.WINDLASSES;
    }

    public float getSailWorldRotation() {
        return Mth.m_14177_((float)(this.getMainBoomRotation() + Mth.m_14177_((float)this.m_146908_())));
    }

    @Nullable
    public Entity getSailingVehiclePartAsEntity() {
        if (this.m_20160_() && this.m_20197_().size() == this.getMaxPassengers()) {
            return (Entity)this.m_20197_().get(13);
        }
        return null;
    }

    @Override
    public Item getDropItem() {
        return this.boatMaterial.getDeckItem();
    }

    @Nullable
    public EmptyCompartmentEntity getSailingCompartment() {
        Entity vehiclePart = this.getSailingVehiclePartAsEntity();
        if (!(vehiclePart instanceof VehiclePart) || !vehiclePart.m_20160_()) {
            return null;
        }
        Entity entity = vehiclePart.m_146895_();
        if (!(entity instanceof EmptyCompartmentEntity)) {
            return null;
        }
        EmptyCompartmentEntity emptyCompartmentEntity = (EmptyCompartmentEntity)entity;
        return emptyCompartmentEntity;
    }

    @Override
    protected void tickPaddlingEffects() {
    }

    @Override
    protected float getPaddleMultiplier() {
        return 0.0f;
    }

    @Override
    protected float[] getPaddleAcceleration() {
        return new float[]{0.0f, 0.0f, 0.0f};
    }

    @Override
    protected float getMomentumSubtractor() {
        return 5.0E-4f;
    }

    @Override
    protected void tickWindInput() {
        super.tickWindInput();
        if (this.status == AbstractVehicle.MediumStatus.IN_WATER || this.status == AbstractVehicle.MediumStatus.IN_AIR) {
            Vec3 sailAccelerationWithSail;
            Vec3 sailAccelerationWithKeel;
            float sailFactor;
            float keelFactor;
            float windFunction = (float)(Mth.m_14008_((double)this.getLocalWindSpeed(), (double)0.02, (double)1.0) * 0.45);
            float sailForce = this.getMainsailWindAngleAndForce()[1];
            float sailForceAngle = Mth.m_14177_((float)this.getMainsailWindAngleAndForce()[0]);
            float acceleration = windFunction * sailForce;
            if (this.getMainsailActive()) {
                if (acceleration > this.getAcceleration()) {
                    this.setAcceleration(acceleration);
                } else if (this.getAcceleration() > this.getMomentumSubtractor()) {
                    this.setAcceleration(this.getAcceleration() - this.getMomentumSubtractor());
                    acceleration = this.getAcceleration();
                }
                keelFactor = 0.75f;
                sailFactor = 1.0f - keelFactor;
                sailAccelerationWithKeel = new Vec3((double)(Mth.m_14031_((float)(-this.m_146908_() * ((float)Math.PI / 180))) * acceleration * keelFactor), 0.0, (double)(Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))) * acceleration * keelFactor));
                sailAccelerationWithSail = new Vec3((double)(Mth.m_14031_((float)(-Mth.m_14177_((float)sailForceAngle) * ((float)Math.PI / 180))) * acceleration * sailFactor), 0.0, (double)(Mth.m_14089_((float)(Mth.m_14177_((float)sailForceAngle) * ((float)Math.PI / 180))) * acceleration * sailFactor));
                this.m_20256_(this.m_20184_().m_82549_(sailAccelerationWithKeel).m_82549_(sailAccelerationWithSail));
            }
            if (this.getJibsailActive()) {
                windFunction = (float)(Mth.m_14008_((double)this.getLocalWindSpeed(), (double)0.02, (double)1.0) * 0.1);
                acceleration = windFunction * sailForce;
                if (!this.getMainsailActive()) {
                    if (acceleration > this.getAcceleration()) {
                        this.setAcceleration(acceleration);
                    } else if (this.getAcceleration() > this.getMomentumSubtractor()) {
                        this.setAcceleration(this.getAcceleration() - this.getMomentumSubtractor());
                        acceleration = this.getAcceleration();
                    }
                }
                keelFactor = 0.9f;
                sailFactor = 1.0f - keelFactor;
                sailAccelerationWithKeel = new Vec3((double)(Mth.m_14031_((float)(-this.m_146908_() * ((float)Math.PI / 180))) * acceleration * keelFactor), 0.0, (double)(Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))) * acceleration * keelFactor));
                sailAccelerationWithSail = new Vec3((double)(Mth.m_14031_((float)(-Mth.m_14177_((float)sailForceAngle) * ((float)Math.PI / 180))) * acceleration * sailFactor), 0.0, (double)(Mth.m_14089_((float)(Mth.m_14177_((float)sailForceAngle) * ((float)Math.PI / 180))) * acceleration * sailFactor));
                this.m_20256_(this.m_20184_().m_82549_(sailAccelerationWithKeel).m_82549_(sailAccelerationWithSail));
            }
            if (this.isAnchorDown()) {
                this.m_20256_(this.m_20184_().m_82542_(0.5, 1.0, 0.5));
            }
        }
    }

    @Override
    protected double windDriftMultiplier() {
        return 0.3;
    }

    @Override
    public void tickAnchorInput() {
        if (this.getMainsailActive() || this.getJibsailActive()) {
            return;
        }
        IHaveAnchorWindlass.super.tickAnchorInput();
    }

    public float[] getMainsailWindAngleAndForce() {
        float windDifference = Mth.m_14118_((float)this.getWindLocalRotation(), (float)Mth.m_14177_((float)this.getMainBoomRotation()));
        float windForceAngle = Mth.m_14177_((float)(2.0f * windDifference + this.m_146908_()));
        if (Math.abs(windDifference) < 120.0f) {
            windForceAngle = this.getLocalWindSpeed();
        }
        float windForce = CommonHelper.sailForceMultiplierTable(windDifference);
        return new float[]{windForceAngle, windForce};
    }

    public float getMainBoomRotation() {
        if (this.m_6109_()) {
            return this.boom_rotation;
        }
        return Mth.m_14177_((float)((Float)this.f_19804_.m_135370_(DATA_ID_MAIN_BOOM_ROTATION)).floatValue());
    }

    public void setMainBoomRotation(float rotation) {
        this.boom_rotation = Mth.m_14036_((float)rotation, (float)(-1.0f * this.getMainsheetLength()), (float)this.getMainsheetLength());
        this.f_19804_.m_135381_(DATA_ID_MAIN_BOOM_ROTATION, (Object)Float.valueOf(Mth.m_14036_((float)rotation, (float)(-1.0f * this.getMainsheetLength()), (float)this.getMainsheetLength())));
    }

    public float getMainsheetLength() {
        if (this.m_6109_()) {
            return this.mainsheet_length;
        }
        return Mth.m_14177_((float)((Float)this.f_19804_.m_135370_(DATA_ID_MAINSHEET_LENGTH)).floatValue());
    }

    public void setMainsheetLength(float length) {
        this.mainsheet_length = Mth.m_14036_((float)length, (float)0.0f, (float)45.0f);
        this.f_19804_.m_135381_(DATA_ID_MAINSHEET_LENGTH, (Object)Float.valueOf(Mth.m_14036_((float)length, (float)0.0f, (float)45.0f)));
    }

    public void setRudderRotation(float rotation) {
        this.rudder_rotation = Mth.m_14036_((float)rotation, (float)-45.0f, (float)45.0f);
        this.f_19804_.m_135381_(DATA_ID_RUDDER_ROTATION, (Object)Float.valueOf(Mth.m_14036_((float)rotation, (float)-45.0f, (float)45.0f)));
    }

    public float getRudderRotation() {
        if (this.m_6109_()) {
            return this.rudder_rotation;
        }
        return ((Float)this.f_19804_.m_135370_(DATA_ID_RUDDER_ROTATION)).floatValue();
    }

    public void setMainsailActive(boolean mainsail) {
        this.f_19804_.m_135381_(DATA_ID_MAINSAIL_ACTIVE, (Object)mainsail);
    }

    public boolean getMainsailActive() {
        return (Boolean)this.f_19804_.m_135370_(DATA_ID_MAINSAIL_ACTIVE);
    }

    public void setJibsailActive(boolean jibsail) {
        this.f_19804_.m_135381_(DATA_ID_JIBSAIL_ACTIVE, (Object)jibsail);
    }

    public boolean getJibsailActive() {
        return (Boolean)this.f_19804_.m_135370_(DATA_ID_JIBSAIL_ACTIVE);
    }

    public void setTicksNoRiders(int ticks) {
        this.f_19804_.m_135381_(DATA_ID_TICKS_NO_RIDERS, (Object)ticks);
    }

    public int getTicksNoRiders() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_TICKS_NO_RIDERS);
    }

    public DyeColor getMainsailDye() {
        return (DyeColor)this.f_19804_.m_135370_(DATA_ID_MAINSAIL_DYE);
    }

    public void setMainsailDye(DyeColor paintColor) {
        this.f_19804_.m_135381_(DATA_ID_MAINSAIL_DYE, (Object)paintColor);
    }

    public void clearMainsailDye() {
        this.f_19804_.m_135381_(DATA_ID_MAINSAIL_DYE, (Object)DyeColor.WHITE);
    }

    public DyeColor getJibsailDye() {
        return (DyeColor)this.f_19804_.m_135370_(DATA_ID_JIBSAIL_DYE);
    }

    public void setJibsailDye(DyeColor paintColor) {
        this.f_19804_.m_135381_(DATA_ID_JIBSAIL_DYE, (Object)paintColor);
    }

    public void clearJibsailDye() {
        this.f_19804_.m_135381_(DATA_ID_JIBSAIL_DYE, (Object)DyeColor.WHITE);
    }

    @Override
    public void setPaintColor(DyeColor paintColor) {
        this.f_19804_.m_135381_(DATA_ID_PAINT_COLOR, Optional.of(paintColor));
    }

    public void setIceBreaker(boolean icebreaker) {
        this.f_19804_.m_135381_(DATA_ID_ICEBREAKER, (Object)icebreaker);
    }

    @Override
    public Optional<DyeColor> getPaintColor() {
        return (Optional)this.f_19804_.m_135370_(DATA_ID_PAINT_COLOR);
    }

    @Override
    public void clearPaint() {
        this.f_19804_.m_135381_(DATA_ID_PAINT_COLOR, Optional.empty());
    }

    @Override
    protected void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setMainBoomRotation(pCompound.m_128457_("mainBoomRotation"));
        this.setRudderRotation(pCompound.m_128457_("rudderRotation"));
        this.setMainsailActive(pCompound.m_128471_("mainsailActive"));
        this.setJibsailActive(pCompound.m_128471_("jibsailActive"));
        this.setTicksNoRiders(pCompound.m_128451_("ticksNoRiders"));
        this.setMainsheetLength(pCompound.m_128457_("mainSheetLength"));
        this.setIceBreaker(pCompound.m_128471_("icebreaker"));
        if (pCompound.m_128425_("jibsailDye", 1)) {
            this.setJibsailDye(DyeColor.m_41053_((int)pCompound.m_128445_("jibsailDye")));
        }
        if (pCompound.m_128425_("mainsailDye", 1)) {
            this.setMainsailDye(DyeColor.m_41053_((int)pCompound.m_128445_("mainsailDye")));
        }
        if (pCompound.m_128425_("paint", 1)) {
            this.setPaintColor(DyeColor.m_41053_((int)pCompound.m_128445_("paint")));
        }
    }

    @Override
    protected void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128350_("mainBoomRotation", this.getMainBoomRotation());
        pCompound.m_128350_("rudderRotation", this.getRudderRotation());
        pCompound.m_128379_("mainsailActive", this.getMainsailActive());
        pCompound.m_128379_("jibsailActive", this.getJibsailActive());
        pCompound.m_128405_("ticksNoRiders", this.getTicksNoRiders());
        pCompound.m_128350_("mainSheetLength", this.getMainsheetLength());
        pCompound.m_128379_("icebreaker", this.breaksIce());
        DyeColor paintColor = this.getJibsailDye();
        if (paintColor != DyeColor.WHITE) {
            pCompound.m_128344_("jibsailDye", (byte)paintColor.m_41060_());
        }
        if ((paintColor = this.getMainsailDye()) != DyeColor.WHITE) {
            pCompound.m_128344_("mainsailDye", (byte)paintColor.m_41060_());
        }
        this.getPaintColor().ifPresent(dyeColor -> pCompound.m_128344_("paint", (byte)dyeColor.m_41060_()));
    }

    @Override
    public ArrayList<IngameOverlays.IconState> getIconStates(Player player) {
        ArrayList<IngameOverlays.IconState> states = new ArrayList<IngameOverlays.IconState>();
        for (ItemStack itemStack : player.m_6167_()) {
            if (!itemStack.m_204117_(AlekiShipsTags.Items.ICEBREAKER_UPGRADES) || this.breaksIce()) continue;
            states.add(IngameOverlays.IconState.HAMMER);
            return states;
        }
        for (ItemStack itemStack : player.m_6167_()) {
            if (!itemStack.m_150930_(Items.f_42656_)) continue;
            states.add(IngameOverlays.IconState.BRUSH);
            return states;
        }
        return super.getIconStates(player);
    }

    @Override
    public boolean breaksIce() {
        return (Boolean)this.f_19804_.m_135370_(DATA_ID_ICEBREAKER);
    }
}

