/*
 * Decompiled with CFR 0.152.
 */
package com.alekiponi.alekiships.common.entity.vehiclehelper.compartment;

import com.alekiponi.alekiships.AlekiShips;
import com.alekiponi.alekiships.common.entity.vehiclehelper.CompartmentType;
import com.alekiponi.alekiships.common.entity.vehiclehelper.compartment.AbstractCompartmentEntity;
import com.alekiponi.alekiships.common.entity.vehiclehelper.compartment.BlockCompartment;
import com.alekiponi.alekiships.util.AlekiShipsTags;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class BlockCompartmentEntity
extends AbstractCompartmentEntity
implements BlockCompartment {
    private static final EntityDataAccessor<BlockState> DATA_ID_DISPLAY_BLOCK = SynchedEntityData.m_135353_(BlockCompartmentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135034_);

    public BlockCompartmentEntity(CompartmentType<? extends BlockCompartmentEntity> compartmentType, Level level) {
        super(compartmentType, level);
    }

    public BlockCompartmentEntity(CompartmentType<? extends BlockCompartmentEntity> compartmentType, Level level, ItemStack itemStack) {
        super(compartmentType, level);
        Item item = itemStack.m_41720_();
        if (!(item instanceof BlockItem)) {
            if (SharedConstants.f_136183_) {
                AlekiShips.LOGGER.warn("Inspect {} a dev likely broke the tag. Otherwise {} is at fault", AlekiShipsTags.Items.CAN_PLACE_IN_COMPARTMENTS, compartmentType);
            }
            AlekiShips.LOGGER.debug("A block compartment was created using a stack of {} but it's not a BlockItem", (Object)itemStack);
            AlekiShips.LOGGER.debug("Please inspect {} for any items that don't have a block form", AlekiShipsTags.Items.CAN_PLACE_IN_COMPARTMENTS);
            return;
        }
        BlockItem blockItem = (BlockItem)item;
        this.setDisplayBlockState(blockItem.m_40614_().m_49966_());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ID_DISPLAY_BLOCK, (Object)Blocks.f_50016_.m_49966_());
    }

    @Override
    protected void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        BlockCompartment.saveBlockstate(this, compoundTag);
    }

    @Override
    protected void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        BlockCompartment.readBlockstate(this, compoundTag);
    }

    @Override
    protected void onHurt(DamageSource damageSource) {
        BlockCompartment.playHitSound(this);
    }

    @Override
    protected void onBreak() {
        BlockCompartment.playBreakSound(this);
    }

    @Override
    public ItemStack getDropStack() {
        return new ItemStack((ItemLike)this.getDisplayBlockState().m_60734_());
    }

    @Override
    @Nullable
    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)this.getDisplayBlockState().m_60734_());
    }

    @Override
    protected void onPlaced() {
        BlockCompartment.playPlaceSound(this);
    }

    @Override
    public BlockState getDisplayBlockState() {
        return (BlockState)this.f_19804_.m_135370_(DATA_ID_DISPLAY_BLOCK);
    }

    @Override
    public void setDisplayBlockState(BlockState blockState) {
        this.f_19804_.m_135381_(DATA_ID_DISPLAY_BLOCK, (Object)blockState);
    }
}

