/*
 * Decompiled with CFR 0.152.
 */
package com.alekiponi.alekiships.common.entity.vehiclehelper.compartment;

import com.alekiponi.alekiships.AlekiShips;
import com.alekiponi.alekiships.client.IngameOverlays;
import com.alekiponi.alekiships.common.entity.AlekiShipsEntities;
import com.alekiponi.alekiships.common.entity.CannonEntity;
import com.alekiponi.alekiships.common.entity.vehicle.AbstractVehicle;
import com.alekiponi.alekiships.common.entity.vehicle.RowboatEntity;
import com.alekiponi.alekiships.common.entity.vehiclecapability.ICannonable;
import com.alekiponi.alekiships.common.entity.vehiclecapability.IHaveBlockOnlyCompartments;
import com.alekiponi.alekiships.common.entity.vehiclehelper.AbstractPassthroughHelper;
import com.alekiponi.alekiships.common.entity.vehiclehelper.CompartmentType;
import com.alekiponi.alekiships.common.entity.vehiclehelper.VehiclePart;
import com.alekiponi.alekiships.common.entity.vehiclehelper.compartment.AbstractCompartmentEntity;
import com.alekiponi.alekiships.common.item.AlekiShipsItems;
import com.alekiponi.alekiships.network.PacketHandler;
import com.alekiponi.alekiships.network.ServerboundCompartmentInputPacket;
import com.alekiponi.alekiships.util.AlekiShipsTags;
import com.alekiponi.alekiships.util.advancements.AlekiShipsAdvancements;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class EmptyCompartmentEntity
extends AbstractCompartmentEntity {
    protected static final EntityDataAccessor<Boolean> DATA_ID_INPUT_LEFT = SynchedEntityData.m_135353_(EmptyCompartmentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Boolean> DATA_ID_INPUT_RIGHT = SynchedEntityData.m_135353_(EmptyCompartmentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Boolean> DATA_ID_INPUT_UP = SynchedEntityData.m_135353_(EmptyCompartmentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Boolean> DATA_ID_INPUT_DOWN = SynchedEntityData.m_135353_(EmptyCompartmentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected boolean canAddNonPlayers = true;
    protected boolean canAddOnlyBlocks = false;
    protected boolean canAddCannons = false;

    public EmptyCompartmentEntity(CompartmentType<? extends EmptyCompartmentEntity> compartmentType, Level level) {
        super(compartmentType, level);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ID_INPUT_LEFT, (Object)false);
        this.f_19804_.m_135372_(DATA_ID_INPUT_RIGHT, (Object)false);
        this.f_19804_.m_135372_(DATA_ID_INPUT_UP, (Object)false);
        this.f_19804_.m_135372_(DATA_ID_INPUT_DOWN, (Object)false);
    }

    public boolean canAddNonPlayers() {
        return this.canAddNonPlayers;
    }

    public boolean canAddOnlyBLocks() {
        return this.canAddOnlyBlocks;
    }

    public boolean canAddCannons() {
        return this.canAddCannons;
    }

    protected void m_20348_(Entity pPassenger) {
        super.m_20348_(pPassenger);
        if (this.m_20159_()) {
            this.m_146922_(this.m_20202_().m_146908_());
        }
    }

    protected boolean m_7310_(Entity passenger) {
        return this.m_20197_().isEmpty() && !this.m_213877_();
    }

    protected void m_19956_(Entity passenger, Entity.MoveFunction moveFunction) {
        double thisY;
        double eyepos;
        super.m_19956_(passenger, moveFunction);
        float localX = 0.0f;
        float localZ = 0.0f;
        float localY = (float)((this.m_213877_() ? 0.01 : this.m_6048_()) + passenger.m_6049_());
        if (passenger instanceof Player) {
            localY = 0.0f;
            AbstractVehicle abstractVehicle = this.getTrueVehicle();
            if (abstractVehicle instanceof RowboatEntity) {
                RowboatEntity rowboatEntity = (RowboatEntity)abstractVehicle;
                localY = 0.25f;
                if (rowboatEntity.getPilotVehiclePartAsEntity() != this.ridingThisPart) {
                    localX = -0.25f;
                }
            }
        }
        if ((double)passenger.m_20206_() <= 0.7) {
            localY -= 0.2f;
        }
        if (passenger instanceof CannonEntity) {
            localY += 0.15f;
        }
        if (passenger.m_20205_() > 0.9f) {
            localX += 0.2f;
            if (this.getTrueVehicle() instanceof RowboatEntity) {
                localX -= 0.6f;
            }
        }
        if ((eyepos = passenger.m_146892_().m_82507_(Direction.Axis.Y)) < (thisY = this.m_20186_() + (double)1.1f)) {
            localY += (float)Math.abs(eyepos - thisY);
        }
        Vec3 vec3 = this.positionPassengerLocally(localX, localY - 0.57f, localZ);
        moveFunction.m_20372_(passenger, this.m_20185_() + vec3.f_82479_, this.m_20186_() - 0.57 + (double)localY, this.m_20189_() + vec3.f_82481_);
        if (passenger instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)passenger;
            livingEntity.m_5618_(this.m_146908_());
            livingEntity.m_5616_(livingEntity.m_6080_() + this.m_146908_());
            this.clampRotation((Entity)livingEntity);
        } else if (passenger instanceof CannonEntity) {
            CannonEntity cannon = (CannonEntity)passenger;
            cannon.m_146922_(this.m_146908_() - 180.0f);
            if (cannon.m_146909_() > 5.0f) {
                cannon.m_146926_(5.0f);
            }
        }
        if (passenger instanceof ArmorStand) {
            ArmorStand armorStand = (ArmorStand)passenger;
            armorStand.m_5618_(this.m_146908_());
            armorStand.m_146922_(this.m_146908_());
            armorStand.m_31678_(true);
        }
    }

    public double m_6048_() {
        return 0.44999999999999996;
    }

    protected Vec3 positionPassengerLocally(float localX, float localY, float localZ) {
        return new Vec3((double)localX, (double)localY, (double)localZ).m_82524_(-this.m_146908_() * ((float)Math.PI / 180) - 1.5707964f);
    }

    @Override
    public void m_8119_() {
        if (this.getTrueVehicle() != null) {
            AbstractVehicle vehicle = this.getTrueVehicle();
            if (this.f_19797_ < 10 && vehicle.getPilotVehiclePartAsEntity() != null && !vehicle.pilotCompartmentAcceptsNonPlayers()) {
                boolean bl = this.canAddNonPlayers = vehicle.getPilotVehiclePartAsEntity() != this.m_20202_();
            }
            if (this.f_19797_ < 10 && this.m_20159_()) {
                if (vehicle instanceof IHaveBlockOnlyCompartments) {
                    for (AbstractCompartmentEntity compartment : ((IHaveBlockOnlyCompartments)((Object)vehicle)).getCanAddOnlyBlocks()) {
                        if (compartment.m_20202_() != this.m_20202_()) continue;
                        this.canAddOnlyBlocks = true;
                    }
                }
                if (vehicle instanceof ICannonable) {
                    for (AbstractCompartmentEntity compartment : ((ICannonable)((Object)vehicle)).getCanAddCannons()) {
                        if (compartment.m_20202_() != this.m_20202_()) continue;
                        this.canAddCannons = true;
                    }
                }
            }
        }
        if (this.everyNthTickUnique(5)) {
            List list;
            if (this.m_20160_() && !this.m_9236_().m_5776_() && this.m_146895_() != null && this.getTrueVehicle() != null && this.m_146895_().m_20205_() > this.getTrueVehicle().getPassengerSizeLimit()) {
                this.m_20153_();
            }
            if (!(list = this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82377_(0.2, -0.01, 0.2), EntitySelector.m_20421_((Entity)this))).isEmpty() && this.canAddNonPlayers() && !this.canAddOnlyBLocks() && !this.m_9236_().m_5776_() && this.getTrueVehicle() != null) {
                for (Entity entity : list) {
                    if (entity.m_20363_((Entity)this)) continue;
                    float maxSize = 0.6f;
                    maxSize = this.getTrueVehicle().getPassengerSizeLimit();
                    if (this.m_20197_().size() != 0 || entity.m_20159_() || !(entity.m_20205_() <= maxSize) || !(entity instanceof LivingEntity) || entity instanceof WaterAnimal || entity instanceof Player) continue;
                    entity.m_20329_((Entity)this);
                }
            }
        }
        if (!(this.m_146895_() instanceof Player)) {
            this.setInputLeft(false);
            this.setInputRight(false);
            this.setInputUp(false);
            this.setInputDown(false);
        }
        super.m_8119_();
    }

    @Override
    protected void m_7378_(CompoundTag pCompound) {
        pCompound.m_128471_("inputLeft");
        pCompound.m_128471_("inputRight");
        pCompound.m_128471_("inputUp");
        pCompound.m_128471_("inputDown");
        super.m_7378_(pCompound);
    }

    @Override
    protected void m_7380_(CompoundTag pCompound) {
        pCompound.m_128379_("inputLeft", this.getInputLeft());
        pCompound.m_128379_("inputRight", this.getInputRight());
        pCompound.m_128379_("inputUp", this.getInputUp());
        pCompound.m_128379_("inputDown", this.getInputDown());
        super.m_7378_(pCompound);
    }

    protected void clampRotation(Entity entity) {
        entity.m_5618_(this.m_146908_());
        float f = Mth.m_14177_((float)(entity.m_146908_() - this.m_146908_()));
        float f1 = Mth.m_14036_((float)f, (float)-105.0f, (float)105.0f);
        entity.f_19859_ += f1 - f;
        entity.m_146922_(entity.m_146908_() + f1 - f);
        entity.m_5616_(entity.m_146908_());
    }

    public void setInput(boolean inputLeft, boolean inputRight, boolean inputUp, boolean inputDown) {
        if (this.m_146895_() instanceof Player) {
            boolean shouldUpdateServer = false;
            if (this.getInputLeft() != inputLeft) {
                this.setInputLeft(inputLeft);
                shouldUpdateServer = true;
            }
            if (this.getInputRight() != inputRight) {
                this.setInputRight(inputRight);
                shouldUpdateServer = true;
            }
            if (this.getInputUp() != inputUp) {
                this.setInputUp(inputUp);
                shouldUpdateServer = true;
            }
            if (this.getInputDown() != inputDown) {
                this.setInputDown(inputDown);
                shouldUpdateServer = true;
            }
            if (this.m_9236_().m_5776_() && shouldUpdateServer) {
                PacketHandler.send(PacketDistributor.SERVER.noArg(), new ServerboundCompartmentInputPacket(inputLeft, inputRight, inputUp, inputDown, this.m_19879_()));
            }
        } else {
            this.setInputLeft(false);
            this.setInputRight(false);
            this.setInputUp(false);
            this.setInputDown(false);
            if (this.m_9236_().m_5776_()) {
                PacketHandler.send(PacketDistributor.SERVER.noArg(), new ServerboundCompartmentInputPacket(false, false, false, false, this.m_19879_()));
            }
        }
    }

    public boolean getInputLeft() {
        return (Boolean)this.f_19804_.m_135370_(DATA_ID_INPUT_LEFT);
    }

    public boolean getInputRight() {
        return (Boolean)this.f_19804_.m_135370_(DATA_ID_INPUT_RIGHT);
    }

    public boolean getInputUp() {
        return (Boolean)this.f_19804_.m_135370_(DATA_ID_INPUT_UP);
    }

    public boolean getInputDown() {
        return (Boolean)this.f_19804_.m_135370_(DATA_ID_INPUT_DOWN);
    }

    public void setInputLeft(boolean input) {
        this.f_19804_.m_135381_(DATA_ID_INPUT_LEFT, (Object)input);
    }

    public void setInputRight(boolean input) {
        this.f_19804_.m_135381_(DATA_ID_INPUT_RIGHT, (Object)input);
    }

    public void setInputUp(boolean input) {
        this.f_19804_.m_135381_(DATA_ID_INPUT_UP, (Object)input);
    }

    public void setInputDown(boolean input) {
        this.f_19804_.m_135381_(DATA_ID_INPUT_DOWN, (Object)input);
    }

    public void m_7340_(Entity entity) {
        this.clampRotation(entity);
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        RowboatEntity rowboat;
        AbstractVehicle abstractVehicle;
        ItemStack heldStack = player.m_21120_(hand);
        if (heldStack.m_150930_((Item)AlekiShipsItems.OAR.get()) && (abstractVehicle = this.getTrueVehicle()) instanceof RowboatEntity && !(rowboat = (RowboatEntity)abstractVehicle).getOars().equals((Object)RowboatEntity.Oars.TWO)) {
            return rowboat.m_6096_(player, hand);
        }
        if (this.canAddNonPlayers() && !this.canAddOnlyBLocks() && heldStack.m_150930_((Item)AlekiShipsItems.CANNON.get()) && this.m_20201_() instanceof ICannonable && (abstractVehicle = this.m_20202_()) instanceof VehiclePart) {
            VehiclePart part = (VehiclePart)((Object)abstractVehicle);
            if (this.canAddCannons) {
                CannonEntity cannon = (CannonEntity)((EntityType)AlekiShipsEntities.CANNON_ENTITY.get()).m_20615_(this.m_9236_());
                assert (cannon != null);
                cannon.m_20219_(this.m_20182_());
                cannon.m_146922_(this.m_146908_() - 180.0f);
                if (!this.m_9236_().m_5776_()) {
                    this.m_9236_().m_7967_((Entity)cannon);
                    if (!cannon.m_20329_(this)) {
                        AlekiShips.LOGGER.error("New Cannon: {} unable to ride Compartment: {}", (Object)cannon, (Object)this);
                    }
                }
                player.m_36246_(Stats.f_12982_.m_12902_((Object)((Item)AlekiShipsItems.CANNON.get())));
                if (!player.m_150110_().f_35937_) {
                    heldStack.m_41774_(1);
                }
                return InteractionResult.SUCCESS;
            }
        }
        if (this.canAddNonPlayers() && !this.canAddOnlyBLocks() && heldStack.m_150930_(Items.f_42650_)) {
            ArmorStand armorStand = (ArmorStand)EntityType.f_20529_.m_20615_(this.m_9236_());
            assert (armorStand != null);
            armorStand.m_20219_(this.m_20182_());
            armorStand.m_146922_(this.m_146908_() - 180.0f);
            armorStand.m_5618_(this.m_146908_() - 180.0f);
            armorStand.m_5616_(this.m_146908_() - 180.0f);
            if (!this.m_9236_().m_5776_()) {
                this.m_9236_().m_7967_((Entity)armorStand);
                if (!armorStand.m_20329_((Entity)this)) {
                    AlekiShips.LOGGER.error("New Armor Stand: {} unable to ride Compartment: {}", (Object)armorStand, (Object)this);
                }
            }
            player.m_36246_(Stats.f_12982_.m_12902_((Object)Items.f_42650_));
            if (!player.m_150110_().f_35937_) {
                heldStack.m_41774_(1);
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                AlekiShipsAdvancements.ARMOR_STAND_ON_BOAT.trigger(serverPlayer);
            }
            return InteractionResult.SUCCESS;
        }
        if (player.m_36341_()) {
            if (!this.m_20197_().isEmpty() && !(this.m_146895_() instanceof Player)) {
                this.m_20153_();
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        if (this.ridingThisPart == null) {
            return InteractionResult.FAIL;
        }
        Optional<CompartmentType<?>> compartmentType = CompartmentType.fromStack(heldStack);
        if (compartmentType.isPresent()) {
            AbstractVehicle vehicle;
            Entity entity = this.m_20201_();
            if (entity instanceof AbstractVehicle && !(vehicle = (AbstractVehicle)entity).pilotCompartmentAcceptsNonPlayers() && vehicle.getPilotCompartment().m_7306_(this)) {
                return InteractionResult.FAIL;
            }
            Object compartmentEntity = compartmentType.get().create(this.m_9236_(), heldStack.m_41777_());
            if (null == compartmentEntity) {
                if (!this.canAddOnlyBLocks()) {
                    return player.m_20329_((Entity)this) ? InteractionResult.SUCCESS : InteractionResult.PASS;
                }
                return InteractionResult.FAIL;
            }
            heldStack.m_41774_(1);
            this.swapCompartments((AbstractCompartmentEntity)compartmentEntity);
            ((AbstractCompartmentEntity)compartmentEntity).onPlaced();
            this.m_146850_(GameEvent.f_157811_);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (!this.canAddOnlyBLocks()) {
            return player.m_20329_((Entity)this) ? InteractionResult.SUCCESS : InteractionResult.PASS;
        }
        return InteractionResult.FAIL;
    }

    public Vec3 m_7688_(LivingEntity passenger) {
        if (this.getTrueVehicle().m_20184_().m_82553_() > 0.01) {
            return this.getTrueVehicle().m_7688_(passenger);
        }
        double y = this.getTrueVehicle().m_7688_(passenger).m_7098_();
        Vec3 escapeVector = EmptyCompartmentEntity.m_19903_((double)(this.m_20205_() * Mth.f_13994_), (double)passenger.m_20205_(), (float)passenger.m_146908_());
        double escapeX = this.m_20185_() + escapeVector.f_82479_;
        double escapeZ = this.m_20189_() + escapeVector.f_82481_;
        BlockPos escapePos = BlockPos.m_274561_((double)escapeX, (double)this.m_20191_().f_82292_, (double)escapeZ);
        BlockPos escapePosBelow = escapePos.m_7495_();
        if (this.m_9236_().m_46801_(escapePosBelow)) {
            return super.m_7688_(passenger);
        }
        ArrayList dismountOffsets = Lists.newArrayList();
        double floorHeight = this.m_9236_().m_45573_(escapePos);
        if (DismountHelper.m_38439_((double)floorHeight)) {
            dismountOffsets.add(new Vec3(escapeX, (double)escapePos.m_123342_() + floorHeight, escapeZ));
        }
        if (DismountHelper.m_38439_((double)(floorHeight = this.m_9236_().m_45573_(escapePosBelow)))) {
            dismountOffsets.add(new Vec3(escapeX, (double)escapePosBelow.m_123342_() + floorHeight, escapeZ));
        }
        for (Pose dismountPose : passenger.m_7431_()) {
            for (Vec3 output : dismountOffsets) {
                if (!DismountHelper.m_150279_((CollisionGetter)this.m_9236_(), (Vec3)output, (LivingEntity)passenger, (Pose)dismountPose)) continue;
                passenger.m_20124_(dismountPose);
                return new Vec3(output.f_82479_, y, output.f_82481_);
            }
        }
        return super.m_7688_(passenger);
    }

    @Override
    public AbstractCompartmentEntity.RidingPose getRidingPose() {
        if (this.getTrueVehicle() != null && this.vehiclePassengerIndex != -1) {
            return this.getTrueVehicle().getRidingPoses()[this.vehiclePassengerIndex];
        }
        return AbstractCompartmentEntity.RidingPose.STANDARD;
    }

    @Override
    public boolean m_6469_(DamageSource damageSource, float amount) {
        return AbstractPassthroughHelper.hurt(this, damageSource, amount);
    }

    @Nullable
    public LivingEntity m_6688_() {
        Entity entity = this.m_146895_();
        if (!(entity instanceof LivingEntity)) {
            return null;
        }
        LivingEntity livingentity = (LivingEntity)entity;
        return livingentity;
    }

    @Override
    protected void onPlaced() {
    }

    @Override
    protected void onHurt(DamageSource damageSource) {
    }

    @Override
    protected void onBreak() {
    }

    @Override
    public ItemStack getDropStack() {
        return ItemStack.f_41583_;
    }

    @Override
    @Nullable
    public ItemStack m_142340_() {
        return null;
    }

    @Override
    public ArrayList<IngameOverlays.IconState> getIconStates(Player player) {
        ArrayList<IngameOverlays.IconState> states = new ArrayList<IngameOverlays.IconState>();
        ItemStack handItem = player.m_21120_(player.m_7655_());
        if (this.getTrueVehicle() != null && !this.m_20160_()) {
            if (this.getTrueVehicle().getPilotCompartment() != null && this.getTrueVehicle().getPilotCompartment().m_7306_(this)) {
                states.add(IngameOverlays.IconState.HELM);
                if (this.getTrueVehicle().pilotCompartmentAcceptsNonPlayers() && handItem.m_204117_(AlekiShipsTags.Items.CAN_PLACE_IN_COMPARTMENTS)) {
                    states.add(IngameOverlays.IconState.BLOCK);
                }
                return states;
            }
            if (handItem.m_204117_(AlekiShipsTags.Items.CAN_PLACE_IN_COMPARTMENTS) || handItem.m_150930_((Item)AlekiShipsItems.CANNON.get()) || this.canAddOnlyBLocks()) {
                states.add(IngameOverlays.IconState.BLOCK);
                return states;
            }
            states.add(IngameOverlays.IconState.SEAT);
        }
        return states;
    }
}

