/*
 * Decompiled with CFR 0.152.
 */
package com.alekiponi.alekiships.common.entity.vehiclehelper.compartment.vanilla;

import com.alekiponi.alekiships.common.entity.vehiclehelper.CompartmentType;
import com.alekiponi.alekiships.common.entity.vehiclehelper.compartment.RandomizableContainerCompartmentEntity;
import com.alekiponi.alekiships.util.CommonHelper;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ShulkerBoxMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.ChestLidController;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import net.minecraftforge.network.NetworkHooks;

public class ShulkerBoxCompartmentEntity
extends RandomizableContainerCompartmentEntity.RandomizableContainerMenuCompartmentEntity
implements WorldlyContainer,
IEntityAdditionalSpawnData {
    public static final byte CONTAINER_OPEN = 1;
    public static final byte CONTAINER_CLOSE = 2;
    public static final String COLOR_KEY = "Color";
    public static final int SLOT_COUNT = 27;
    private static final int NULL_COLOR = -1;
    private static final int[] SLOTS = IntStream.range(0, 27).toArray();
    private final ChestLidController chestLidController = new ChestLidController();
    private final ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        protected void m_142292_(Level level, BlockPos blockPos, BlockState blockState) {
            ShulkerBoxCompartmentEntity.this.playSound(SoundEvents.f_12409_, SoundSource.BLOCKS, 0.5f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
        }

        protected void m_142289_(Level level, BlockPos blockPos, BlockState blockState) {
            ShulkerBoxCompartmentEntity.this.playSound(SoundEvents.f_12408_, SoundSource.BLOCKS, 0.5f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
        }

        protected void m_142148_(Level level, BlockPos blockPos, BlockState blockState, int count, int openCount) {
            ShulkerBoxCompartmentEntity.this.signalOpenCount(level, openCount);
        }

        protected boolean m_142718_(Player player) {
            if (!(player.f_36096_ instanceof ShulkerBoxMenu)) {
                return false;
            }
            Container container = ((ShulkerBoxMenu)player.f_36096_).f_40186_;
            return container == ShulkerBoxCompartmentEntity.this;
        }
    };
    @Nullable
    private DyeColor color;

    @Override
    public double getBuoyancy() {
        return this.f_19797_ % 21 > 10 ? -0.01 : 0.01;
    }

    public ShulkerBoxCompartmentEntity(CompartmentType<? extends ShulkerBoxCompartmentEntity> compartmentType, Level level) {
        super((CompartmentType<? extends RandomizableContainerCompartmentEntity.RandomizableContainerMenuCompartmentEntity>)compartmentType, level, 27);
    }

    public ShulkerBoxCompartmentEntity(CompartmentType<? extends ShulkerBoxCompartmentEntity> compartmentType, Level level, ItemStack itemStack) {
        super((CompartmentType<? extends RandomizableContainerCompartmentEntity.RandomizableContainerMenuCompartmentEntity>)compartmentType, level, 27, itemStack);
        BlockItem blockItem;
        Block block;
        Item item = itemStack.m_41720_();
        if (item instanceof BlockItem && (block = (blockItem = (BlockItem)item).m_40614_()) instanceof ShulkerBoxBlock) {
            ShulkerBoxBlock shulkerBoxBlock = (ShulkerBoxBlock)block;
            this.color = shulkerBoxBlock.m_56261_();
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.chestLidController.m_155374_();
        if (!this.m_213877_() && this.m_9236_().m_5776_()) {
            this.openersCounter.m_155476_(this.m_9236_(), this.m_20183_(), Blocks.f_50016_.m_49966_());
        }
    }

    public void m_219927_(DamageSource damageSource, Level level, Entity entity) {
        Entity directEntity;
        if (level.m_46469_().m_46207_(GameRules.f_46137_) && !level.f_46443_ && (directEntity = damageSource.m_7640_()) != null && directEntity.m_6095_() == EntityType.f_20532_) {
            PiglinAi.m_34873_((Player)((Player)directEntity), (boolean)true);
        }
    }

    public void m_7822_(byte dataID) {
        switch (dataID) {
            case 1: {
                this.chestLidController.m_155377_(true);
                break;
            }
            case 2: {
                this.chestLidController.m_155377_(false);
            }
        }
        super.m_7822_(dataID);
    }

    @Override
    protected void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        if (this.color == null) {
            compoundTag.m_128405_(COLOR_KEY, -1);
        } else {
            compoundTag.m_128405_(COLOR_KEY, this.color.m_41060_());
        }
    }

    @Override
    protected void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        int colorID = compoundTag.m_128451_(COLOR_KEY);
        if (-1 != colorID) {
            this.color = DyeColor.m_41053_((int)colorID);
        }
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.writeByte(this.color == null ? -1 : this.color.m_41060_());
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        byte colorID = additionalData.readByte();
        if (-1 != colorID) {
            this.color = DyeColor.m_41053_((int)colorID);
        }
    }

    public void m_5856_(Player player) {
        if (!this.m_213877_() && !player.m_5833_() || !this.m_20159_()) {
            this.openersCounter.m_155452_(player, this.m_9236_(), this.m_20183_(), Blocks.f_50016_.m_49966_());
        }
    }

    @Override
    public void m_5785_(Player player) {
        if (!this.m_213877_() && !player.m_5833_() || !this.m_20159_()) {
            this.openersCounter.m_155468_(player, this.m_9236_(), this.m_20183_(), Blocks.f_50016_.m_49966_());
        }
    }

    public boolean m_7013_(int slotIndex, ItemStack itemStack) {
        return !(Block.m_49814_((Item)itemStack.m_41720_()) instanceof ShulkerBoxBlock) && itemStack.m_41720_().m_142095_();
    }

    @Override
    protected AbstractContainerMenu createMenu(int id, Inventory playerInventory) {
        return new ShulkerBoxMenu(id, playerInventory, (Container)this);
    }

    @Override
    public ItemStack getDropStack() {
        ItemStack dropStack = new ItemStack((ItemLike)ShulkerBoxBlock.m_56190_((DyeColor)this.color));
        CompoundTag compoundTag = new CompoundTag();
        ContainerHelper.m_18976_((CompoundTag)compoundTag, this.m_213659_(), (boolean)false);
        if (!compoundTag.m_128456_()) {
            dropStack.m_41700_("BlockEntityTag", (Tag)compoundTag);
        }
        return dropStack;
    }

    @Override
    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)ShulkerBoxBlock.m_56190_((DyeColor)this.color));
    }

    public float getOpenNess(float partialTicks) {
        return this.chestLidController.m_155375_(partialTicks);
    }

    private void signalOpenCount(Level level, int openCount) {
        level.m_7605_((Entity)this, openCount > 0 ? (byte)1 : 2);
    }

    @Override
    protected void onHurt(DamageSource damageSource) {
        CommonHelper.playHitSound(this::playSound, SoundType.f_56742_);
    }

    @Override
    protected void onBreak() {
        CommonHelper.playBreakSound(this::playSound, SoundType.f_56742_);
        if (this.m_9236_().m_46469_().m_46207_(GameRules.f_46137_)) {
            ItemStack itemStack = this.getDropStack();
            if (this.m_8077_()) {
                itemStack.m_41714_(this.m_7770_());
            }
            Containers.m_18992_((Level)this.m_9236_(), (double)this.m_20185_(), (double)CommonHelper.maxHeightOfCollidableEntities(this), (double)this.m_20189_(), (ItemStack)itemStack);
        }
    }

    public int[] m_7071_(Direction pSide) {
        return SLOTS;
    }

    public boolean m_7155_(int slotIndex, ItemStack itemStack, @Nullable Direction direction) {
        return !(Block.m_49814_((Item)itemStack.m_41720_()) instanceof ShulkerBoxBlock) && itemStack.m_41720_().m_142095_();
    }

    public boolean m_7157_(int slotIndex, ItemStack itemStack, Direction direction) {
        return true;
    }

    @Override
    protected void onPlaced() {
        CommonHelper.playPlaceSound(this::playSound, SoundType.f_56742_);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @Nullable
    public DyeColor getColor() {
        return this.color;
    }

    @Override
    protected IItemHandler createItemHandler() {
        return new SidedInvWrapper((WorldlyContainer)this, Direction.UP);
    }
}

