/*
 * Decompiled with CFR 0.152.
 */
package com.alekiponi.alekiships.mixins.minecraft;

import com.alekiponi.alekiships.common.entity.vehicle.AbstractVehicle;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerEntity.class})
public abstract class ServerEntityMixin {
    @Shadow
    private final Entity f_8510_;
    @Shadow
    private final ServerLevel f_8509_;
    @Shadow
    private List<Entity> f_8523_ = Collections.emptyList();
    @Shadow
    private final Consumer<Packet<?>> f_8513_;

    protected ServerEntityMixin(Entity entity, ServerLevel level, Consumer<Packet<?>> broadcast) {
        this.f_8510_ = entity;
        this.f_8509_ = level;
        this.f_8513_ = broadcast;
    }

    @Inject(method={"sendChanges"}, at={@At(value="HEAD")}, cancellable=true)
    public void injectWaitToSendChanges(CallbackInfo ci) {
        AbstractVehicle vehicle;
        Entity entity = this.f_8510_;
        if (entity instanceof AbstractVehicle && !(vehicle = (AbstractVehicle)entity).hasAllParts() && vehicle.isFunctional()) {
            ci.cancel();
        }
    }

    @Inject(method={"sendChanges"}, at={@At(value="HEAD")})
    public void injectUpdatePassengersForFlaggedVehicles(CallbackInfo ci) {
        AbstractVehicle vehicle;
        Entity entity = this.f_8510_;
        if (entity instanceof AbstractVehicle && (vehicle = (AbstractVehicle)entity).isFlaggedForPassengerUpdate() && vehicle.isFunctional()) {
            List list = vehicle.m_20197_();
            this.f_8513_.accept((Packet<?>)new ClientboundSetPassengersPacket(this.f_8510_));
            ServerEntityMixin.m_277180_(list, this.f_8523_).forEach(player -> {
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    serverPlayer.f_8906_.m_9774_(serverPlayer.m_20185_(), serverPlayer.m_20186_(), serverPlayer.m_20189_(), serverPlayer.m_146908_(), serverPlayer.m_146909_());
                }
            });
            this.f_8523_ = list;
            vehicle.setFlaggedForPassengerUpdate(false);
        }
    }

    @Shadow
    private static Stream<Entity> m_277180_(List<Entity> pInitialPassengers, List<Entity> pCurrentPassengers) {
        return pCurrentPassengers.stream().filter(p_275361_ -> !pInitialPassengers.contains(p_275361_));
    }
}

